/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.plugins.raw;

import it.agilelab.bigdata.wasp.consumers.spark.plugins.raw.RawSparkReaderUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.readers.SparkBatchReader;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.hdfs.HdfsUtils$;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.datastores.DatastoreProduct$;
import it.agilelab.bigdata.wasp.models.RawModel;
import it.agilelab.bigdata.wasp.models.RawOptions;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4A\u0001C\u0005\u00015!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\t\r!\u0003\u0001\u0015!\u0003>\u0011\u001dI\u0005A1A\u0005\u0002qBaA\u0013\u0001!\u0002\u0013i\u0004\"B&\u0001\t\u0003b%a\u0005*boN\u0003\u0018M]6CCR\u001c\u0007NU3bI\u0016\u0014(B\u0001\u0006\f\u0003\r\u0011\u0018m\u001e\u0006\u0003\u00195\tq\u0001\u001d7vO&t7O\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\nG>t7/^7feNT!AE\n\u0002\t]\f7\u000f\u001d\u0006\u0003)U\tqAY5hI\u0006$\u0018M\u0003\u0002\u0017/\u0005A\u0011mZ5mK2\f'MC\u0001\u0019\u0003\tIGo\u0001\u0001\u0014\t\u0001Y\u0012e\n\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011j\u0011a\u0002:fC\u0012,'o]\u0005\u0003M\r\u0012\u0001c\u00159be.\u0014\u0015\r^2i%\u0016\fG-\u001a:\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003YE\tAaY8sK&\u0011a&\u000b\u0002\b\u0019><w-\u001b8h\u0003!\u0011\u0018m^'pI\u0016d\u0007CA\u00195\u001b\u0005\u0011$BA\u001a\u0012\u0003\u0019iw\u000eZ3mg&\u0011QG\r\u0002\t%\u0006<Xj\u001c3fY\u00061A(\u001b8jiz\"\"\u0001\u000f\u001e\u0011\u0005e\u0002Q\"A\u0005\t\u000b=\u0012\u0001\u0019\u0001\u0019\u0002\t9\fW.Z\u000b\u0002{A\u0011a(\u0012\b\u0003\u007f\r\u0003\"\u0001Q\u000f\u000e\u0003\u0005S!AQ\r\u0002\rq\u0012xn\u001c;?\u0013\t!U$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u0013aa\u0015;sS:<'B\u0001#\u001e\u0003\u0015q\u0017-\\3!\u0003)\u0011X-\u00193feRK\b/Z\u0001\fe\u0016\fG-\u001a:UsB,\u0007%\u0001\u0003sK\u0006$GCA'd!\tq\u0005M\u0004\u0002P;:\u0011\u0001K\u0017\b\u0003#bs!AU+\u000f\u0005\u0001\u001b\u0016\"\u0001+\u0002\u0007=\u0014x-\u0003\u0002W/\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0005\u0003\u001deS!AV,\n\u0005mc\u0016aA:rY*\u0011a\"W\u0005\u0003=~\u000bq\u0001]1dW\u0006<WM\u0003\u0002\\9&\u0011\u0011M\u0019\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!AX0\t\u000b\u0011<\u0001\u0019A3\u0002\u0005M\u001c\u0007C\u00014h\u001b\u0005a\u0016B\u00015]\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0001")
public class RawSparkBatchReader
implements SparkBatchReader,
Logging {
    private final RawModel rawModel;
    private final String name;
    private final String readerType;
    private final WaspLogger logger;

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public String name() {
        return this.name;
    }

    public String readerType() {
        return this.readerType;
    }

    public Dataset<Row> read(SparkContext sc) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Initialize Spark HDFSReader with this model: ").append($this.rawModel).toString());
        SparkSession sqlContext = SparkSession$.MODULE$.builder().getOrCreate();
        StructType schema = (StructType)DataType$.MODULE$.fromJson(this.rawModel.schema());
        RawOptions options = this.rawModel.options();
        scala.collection.immutable.Map extraOptions = (scala.collection.immutable.Map)options.extraOptions().getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        DataFrameReader reader = sqlContext.read().schema(schema).format(options.format()).options((Map)extraOptions);
        String path = HdfsUtils$.MODULE$.getRawModelPathToToLoad(this.rawModel, sc);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Load this path: '").append(path).append("'").toString());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> RawSparkReaderUtils$.MODULE$.printExtraOptions($this.rawModel.name(), (scala.collection.immutable.Map<String, String>)extraOptions));
        return reader.load(path);
    }

    public RawSparkBatchReader(RawModel rawModel) {
        this.rawModel = rawModel;
        Logging.$init$((Logging)this);
        this.name = rawModel.name();
        this.readerType = DatastoreProduct$.MODULE$.RawProduct().getActualProductName();
    }
}

