/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.repository.mongo.utils;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.SocketSettings;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.models.configuration.MongoDBConfigModel;
import it.agilelab.bigdata.wasp.repository.mongo.utils.MongoDBHelper;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoClientSettings$;
import org.mongodb.scala.MongoCredential$;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.Observable;
import org.mongodb.scala.WriteConcern$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public final class MongoDBHelper$
implements Logging {
    public static MongoDBHelper$ MODULE$;
    private FiniteDuration it$agilelab$bigdata$wasp$repository$mongo$utils$MongoDBHelper$$resultTimeout;
    private MongoClient mongoClient;
    private final WaspLogger logger;

    static {
        new MongoDBHelper$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public FiniteDuration it$agilelab$bigdata$wasp$repository$mongo$utils$MongoDBHelper$$resultTimeout() {
        return this.it$agilelab$bigdata$wasp$repository$mongo$utils$MongoDBHelper$$resultTimeout;
    }

    private void it$agilelab$bigdata$wasp$repository$mongo$utils$MongoDBHelper$$resultTimeout_$eq(FiniteDuration x$1) {
        this.it$agilelab$bigdata$wasp$repository$mongo$utils$MongoDBHelper$$resultTimeout = x$1;
    }

    private MongoClient mongoClient() {
        return this.mongoClient;
    }

    private void mongoClient_$eq(MongoClient x$1) {
        this.mongoClient = x$1;
    }

    public <C> MongoDBHelper.DocumentObservable<C> DocumentObservable(Observable<Document> observable) {
        return new MongoDBHelper.DocumentObservable(observable);
    }

    public <C> MongoDBHelper.GenericObservable<C> GenericObservable(Observable<C> observable) {
        return new MongoDBHelper.GenericObservable<C>(observable);
    }

    public void close() {
        block0: {
            if (this.mongoClient() == null) break block0;
            this.mongoClient().close();
        }
    }

    public MongoDatabase getDatabase(MongoDBConfigModel mongoDBConfig) {
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings$.MODULE$.builder().applyConnectionString(new ConnectionString(mongoDBConfig.address())).writeConcern(WriteConcern$.MODULE$.ACKNOWLEDGED().withFsync(true)).applyToSocketSettings((Block)new Block<SocketSettings.Builder>(mongoDBConfig){
            private final MongoDBConfigModel mongoDBConfig$1;

            public void apply(SocketSettings.Builder t) {
                t.connectTimeout(this.mongoDBConfig$1.millisecondsTimeoutConnection(), TimeUnit.MILLISECONDS).readTimeout(this.mongoDBConfig$1.millisecondsTimeoutConnection(), TimeUnit.MILLISECONDS);
            }
            {
                this.mongoDBConfig$1 = mongoDBConfig$1;
            }
        });
        String string = mongoDBConfig.username();
        String string2 = "";
        MongoClientSettings settings = (string == null ? string2 != null : !string.equals(string2)) ? settingsBuilder.credential(MongoCredential$.MODULE$.createCredential(mongoDBConfig.username(), mongoDBConfig.credentialDb(), mongoDBConfig.password().toCharArray())).build() : settingsBuilder.build();
        this.it$agilelab$bigdata$wasp$repository$mongo$utils$MongoDBHelper$$resultTimeout_$eq(Duration$.MODULE$.apply((long)mongoDBConfig.millisecondsTimeoutConnection(), TimeUnit.MILLISECONDS));
        this.mongoClient_$eq(MongoClient$.MODULE$.apply(settings));
        MongoDatabase mongoDatabase = this.mongoClient().getDatabase(mongoDBConfig.databaseName());
        this.GenericObservable(mongoDatabase.listCollectionNames()).results();
        return mongoDatabase;
    }

    public Map<String, Object> bsonDocumentToMap(BsonDocument bsonDocument) {
        Set entries = (Set)JavaConverters$.MODULE$.asScalaSetConverter(bsonDocument.entrySet()).asScala();
        return ((TraversableOnce)entries.map((Function1 & Serializable & scala.Serializable)entry -> {
            Map<String, Object> map;
            String key = (String)entry.getKey();
            BsonValue bsonValue = (BsonValue)entry.getValue();
            if (bsonValue instanceof BsonBoolean) {
                BsonBoolean bsonBoolean = (BsonBoolean)bsonValue;
                map = BoxesRunTime.boxToBoolean((boolean)bsonBoolean.getValue());
            } else if (bsonValue instanceof BsonInt32) {
                BsonInt32 bsonInt32 = (BsonInt32)bsonValue;
                map = BoxesRunTime.boxToInteger((int)bsonInt32.intValue());
            } else if (bsonValue instanceof BsonInt64) {
                BsonInt64 bsonInt64 = (BsonInt64)bsonValue;
                map = BoxesRunTime.boxToLong((long)bsonInt64.longValue());
            } else if (bsonValue instanceof BsonDouble) {
                BsonDouble bsonDouble = (BsonDouble)bsonValue;
                map = BoxesRunTime.boxToDouble((double)bsonDouble.doubleValue());
            } else if (bsonValue instanceof BsonString) {
                BsonString bsonString = (BsonString)bsonValue;
                map = bsonString.getValue();
            } else if (bsonValue instanceof BsonDocument) {
                BsonDocument bsonDocument = (BsonDocument)bsonValue;
                map = MODULE$.bsonDocumentToMap(bsonDocument);
            } else {
                map = bsonValue;
            }
            Boolean value = map;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public String printMongoConfigModel(MongoDBConfigModel mongoDBConfigModel) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(190).append("address: ").append(mongoDBConfigModel.address()).append(",\n         |databaseName: ").append(mongoDBConfigModel.databaseName()).append(",\n         |username: ").append(mongoDBConfigModel.username()).append(",\n         |password: ************,\n         |credentialDb: ").append(mongoDBConfigModel.credentialDb()).append(",\n         |millisecondsTimeoutConnection: ").append(mongoDBConfigModel.millisecondsTimeoutConnection()).append(",\n         |collectionPrefix: ").append(mongoDBConfigModel.collectionPrefix()).toString())).stripMargin();
    }

    private MongoDBHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.it$agilelab$bigdata$wasp$repository$mongo$utils$MongoDBHelper$$resultTimeout = Duration$.MODULE$.apply(10L, TimeUnit.SECONDS);
    }
}

