/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Kafka$;
import org.apache.spark.internal.config.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class KafkaTokenUtil$
implements Logging {
    public static KafkaTokenUtil$ MODULE$;
    private final Text TOKEN_KIND;
    private final Text TOKEN_SERVICE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KafkaTokenUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Text TOKEN_KIND() {
        return this.TOKEN_KIND;
    }

    public Text TOKEN_SERVICE() {
        return this.TOKEN_SERVICE;
    }

    public Tuple2<Token<? extends TokenIdentifier>, Object> obtainToken(SparkConf sparkConf) {
        this.checkProxyUser();
        AdminClient adminClient = AdminClient.create((Properties)this.createAdminClientProperties(sparkConf));
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions();
        CreateDelegationTokenResult createResult = adminClient.createDelegationToken(createDelegationTokenOptions);
        DelegationToken token = (DelegationToken)createResult.delegationToken().get();
        this.printToken(token);
        return new Tuple2((Object)new Token(token.tokenInfo().tokenId().getBytes(), token.hmacAsBase64String().getBytes(), this.TOKEN_KIND(), this.TOKEN_SERVICE()), (Object)BoxesRunTime.boxToLong((long)token.tokenInfo().expiryTimestamp()));
    }

    public void checkProxyUser() {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        Predef$.MODULE$.require(!SparkHadoopUtil$.MODULE$.get().isProxyUser(currentUser), (Function0 & Serializable & scala.Serializable)() -> "Obtaining delegation token for proxy user is not yet supported.");
    }

    /*
     * WARNING - void declaration
     */
    public Properties createAdminClientProperties(SparkConf sparkConf) {
        void var3_2;
        Object object;
        Properties adminClientProperties = new Properties();
        Option bootstrapServers = (Option)sparkConf.get(Kafka$.MODULE$.BOOTSTRAP_SERVERS());
        Predef$.MODULE$.require(bootstrapServers.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Tried to obtain kafka delegation token but bootstrap ").append("servers not configured.").toString());
        adminClientProperties.put("bootstrap.servers", bootstrapServers.get());
        String protocol = (String)sparkConf.get(Kafka$.MODULE$.SECURITY_PROTOCOL());
        adminClientProperties.put("security.protocol", protocol);
        String string = protocol;
        String string2 = SecurityProtocol.SASL_SSL.name;
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.setTrustStoreProperties(sparkConf, adminClientProperties);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = SecurityProtocol.SSL.name;
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.setTrustStoreProperties(sparkConf, adminClientProperties);
                this.setKeyStoreProperties(sparkConf, adminClientProperties);
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Obtaining kafka delegation token with SSL protocol. Please configure 2-way authentication on the broker side.");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = SecurityProtocol.SASL_PLAINTEXT.name;
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Obtaining kafka delegation token through plain communication channel. Please consider the security impact.");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
        if (this.isGlobalJaasConfigurationProvided()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "JVM global security configuration detected, using it for login.");
            object = BoxedUnit.UNIT;
        } else {
            adminClientProperties.put("sasl.mechanism", "GSSAPI");
            if (sparkConf.contains((ConfigEntry)package$.MODULE$.KEYTAB())) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Keytab detected, using it for login.");
                String jaasParams = this.getKeytabJaasParams(sparkConf);
                object = adminClientProperties.put("sasl.jaas.config", jaasParams);
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using ticket cache for login.");
                String jaasParams = this.getTicketCacheJaasParams(sparkConf);
                object = adminClientProperties.put("sasl.jaas.config", jaasParams);
            }
        }
        return var3_2;
    }

    public boolean isGlobalJaasConfigurationProvided() {
        boolean bl;
        try {
            JaasContext.loadClientContext(Collections.emptyMap());
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private void setTrustStoreProperties(SparkConf sparkConf, Properties properties) {
        ((Option)sparkConf.get(Kafka$.MODULE$.TRUSTSTORE_LOCATION())).foreach((Function1 & Serializable & scala.Serializable)truststoreLocation -> properties.put("ssl.truststore.location", truststoreLocation));
        ((Option)sparkConf.get(Kafka$.MODULE$.TRUSTSTORE_PASSWORD())).foreach((Function1 & Serializable & scala.Serializable)truststorePassword -> properties.put("ssl.truststore.password", truststorePassword));
    }

    private void setKeyStoreProperties(SparkConf sparkConf, Properties properties) {
        ((Option)sparkConf.get(Kafka$.MODULE$.KEYSTORE_LOCATION())).foreach((Function1 & Serializable & scala.Serializable)keystoreLocation -> properties.put("ssl.keystore.location", keystoreLocation));
        ((Option)sparkConf.get(Kafka$.MODULE$.KEYSTORE_PASSWORD())).foreach((Function1 & Serializable & scala.Serializable)keystorePassword -> properties.put("ssl.keystore.password", keystorePassword));
        ((Option)sparkConf.get(Kafka$.MODULE$.KEY_PASSWORD())).foreach((Function1 & Serializable & scala.Serializable)keyPassword -> properties.put("ssl.key.password", keyPassword));
    }

    /*
     * WARNING - void declaration
     */
    public String getKeytabJaasParams(SparkConf sparkConf) {
        void var2_2;
        String params = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n      |").append(this.getKrb5LoginModuleName()).append(" required\n      | useKeyTab=true\n      | serviceName=\"").append(sparkConf.get(Kafka$.MODULE$.KERBEROS_SERVICE_NAME())).append("\"\n      | keyTab=\"").append(((Option)sparkConf.get((ConfigEntry)package$.MODULE$.KEYTAB())).get()).append("\"\n      | principal=\"").append(((Option)sparkConf.get((ConfigEntry)package$.MODULE$.PRINCIPAL())).get()).append("\";\n      ").toString())).stripMargin().replace("\n", "");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Krb keytab JAAS params: ").append(params).toString());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String getTicketCacheJaasParams(SparkConf sparkConf) {
        void var3_3;
        String serviceName = (String)sparkConf.get(Kafka$.MODULE$.KERBEROS_SERVICE_NAME());
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(serviceName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Kerberos service name must be defined");
        String params = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(76).append("\n      |").append(this.getKrb5LoginModuleName()).append(" required\n      | useTicketCache=true\n      | serviceName=\"").append(sparkConf.get(Kafka$.MODULE$.KERBEROS_SERVICE_NAME())).append("\";\n      ").toString())).stripMargin().replace("\n", "");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Krb ticket cache JAAS params: ").append(params).toString());
        return var3_3;
    }

    private String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    private void printToken(DelegationToken token) {
        block0: {
            if (!this.log().isDebugEnabled()) break block0;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"TOKENID", "HMAC", "OWNER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE"})));
            TokenInformation tokenInfo = token.tokenInfo();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%-15s [hidden] %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokenInfo.tokenId(), tokenInfo.owner(), tokenInfo.renewersAsString(), dateFormat.format(BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp())), dateFormat.format(BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp())), dateFormat.format(BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp()))})));
        }
    }

    private KafkaTokenUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.TOKEN_KIND = new Text("KAFKA_DELEGATION_TOKEN");
        this.TOKEN_SERVICE = new Text("kafka.server.delegation.token");
    }
}

