/*
 * Decompiled with CFR 0.152.
 */
package it.burning.cron;

import it.burning.utils.RxReplace;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class CronExpressionParser {
    private static final String LOCALIZATION_BUNDLE = "localization";
    private static final int MIN_YEAR = 1970;
    private static final int MAX_YEAR = 2099;
    private static final int MIN_YEAR_FREQUENCY = 0;
    private static final int MAX_YEAR_FREQUENCY = 129;
    private final Pattern secsAndMinsValidationPattern = Pattern.compile("^(?:\\*|^0)$|^(?:[0-5]?[0-9])$|^(?:(?:\\*|[0-5]?[0-9])/[0-5]?[0-9])$|^(?:([0-5]?[0-9],)*)(?:(?!^)[0-5]?[0-9])$|^(?:[0-5]?[0-9])-(?:[0-5]?[0-9])$|^(?:[0-5]?[0-9])-(?:[0-5]?[0-9])/(?:[0-5]?[0-9])$");
    private final Pattern hoursValidationPattern = Pattern.compile("^(?:\\*|^0)$|^(?:[0-1]?[0-9]|2?[0-3])$|^(?:(?:\\*|[0-1]?[0-9])|(?:2[0-3]))/(?:(?:[0-1]?[0-9])|(?:2[0-3]))$|^(?:(?:[0-1]?[0-9],)|(?:2[0-3],))*(?:(?:(?!^)[0-1]?[0-9])|(?:(?!^)2[0-3]))$|^(?:(?:[0-1]?[0-9])|(?:2[0-3]))-(?:(?:[0-1]?[0-9])|(?:2[0-3]))$|^(?:(?:[0-1]?[0-9])|(?:2[0-3]))-(?:(?:[0-1]?[0-9])|(?:2[0-3]))/(?:(?:[0-1]?[0-9])|(?:2[0-3]))$");
    private final Pattern domValidationPattern = Pattern.compile("^(?:\\*)$|^(?:[1-9]|1[0-9]|2[0-9]|3[0-1])$|^(?:\\*|[1-9]|1[0-9]|2[0-9]|3[0-1])/(?:[0-9]|1[0-9]|2[0-9]|3[0-1])$|^(?:(?:[1-9],)|(?:1[0-9],)|(?:2[0-9],)|(?:3[0-1],))+(?:(?:[1-9])|(?:1[0-9])|(?:2[0-9])|(?:3[0-1]))$|^(?:(?:[1-9]|1[0-9]|2[0-9]|3[0-1])-(?:[1-9]|1[0-9]|2[0-9]|3[0-1]))$|^(?:(?:[1-9]|1[0-9]|2[0-9]|3[0-1])-(?:[1-9]|1[0-9]|2[0-9]|3[0-1]))/(?:[0-9]|1[0-9]|2[0-9]|3[0-1])$|^(?:(?:L)|(?:LW)|(?:L)-(?:[1-9]|1[0-9]|2[0-9]|30)|(?:(?:[1-9]|1[0-9]|2[0-9]|3[0-1])W))$");
    private final Pattern monthsValidationPattern = Pattern.compile("^(?:\\*)$|^(?:[1-9]|1[0-2])$|^(?:\\*|[1-9]|1[0-2])/(?:[0-9]|1[0-2])$|^(?:[1-9],|1[0-2],)*(?:(?!^)[1-9]|(?!^)1[0-2])$|^(?:[1-9]|1[0-2])-(?:[1-9]|1[0-2])$|^(?:[1-9]|1[0-2])-(?:[1-9]|1[0-2])/(?:[0-9]|1[0-2])$");
    private final Pattern dowValidationPattern = Pattern.compile("^(?:\\*)$|^(?:[0-6])$|^(?:\\*|[0-6])/(?:[0-6])$|^(?:[0-6],)*(?:(?!^)[0-6])$|^(?:[0-6])-(?:[0-6])$|^(?:[0-6])-(?:[0-6])/(?:[0-7])$|^(?:[0-6]L)$|^(?:[0-6]#[1-5])$");
    private final Pattern yearsValidationPattern = Pattern.compile("^(?:\\*)$|^\\d{4}$|^(?:\\*|\\d{4})/(?:\\d{1,3})$|^(?:\\d{4},)*(?:(?!^)\\d{4})$|^(?:\\d{4})-(?:\\d{4})$|^(?:\\d{4})-(?:\\d{4})/(?:\\d{1,3})$");
    private final Pattern yearPattern = Pattern.compile(".*\\d{4}$");
    private final Pattern rangeTokenSearchPattern = Pattern.compile("[*/]");
    private final Pattern stepValueSearchPattern = Pattern.compile("[*\\-,]");
    private final Pattern singleItemTokenPattern = Pattern.compile("^[0-9]+$");
    private final RxReplace dowReplacer = new RxReplace("(^\\d)|([^#/\\s]\\d)"){

        @Override
        public String replacement() {
            String dowDigits;
            String value = this.group(1) != null ? this.group(1) : this.group(2);
            String dowDigitsAdjusted = dowDigits = value.replaceAll("\\D", "");
            if (Integer.parseInt(dowDigits) > 7) {
                throw new CronExpressionParseException(String.format(CronExpressionParser.this.getString("InvalidFieldExpressionFormat"), CronExpressionParser.this.getString("InvalidFieldDoW")), CronExpressionPart.DOW);
            }
            if (CronExpressionParser.this.partsCount == 5) {
                if (dowDigits.equals("7")) {
                    dowDigitsAdjusted = "0";
                }
            } else {
                dowDigitsAdjusted = String.valueOf(Integer.parseInt(dowDigits) - 1);
            }
            return value.replace(dowDigits, dowDigitsAdjusted);
        }
    };
    private final String expression;
    private final Options options;
    private final ResourceBundle localization;
    private int partsCount;

    public CronExpressionParser(String expression) {
        this(expression, null);
    }

    public CronExpressionParser(String expression, Options options) {
        this.expression = expression;
        this.options = options != null ? options : new Options();
        this.localization = ResourceBundle.getBundle(LOCALIZATION_BUNDLE, this.options.getLocale());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] parse() {
        String[] rangeParts;
        String[] parsed = new String[]{"", "", "", "", "", "", ""};
        String[] tokenizedExpression = this.expression.split(" ");
        ArrayList<String> tmp = new ArrayList<String>();
        for (String token : tokenizedExpression) {
            if (token.isEmpty()) continue;
            tmp.add(token);
        }
        String[] expressionParts = new String[tmp.size()];
        tmp.toArray(expressionParts);
        this.partsCount = expressionParts.length;
        if (this.partsCount < 5) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidExpressionFormatTooFewParts"), this.expression, this.partsCount), CronExpressionPart.ALL);
        }
        if (this.partsCount == 5) {
            System.arraycopy(expressionParts, 0, parsed, 1, 5);
        } else if (this.partsCount == 6) {
            boolean isYearWithNoSecondsPart;
            boolean bl = isYearWithNoSecondsPart = this.yearPattern.matcher(expressionParts[5]).matches() || expressionParts[4].equals("?") || expressionParts[2].equals("?");
            if (isYearWithNoSecondsPart) {
                System.arraycopy(expressionParts, 0, parsed, 1, 6);
            } else {
                System.arraycopy(expressionParts, 0, parsed, 0, 6);
            }
        } else if (this.partsCount == 7) {
            System.arraycopy(expressionParts, 0, parsed, 0, 7);
        } else if (this.options.throwExceptionOnParseError) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidExpressionFormatTooManyParts"), this.expression, this.partsCount), CronExpressionPart.ALL);
        }
        this.normalizeExpression(parsed);
        if (this.partsCount > 5 && !parsed[3].equals("*") && !parsed[5].equals("*")) {
            throw new CronExpressionParseException(this.getString("InvalidDomDowExpression"), CronExpressionPart.ALL);
        }
        if (this.partsCount > 5 && !parsed[0].isEmpty() && !this.secsAndMinsValidationPattern.matcher(parsed[0]).matches()) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldSecond")), CronExpressionPart.SEC);
        }
        if (parsed[1].isEmpty() || !this.secsAndMinsValidationPattern.matcher(parsed[1]).matches()) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldMinute")), CronExpressionPart.MIN);
        }
        if (parsed[2].isEmpty() || !this.hoursValidationPattern.matcher(parsed[2]).matches()) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldHour")), CronExpressionPart.HOUR);
        }
        if (parsed[3].isEmpty() || !this.domValidationPattern.matcher(parsed[3]).matches()) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldDoM")), CronExpressionPart.DOM);
        }
        if (parsed[4].isEmpty() || !this.monthsValidationPattern.matcher(parsed[4]).matches()) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldMonth")), CronExpressionPart.MONTH);
        }
        if (parsed[5].isEmpty() || !this.dowValidationPattern.matcher(parsed[5]).matches()) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldDoW")), CronExpressionPart.DOW);
        }
        if (this.partsCount > 5 && !parsed[6].isEmpty() && !this.yearsValidationPattern.matcher(parsed[6]).matches()) {
            throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldYear")), CronExpressionPart.YEAR);
        }
        if (parsed[6].isEmpty() || !this.yearsValidationPattern.matcher(parsed[6]).matches()) return parsed;
        if (this.partsCount > 5 && parsed[6].contains("/")) {
            String[] rangeParts2;
            String[] frequencyParts = parsed[6].split("/");
            if (frequencyParts.length != 2) throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), this.getString("InvalidFieldYear")), CronExpressionPart.YEAR);
            if (frequencyParts[0].contains("-") ? (rangeParts2 = frequencyParts[0].split("-")).length == 2 && (Integer.parseInt(rangeParts2[0]) < 1970 || Integer.parseInt(rangeParts2[0]) > 2099 || Integer.parseInt(rangeParts2[1]) < 1970 || Integer.parseInt(rangeParts2[1]) > 2099) : !frequencyParts[0].equals("*") && (Integer.parseInt(frequencyParts[0]) < 1970 || Integer.parseInt(frequencyParts[0]) > 2099)) {
                throw new CronExpressionParseException(String.format(this.getString("InvalidYearsRangeValue"), 1970, 2099), CronExpressionPart.YEAR);
            }
            if (Integer.parseInt(frequencyParts[1]) >= 0 && Integer.parseInt(frequencyParts[1]) <= 129) return parsed;
            throw new CronExpressionParseException(String.format(this.getString("InvalidYearFrequencyValue"), 0, 129), CronExpressionPart.YEAR);
        }
        if (!(parsed[6].contains("-") ? Integer.parseInt((rangeParts = parsed[6].split("-"))[0]) < 1970 || Integer.parseInt(rangeParts[0]) > 2099 || Integer.parseInt(rangeParts[1]) < 1970 || Integer.parseInt(rangeParts[1]) > 2099 : !parsed[6].equals("*") && (Integer.parseInt(parsed[6]) < 1970 || Integer.parseInt(parsed[6]) > 2099))) return parsed;
        throw new CronExpressionParseException(String.format(this.getString("InvalidYearsRangeValue"), 1970, 2099), CronExpressionPart.YEAR);
    }

    private void normalizeExpression(String[] parsed) {
        int i;
        parsed[3] = parsed[3].replace("?", "*");
        parsed[5] = parsed[5].replace("?", "*");
        if (parsed[0].startsWith("0/")) {
            parsed[0] = parsed[0].replace("0/", "*/");
        }
        if (parsed[1].startsWith("0/")) {
            parsed[1] = parsed[1].replace("0/", "*/");
        }
        if (parsed[2].startsWith("0/")) {
            parsed[2] = parsed[2].replace("0/", "*/");
        }
        if (parsed[3].startsWith("1/")) {
            parsed[3] = parsed[3].replace("1/", "*/");
        }
        if (parsed[4].startsWith("1/")) {
            parsed[4] = parsed[4].replace("1/", "*/");
        }
        if (parsed[5].startsWith("1/")) {
            parsed[5] = parsed[5].replace("1/", "*/");
        }
        if (parsed[6].startsWith("1/")) {
            parsed[6] = parsed[6].replace("1/", "*/");
        }
        parsed[5] = this.dowReplacer.replace(parsed[5]);
        if (parsed[3].equals("?")) {
            parsed[3] = "*";
        }
        for (i = 0; i <= 6; ++i) {
            String currentDay = Day.values()[i].name();
            parsed[5] = parsed[5].replace(currentDay, String.valueOf(i));
            if (parsed[5].length() == 1) break;
        }
        for (i = 0; i < 12; ++i) {
            String currentMonth = Month.values()[i].name();
            parsed[4] = parsed[4].replace(currentMonth, String.valueOf(i + 1));
            if (parsed[4].length() == 1 || parsed[4].length() == 2) break;
        }
        if (parsed[0].equals("0")) {
            parsed[0] = "";
        }
        if (this.singleItemTokenPattern.matcher(parsed[2]).matches() && (this.rangeTokenSearchPattern.matcher(parsed[1]).find() || this.rangeTokenSearchPattern.matcher(parsed[0]).find())) {
            parsed[2] = parsed[2] + "-" + parsed[2];
        }
        for (i = 0; i < parsed.length; ++i) {
            String[] parts;
            if (parsed[i].equals("*/1")) {
                parsed[i] = "*";
            }
            if ((parts = parsed[i].split("/")).length > 1 && parts[0].isEmpty()) {
                parsed[i] = "*/" + parts[1];
            }
            if (!parsed[i].contains("/") || this.stepValueSearchPattern.matcher(parsed[i]).find()) continue;
            String stepRangeThrough = null;
            switch (i) {
                case 4: {
                    stepRangeThrough = "12";
                    break;
                }
                case 5: {
                    stepRangeThrough = "6";
                    break;
                }
                case 6: {
                    stepRangeThrough = String.valueOf(2099);
                    break;
                }
            }
            if (stepRangeThrough == null) continue;
            String[] steps = parsed[i].split("/");
            if (steps.length > 2) {
                String fieldString;
                CronExpressionPart errorRange;
                if (stepRangeThrough.equals("12")) {
                    errorRange = CronExpressionPart.MONTH;
                    fieldString = this.getString("InvalidFieldMonth");
                } else if (stepRangeThrough.equals("6")) {
                    errorRange = CronExpressionPart.DOW;
                    fieldString = this.getString("InvalidFieldDoW");
                } else {
                    errorRange = CronExpressionPart.YEAR;
                    fieldString = this.getString("InvalidFieldYear");
                }
                throw new CronExpressionParseException(String.format(this.getString("InvalidFieldExpressionFormat"), fieldString), errorRange);
            }
            parsed[i] = String.format("%d-%d/%d", Integer.parseInt(steps[0]), Integer.parseInt(stepRangeThrough), Integer.parseInt(steps[1]));
        }
    }

    protected String getString(String resourceName) {
        try {
            return this.localization.getString(resourceName);
        }
        catch (MissingResourceException e) {
            return "{{" + resourceName + "}}";
        }
    }

    public static class Options {
        private boolean throwExceptionOnParseError = true;
        private boolean verbose = false;
        private boolean use24HourTimeFormat = true;
        private Locale locale = Locale.getDefault();

        public boolean isThrowExceptionOnParseError() {
            return this.throwExceptionOnParseError;
        }

        public void setThrowExceptionOnParseError(boolean throwExceptionOnParseError) {
            this.throwExceptionOnParseError = throwExceptionOnParseError;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean use24HourTimeFormat() {
            return this.use24HourTimeFormat;
        }

        public void setUse24HourTimeFormat(boolean use24HourTimeFormat) {
            this.use24HourTimeFormat = use24HourTimeFormat;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(String language) {
            this.setLocale(language != null ? new Locale(language) : Locale.getDefault());
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }
    }

    public static class CronExpressionParseException
    extends RuntimeException {
        final CronExpressionPart part;

        public CronExpressionPart getPart() {
            return this.part;
        }

        public CronExpressionParseException(String message, CronExpressionPart part) {
            super(message);
            this.part = part;
        }
    }

    public static enum Month {
        JAN,
        FEB,
        MAR,
        APR,
        MAY,
        JUN,
        JUL,
        AUG,
        SEP,
        OCT,
        NOV,
        DEC;

    }

    public static enum Day {
        SUN,
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT;

    }

    public static enum CronExpressionPart {
        SEC("SECOND"),
        MIN("MINUTE"),
        HOUR("HOUR"),
        DOM("DAY OF MONTH"),
        MONTH("MONTH"),
        DOW("DAY OF WEEK"),
        YEAR("YEAR"),
        ALL("EXPRESSION");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private CronExpressionPart(String value) {
            this.value = value;
        }
    }
}

