/*
 * Decompiled with CFR 0.152.
 */
package it.croway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.HttpEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import picocli.CommandLine;

@CommandLine.Command(name="JfrGrafanaExporter", mixinStandardHelpOptions=true, version={"0.0.1"}, description={"JfrGrafanaExporter made with jbang"})
public class JfrGrafanaExporter
implements Callable<Integer> {
    static final Logger LOGGER = LoggerFactory.getLogger(JfrGrafanaExporter.class);
    static final Network network = Network.newNetwork();
    static final GenericContainer<?> jfrDatasourceContainer = new GenericContainer("croway/jfr-datasource:2.1.0").withExposedPorts(new Integer[]{8080}).withNetwork(network).withNetworkAliases(new String[]{"jfr-datasource"});
    static final GenericContainer<?> grafanaContainer = new GenericContainer("grafana/grafana").withExposedPorts(new Integer[]{3000}).withNetwork(network).withNetworkAliases(new String[]{"grafana"}).withEnv("GF_INSTALL_PLUGINS", "grafana-simple-json-datasource").withEnv("GF_RENDERING_SERVER_URL", "http://grafana-image-renderer:8081/render").withEnv("GF_RENDERING_CALLBACK_URL", "http://grafana:3000").withEnv("GF_LOG_FILTERS", "rendering:debug").withClasspathResourceMapping("provisioning", "/etc/grafana/provisioning", BindMode.READ_WRITE).withClasspathResourceMapping("dashboards", "/var/lib/grafana/dashboards", BindMode.READ_WRITE);
    static final GenericContainer<?> grafanaRendererContainer = new GenericContainer("grafana/grafana-image-renderer").withExposedPorts(new Integer[]{8081}).withNetwork(network).withNetworkAliases(new String[]{"grafana-image-renderer"});
    long startTime = Long.MAX_VALUE;
    long endTime = Long.MIN_VALUE;
    ObjectMapper mapper = new ObjectMapper();
    @CommandLine.Parameters(index="0", description={"JFR File path"})
    private String jfrPath;
    @CommandLine.Parameters(index="1", description={"Reports path"}, defaultValue="reports")
    private String reportsPath;

    public static void main(String ... args) {
        int exitCode = new CommandLine((Object)new JfrGrafanaExporter()).execute(new String[]{"/home/federico/Work/croway/camel-performance-tests/profiling/timer-log/camel-recording17404718817072294048.jfr"});
        System.exit(exitCode);
    }

    private static String basicAuth(String username, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        try {
            this.startContainers();
            if (this.jfrPath == null) {
                throw new IllegalArgumentException("index 0, jfr recording path is required");
            }
            File jrfRecordFile = new File(this.jfrPath);
            this.computeStartEndTimeFromJfrRecord(jrfRecordFile);
            this.createExportDirectory();
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(20L)).build();
            String uid = this.getGrafanaDashboardUid("JFR Events", client);
            this.uploadJfrToJfrDatasource(jrfRecordFile);
            this.downloadPanels(client, uid);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            Integer n = 1;
            return n;
        }
        finally {
            jfrDatasourceContainer.stop();
            grafanaContainer.stop();
            grafanaRendererContainer.stop();
            network.close();
        }
        return 0;
    }

    private void downloadPanels(HttpClient client, String uid) throws IOException, InterruptedException {
        JsonNode node = (JsonNode)this.mapper.readValue(JfrGrafanaExporter.class.getResourceAsStream("/dashboards/camel-jfr.json"), JsonNode.class);
        List nodes = StreamSupport.stream(node.get("panels").spliterator(), false).collect(Collectors.toList());
        nodes.parallelStream().forEach(panel -> {
            try {
                URI uri = URI.create("http://localhost:" + grafanaContainer.getMappedPort(3000) + "/render/d-solo/" + uid + "/jfr-events?orgId=1&from=" + this.startTime + "&to=" + this.endTime + "&panelId=" + panel.get("id").asInt() + "&width=1000&height=500&tz=Europe/Rome");
                HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().header("Authorization", JfrGrafanaExporter.basicAuth("admin", "admin")).build();
                HttpResponse<InputStream> responseIS = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                LOGGER.info("png \"{}\" download response status {}", (Object)panel.get("title").asText(), (Object)responseIS.statusCode());
                try (FileOutputStream out = new FileOutputStream(this.reportsPath + File.separator + panel.get("title").asText() + ".png");){
                    responseIS.body().transferTo(out);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void uploadJfrToJfrDatasource(File jrfRecordFile) throws IOException {
        org.apache.http.HttpResponse returnResponse = Request.Post((String)("http://localhost:" + jfrDatasourceContainer.getMappedPort(8080) + "/load")).body(MultipartEntityBuilder.create().addPart("file", (ContentBody)new FileBody(jrfRecordFile)).build()).execute().returnResponse();
        LOGGER.info("jfrDatasourceResponse\n{}", (Object)EntityUtils.toString((HttpEntity)returnResponse.getEntity()));
        LOGGER.info("jfrDatasourceResponseCode {}", (Object)returnResponse.getStatusLine().getStatusCode());
    }

    private String getGrafanaDashboardUid(String jfr_events, HttpClient client) throws Exception {
        String uid = null;
        HttpRequest grafanaRequest = HttpRequest.newBuilder(new URI("http://localhost:" + grafanaContainer.getMappedPort(3000) + "/api/search?folderIds=0&query=&starred=false")).header("Authorization", JfrGrafanaExporter.basicAuth("admin", "admin")).GET().build();
        HttpResponse<String> response = client.send(grafanaRequest, HttpResponse.BodyHandlers.ofString());
        JsonNode jsonNode = (JsonNode)this.mapper.readValue(response.body(), JsonNode.class);
        for (JsonNode dashboardNode : jsonNode) {
            if (!"JFR Events".equals(dashboardNode.get("title").asText())) continue;
            uid = dashboardNode.get("uid").asText();
        }
        LOGGER.info("Dashboard uid {}", uid);
        LOGGER.info("jfrPath {}", (Object)this.jfrPath);
        return uid;
    }

    private void createExportDirectory() {
        File reports = new File(this.reportsPath);
        if (!reports.exists()) {
            reports.mkdirs();
        }
        LOGGER.info("reports path {}", (Object)reports.getAbsolutePath());
    }

    @NotNull
    private File computeStartEndTimeFromJfrRecord(File file) throws IOException, CouldNotLoadRecordingException {
        IItemCollection itemCollection = JfrLoaderToolkit.loadEvents((File)file);
        for (IItemIterable item : itemCollection) {
            if (!item.hasItems()) continue;
            IType type = item.getType();
            List attributes = type.getAttributes();
            for (IAttribute attribute : attributes) {
                IMemberAccessor accessor;
                if (attribute.getIdentifier().contains("startTime")) {
                    IMemberAccessor startTimeAccessor = JfrAttributes.START_TIME.getAccessor(type);
                    accessor = ItemToolkit.accessor((IAttribute)attribute);
                    for (IItem it : item) {
                        try {
                            if (this.startTime <= ((IQuantity)startTimeAccessor.getMember((Object)it)).longValueIn((IUnit)UnitLookup.EPOCH_MS)) continue;
                            this.startTime = ((IQuantity)startTimeAccessor.getMember((Object)it)).longValueIn((IUnit)UnitLookup.EPOCH_MS);
                        }
                        catch (QuantityConversionException quantityConversionException) {}
                    }
                }
                if (!attribute.getIdentifier().contains("endTime")) continue;
                IMemberAccessor endTimeAccessor = JfrAttributes.END_TIME.getAccessor(type);
                accessor = ItemToolkit.accessor((IAttribute)attribute);
                for (IItem it : item) {
                    try {
                        if (this.endTime >= ((IQuantity)endTimeAccessor.getMember((Object)it)).longValueIn((IUnit)UnitLookup.EPOCH_MS)) continue;
                        this.endTime = ((IQuantity)endTimeAccessor.getMember((Object)it)).longValueIn((IUnit)UnitLookup.EPOCH_MS);
                    }
                    catch (QuantityConversionException quantityConversionException) {}
                }
            }
        }
        return file;
    }

    private void startContainers() {
        LOGGER.debug("network id {}", (Object)network.getId());
        jfrDatasourceContainer.start();
        grafanaRendererContainer.start();
        grafanaContainer.start();
    }
}

