/*
 * Decompiled with CFR 0.152.
 */
package it.eng.spago.dispatching.httpchannel;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import it.eng.spago.base.PortletAccess;
import it.eng.spago.base.PortletSessionContainer;
import it.eng.spago.base.RequestContainer;
import it.eng.spago.base.ResponseContainer;
import it.eng.spago.base.SessionContainer;
import it.eng.spago.base.SourceBean;
import it.eng.spago.base.XMLObject;
import it.eng.spago.configuration.ConfigSingleton;
import it.eng.spago.dispatching.action.NavigationErrorUtility;
import it.eng.spago.dispatching.action.SessionExpiredUtility;
import it.eng.spago.dispatching.coordinator.CoordinatorIFace;
import it.eng.spago.dispatching.coordinator.DispatcherManager;
import it.eng.spago.dispatching.httpchannel.RouterPortlet;
import it.eng.spago.dispatching.service.DefaultRequestContext;
import it.eng.spago.dispatching.service.RequestContextIFace;
import it.eng.spago.error.EMFAbstractError;
import it.eng.spago.error.EMFErrorHandler;
import it.eng.spago.error.EMFInternalError;
import it.eng.spago.init.PortletInitializerManager;
import it.eng.spago.navigation.LightNavigationManager;
import it.eng.spago.navigation.NavigationException;
import it.eng.spago.navigation.Navigator;
import it.eng.spago.presentation.PresentationRendering;
import it.eng.spago.presentation.Publisher;
import it.eng.spago.presentation.PublisherConfiguration;
import it.eng.spago.tracing.TracerSingleton;
import it.eng.spago.util.PortletTracer;
import it.eng.spago.util.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class AdapterPortlet
extends GenericPortlet {
    public static final String NEW_SESSION = "NEW_SESSION";
    public static final String HTTP_CONTENT_TYPE = "text/html";
    public static final String WAP_CONTENT_TYPE = "text/vnd.wap.wml";
    public static final String HTTP_ACCEPT_HEADER = "ACCEPT";
    public static final String WAP_MIME_TYPE = "vnd.wap";
    public static final String HTTP_SESSION_ID = "HTTP_SESSION_ID";
    private static final String SERVLET_PUBLISHER_TYPE = "SERVLET";
    private static final String JSP_PUBLISHER_TYPE = "JSP";
    private static final String FORWARD_PUBLISHING_MODE = "FORWARD";
    private static final String SERIALIZE_SESSION_ATTRIBUTE = "COMMON.SERIALIZE_SESSION";
    private static final String SERVICE_EXCEPTION = "SERVICE_EXCEPTION";
    private static final String PORTLET_MODE = "PORTLET_MODE";
    private static final String PORTLET_EXCEPTION = "PORTLET_EXCEPTION";
    private static final String INITIAL_JSP = "pageStart";
    private boolean serializeSession = false;
    private static final String SERVICE_TYPE = "serviceType";
    private static final String SERVICE_NAME = "serviceName";
    private static final String SERVICE_ACTION = "ACTION";
    private static final String SERVICE_PAGE = "PAGE";
    private static final String SERVICE_JSP = "JSP";

    public void init() throws PortletException {
        super.init();
        PortletTracer.info("Spago", "AdapterPortlet", "init", "Invocato");
        String serializeSessionStr = (String)ConfigSingleton.getInstance().getAttribute(SERIALIZE_SESSION_ATTRIBUTE);
        if (serializeSessionStr != null && serializeSessionStr.equalsIgnoreCase("TRUE")) {
            this.serializeSession = true;
        }
        PortletInitializerManager.init();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletTracer.info("Spago", "AdapterPortlet", "action", "Invocato");
        PortletAccess.setPortletConfig(this.getPortletConfig());
        PortletAccess.setPortletRequest((PortletRequest)request);
        PortletAccess.setPortletResponse((PortletResponse)response);
        PortletSession portletSession = request.getPortletSession();
        portletSession.setAttribute("BrowserLocale", (Object)request.getLocale());
        this.processService((PortletRequest)request, (PortletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processService(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        Monitor monitor = null;
        PortletTracer.info("Spago", "AdapterPortlet", "processService", "Invocato");
        try {
            Object newSessionString;
            boolean isLoop;
            SourceBean serviceRequest = null;
            EMFErrorHandler emfErrorHandler = null;
            boolean bl = isLoop = request.getAttribute("PUBLISHING_MODE_LOOPBACK") != null;
            if (isLoop) {
                request.removeAttribute("PUBLISHING_MODE_LOOPBACK");
                ResponseContainer loopbackResponseContainer = (ResponseContainer)request.getPortletSession().getAttribute("RESPONSE_CONTAINER");
                TracerSingleton.log((String)"Spago", (int)5, (String)"AdapterPortlet::service: loop-back rilevato");
                serviceRequest = loopbackResponseContainer.getLoopbackServiceRequest();
                if (serviceRequest == null) {
                    serviceRequest = new SourceBean("SERVICE_REQUEST");
                } else {
                    Object newServiceRequest = serviceRequest.getAttribute("SERVICE_REQUEST");
                    if (newServiceRequest != null && newServiceRequest instanceof SourceBean) {
                        serviceRequest = (SourceBean)newServiceRequest;
                    }
                }
                emfErrorHandler = loopbackResponseContainer.getErrorHandler();
                if (emfErrorHandler == null) {
                    emfErrorHandler = new EMFErrorHandler();
                }
            } else {
                String page;
                monitor = MonitorFactory.start((String)"controller.adapter.portlet");
                serviceRequest = new SourceBean("SERVICE_REQUEST");
                Enumeration names = request.getParameterNames();
                while (names.hasMoreElements()) {
                    String parameterName = (String)names.nextElement();
                    String[] parameterValues = request.getParameterValues(parameterName);
                    if (parameterValues == null) continue;
                    for (int i = 0; i < parameterValues.length; ++i) {
                        serviceRequest.setAttribute(parameterName, (Object)parameterValues[i]);
                    }
                }
                String actionName = (String)request.getAttribute("ACTION_NAME");
                if (actionName != null) {
                    request.removeAttribute("ACTION_NAME");
                    serviceRequest.setAttribute("ACTION_NAME", (Object)actionName);
                    serviceRequest.setAttribute(NEW_SESSION, (Object)"TRUE");
                }
                if ((page = (String)request.getAttribute(SERVICE_PAGE)) != null) {
                    request.removeAttribute(SERVICE_PAGE);
                    serviceRequest.setAttribute(SERVICE_PAGE, (Object)page);
                    serviceRequest.setAttribute(NEW_SESSION, (Object)"TRUE");
                }
                emfErrorHandler = new EMFErrorHandler();
            }
            String navigation = this.getInitParameter("light_navigation");
            if ("enabled".equalsIgnoreCase(navigation)) {
                serviceRequest = LightNavigationManager.controlLightNavigation(request, serviceRequest);
            }
            RequestContainer requestContainer = new RequestContainer();
            RequestContainer.setRequestContainer((RequestContainer)requestContainer);
            requestContainer.setServiceRequest(serviceRequest);
            boolean isRequestedSessionIdValid = true;
            PortletSession session = request.getPortletSession(true);
            if (session.isNew()) {
                newSessionString = (String)serviceRequest.getAttribute(NEW_SESSION);
                isRequestedSessionIdValid = newSessionString != null && ((String)newSessionString).equalsIgnoreCase("TRUE");
            }
            newSessionString = session;
            synchronized (newSessionString) {
                RequestContainer parentRequestContainer = null;
                parentRequestContainer = (RequestContainer)session.getAttribute("REQUEST_CONTAINER");
                if (!Navigator.isNavigatorEnabled()) {
                    if (parentRequestContainer == null) {
                        requestContainer.setSessionContainer((SessionContainer)new PortletSessionContainer(true));
                    } else {
                        requestContainer.setSessionContainer(parentRequestContainer.getSessionContainer());
                    }
                } else if (parentRequestContainer == null) {
                    requestContainer.setSessionContainer((SessionContainer)new PortletSessionContainer(true));
                } else {
                    requestContainer.setSessionContainer((SessionContainer)new PortletSessionContainer(false));
                    requestContainer.setParent(parentRequestContainer);
                }
            }
            if (!isRequestedSessionIdValid) {
                TracerSingleton.log((String)"Spago", (int)1, (String)"AdapterPortlet::processAction: sessione scaduta !");
                SessionExpiredUtility.setSessionExpiredAction((SourceBean)serviceRequest);
            }
            requestContainer.setAttribute(HTTP_SESSION_ID, (Object)request.getPortletSession().getId());
            String channelType = "PORTLET";
            String channelTypeParameter = (String)serviceRequest.getAttribute("CHANNEL_TYPE");
            String channelTypeHeader = (String)requestContainer.getAttribute(HTTP_ACCEPT_HEADER);
            if (channelTypeParameter != null && channelTypeParameter.equalsIgnoreCase("WAP") || channelTypeHeader != null && channelTypeHeader.indexOf(WAP_MIME_TYPE) != -1) {
                channelType = "WAP";
            }
            requestContainer.setChannelType(channelType);
            TracerSingleton.log((String)"Spago", (int)5, (String)"AdapterPortlet::processAction: requestContainer", (XMLObject)requestContainer);
            TracerSingleton.log((String)"Spago", (int)5, (String)"AdapterPortlet::processAction: sessionContainer", (XMLObject)requestContainer.getSessionContainer());
            ResponseContainer responseContainer = new ResponseContainer();
            ResponseContainer.setResponseContainer((ResponseContainer)responseContainer);
            responseContainer.setErrorHandler(emfErrorHandler);
            SourceBean serviceResponse = new SourceBean("SERVICE_RESPONSE");
            responseContainer.setServiceResponse(serviceResponse);
            try {
                Navigator.checkNavigation((RequestContainer)requestContainer);
            }
            catch (NavigationException ne) {
                TracerSingleton.log((String)"Spago", (int)4, (String)"AdapterPortlet::processAction: ", (Exception)((Object)ne));
                requestContainer.setServiceRequest(NavigationErrorUtility.getNavigationErrorServiceRequest());
            }
            serviceRequest = requestContainer.getServiceRequest();
            DefaultRequestContext requestContext = new DefaultRequestContext(requestContainer, responseContainer);
            CoordinatorIFace coordinator = DispatcherManager.getCoordinator((RequestContextIFace)requestContext);
            Exception serviceException = null;
            if (coordinator == null) {
                TracerSingleton.log((String)"Spago", (int)1, (String)"AdapterPortlet::processAction: coordinator nullo !");
                serviceException = new Exception("Coordinatore non trovato");
                emfErrorHandler.addError((EMFAbstractError)new EMFInternalError("ERROR", "Coordinatore non trovato !"));
            } else {
                ((RequestContextIFace)coordinator).setRequestContext((RequestContextIFace)requestContext);
                responseContainer.setBusinessType(coordinator.getBusinessType());
                responseContainer.setBusinessName(coordinator.getBusinessName());
                try {
                    coordinator.service(serviceRequest, serviceResponse);
                }
                catch (Exception ex) {
                    TracerSingleton.log((String)"Spago", (int)4, (String)"AdapterPortlet::processAction:", (Exception)ex);
                    serviceException = ex;
                    emfErrorHandler.addError((EMFAbstractError)new EMFInternalError("ERROR", ex));
                    responseContainer.setAttribute(PORTLET_EXCEPTION, (Object)serviceException);
                }
                ((RequestContextIFace)coordinator).setRequestContext(null);
            }
            TracerSingleton.log((String)"Spago", (int)5, (String)"AdapterPortlet::processAction: responseContainer", (XMLObject)responseContainer);
            TracerSingleton.log((String)"Spago", (int)5, (String)"AdapterPortlet::processAction: sessionContainer", (XMLObject)requestContainer.getSessionContainer());
            if (this.serializeSession) {
                TracerSingleton.log((String)"Spago", (int)5, (String)("AdapterPortlet::processAction: sessionContainer size [" + Serializer.serialize((Object)requestContainer.getSessionContainer()).length + "]"));
            }
            session.setAttribute("REQUEST_CONTAINER", (Object)requestContainer);
            session.setAttribute("RESPONSE_CONTAINER", (Object)responseContainer);
        }
        catch (Exception ex) {
            TracerSingleton.log((String)"Spago", (int)4, (String)"AdapterPortlet::processAction: ", (Exception)ex);
        }
        finally {
            RequestContainer.delRequestContainer();
            ResponseContainer.delResponseContainer();
            if (monitor != null) {
                monitor.stop();
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) {
        PortletTracer.info("Spago", "AdapterPortler", "doView", "Invocato");
        this.doRenderService(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) {
        PortletTracer.info("Spago", "AdapterPortler", "doView", "Invocato");
        this.doRenderService(request, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) {
        PortletTracer.info("Spago", "AdapterPortler", "doView", " AdapterPortlet::doHelp Invocato");
        this.doRenderService(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRenderService(RenderRequest request, RenderResponse response) {
        PortletTracer.info("Spago", "AdapterPortler", "doRenderService", " AdapterPortlet::doRenderService Invocato");
        PortletSession portletSession = request.getPortletSession();
        portletSession.setAttribute("PortalLocale", (Object)response.getLocale());
        PortletAccess.setPortletConfig(this.getPortletConfig());
        PortletAccess.setPortletRequest((PortletRequest)request);
        PortletAccess.setPortletResponse((PortletResponse)response);
        String portletMode = request.getPortletMode().toString();
        TracerSingleton.log((String)"Spago", (int)5, (String)("AdapterPortlet::doView: invocato per la portlet " + this.getPortletName() + " in modalita: " + portletMode));
        PortletSession session = request.getPortletSession();
        RequestContainer requestContainer = (RequestContainer)session.getAttribute("REQUEST_CONTAINER");
        ResponseContainer responseContainer = (ResponseContainer)session.getAttribute("RESPONSE_CONTAINER");
        TracerSingleton.log((String)"Spago", (int)5, (String)("AdapterPortlet::doView: request container retrieved from session: " + requestContainer));
        TracerSingleton.log((String)"Spago", (int)5, (String)("AdapterPortlet::doView: response container retrieved from session: " + responseContainer));
        if (requestContainer != null) {
            RequestContainer.setRequestContainer((RequestContainer)requestContainer);
        }
        Boolean isHttpResponseFreezed = null;
        if (responseContainer != null) {
            isHttpResponseFreezed = (Boolean)responseContainer.getAttribute("HTTP_RESPONSE_FREEZED");
        }
        if (isHttpResponseFreezed == null || !isHttpResponseFreezed.booleanValue()) {
            String resource = null;
            if (requestContainer == null && responseContainer == null) {
                String serviceType = this.getPortletConfig().getInitParameter(SERVICE_TYPE);
                String serviceName = this.getPortletConfig().getInitParameter(SERVICE_NAME);
                if (serviceType == null) {
                    TracerSingleton.log((String)"Spago", (int)4, (String)"AdapterPortlet::doView: type of start service not find (ACTION/PAGE/JSP)");
                }
                if (!(serviceType.equalsIgnoreCase("JSP") || serviceType.equalsIgnoreCase(SERVICE_ACTION) || serviceType.equalsIgnoreCase(SERVICE_PAGE))) {
                    TracerSingleton.log((String)"Spago", (int)4, (String)"AdapterPortlet::doView: type of start service unknow (ACTION/PAGE/JSP)");
                    return;
                }
                if (serviceName == null) {
                    TracerSingleton.log((String)"Spago", (int)4, (String)"AdapterPortlet::doView: name of start service not find");
                    System.out.println("AdapterPortlet::doView: name of start service not find");
                    return;
                }
                if (serviceType.equalsIgnoreCase("JSP")) {
                    RouterPortlet router = new RouterPortlet(serviceName);
                    try {
                        router.route(this.getPortletContext(), request, response);
                    }
                    catch (Exception ex) {
                        TracerSingleton.log((String)"Spago", (int)4, (String)("AdapterPortlet::doView: Error during the route to " + serviceName), (Exception)ex);
                        System.out.println("AdapterPortlet::doView: Error during the route to " + serviceName + " (see log file)");
                    }
                } else {
                    if (serviceType.equalsIgnoreCase(SERVICE_ACTION)) {
                        request.setAttribute("ACTION_NAME", (Object)serviceName);
                    } else {
                        request.setAttribute(SERVICE_PAGE, (Object)serviceName);
                    }
                    try {
                        this.processService((PortletRequest)request, (PortletResponse)response);
                        this.doRenderService(request, response);
                        return;
                    }
                    catch (Exception e) {
                        TracerSingleton.log((String)"Spago", (int)4, (String)("AdapterPortlet::doView: Error during the process of the " + serviceType + " service " + serviceName), (Exception)e);
                        System.out.println("AdapterPortlet::doView: Error during the process of the " + serviceType + " service " + serviceName + " (see log file)");
                    }
                }
            } else {
                Exception serviceException = (Exception)responseContainer.getAttribute(PORTLET_EXCEPTION);
                DefaultRequestContext requestContext = new DefaultRequestContext(requestContainer, responseContainer);
                PublisherConfiguration publisher = Publisher.getPublisherConfiguration((RequestContextIFace)requestContext, (Exception)serviceException);
                String publisherType = publisher.getType();
                ArrayList resources = publisher.getResources();
                if (publisherType.equalsIgnoreCase("LOOP")) {
                    resources = new ArrayList();
                    try {
                        request.setAttribute("PUBLISHING_MODE_LOOPBACK", (Object)"TRUE");
                        this.processService((PortletRequest)request, (PortletResponse)response);
                        this.doRenderService(request, response);
                        return;
                    }
                    catch (Exception e) {
                        TracerSingleton.log((String)"Spago", (int)3, (String)"AdapterPortlet::doRenderService: error during the execution of the loopback request", (Exception)e);
                    }
                }
                if (publisherType.equalsIgnoreCase("LOOP") || publisherType.equalsIgnoreCase(SERVLET_PUBLISHER_TYPE) || publisherType.equalsIgnoreCase("JSP")) {
                    Iterator iterator = resources.iterator();
                    SourceBean resourceSourceBean = null;
                    while (iterator.hasNext() && !((String)(resourceSourceBean = (SourceBean)iterator.next()).getAttribute("mode")).equalsIgnoreCase(portletMode)) {
                    }
                    if (resourceSourceBean == null) {
                        TracerSingleton.log((String)"Spago", (int)3, (String)("AdapterPortlet::doView: no resources defined for mode " + portletMode));
                    } else {
                        resource = (String)resourceSourceBean.getAttribute("resource");
                    }
                    RouterPortlet router = new RouterPortlet(resource);
                    try {
                        router.route(this.getPortletContext(), request, response);
                    }
                    catch (Exception ex) {
                        TracerSingleton.log((String)"Spago", (int)4, (String)"AdapterPortlet::doView: ", (Exception)ex);
                    }
                    finally {
                        publisher.release();
                    }
                } else {
                    response.setContentType(HTTP_CONTENT_TYPE);
                    Monitor renderingMonitor = MonitorFactory.start((String)("view.portlet." + publisherType.toLowerCase() + "." + publisher.getName().toLowerCase()));
                    try {
                        response.getWriter().print(PresentationRendering.render((ResponseContainer)responseContainer, resources));
                        response.getWriter().flush();
                    }
                    catch (Exception ex) {
                        TracerSingleton.log((String)"Spago", (int)5, (String)"AdapterPortlet::doView:eccezzione", (Exception)ex);
                    }
                    finally {
                        publisher.release();
                        renderingMonitor.stop();
                    }
                }
            }
        } else {
            TracerSingleton.log((String)"Spago", (int)5, (String)"AdapterPortlet::service: http response congelata");
        }
    }
}

