/*
 * Decompiled with CFR 0.152.
 */
package it.eng.spago.dispatching.httpchannel;

import it.eng.spago.tracing.TracerSingleton;
import it.eng.spago.util.JavaScript;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class RouterPortlet {
    private String _publisher = null;
    private Hashtable _parameters = null;

    public RouterPortlet(String publisher) {
        this._publisher = publisher;
        this._parameters = new Hashtable();
    }

    public static RouterPortlet getDefaultRouter() {
        return new RouterPortlet("DEFAULT");
    }

    public Object getParameter(String key) {
        if (key == null) {
            return null;
        }
        return this._parameters.get(key);
    }

    public void setParameter(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.delParameter(key);
        } else {
            this._parameters.put(key, value);
        }
    }

    public void delParameter(String key) {
        if (key == null) {
            return;
        }
        this._parameters.remove(key);
    }

    public void route(PortletContext portletContext, RenderRequest request, RenderResponse response) throws PortletException, IOException {
        TracerSingleton.log((String)"Spago", (int)5, (String)("PortletRouter::route: _publisher [" + this._publisher + "]"));
        String publishingParameters = "";
        Enumeration parameterNames = this._parameters.keys();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = String.valueOf(this._parameters.get(parameterName));
            if (this._publisher.indexOf(parameterName) != -1) continue;
            publishingParameters = publishingParameters + JavaScript.escape((String)parameterName) + "=" + JavaScript.escape((String)parameterValue) + "&";
        }
        TracerSingleton.log((String)"Spago", (int)5, (String)("PortletRouter::route: publishingParameters [" + publishingParameters + "]"));
        String publishingURL = this._publisher;
        publishingURL = this._publisher.indexOf(63) == -1 ? publishingURL + "?" + publishingParameters : publishingURL + "&" + publishingParameters;
        TracerSingleton.log((String)"Spago", (int)5, (String)("PortletRouter::route: publishingURL [" + publishingURL + "]"));
        PortletRequestDispatcher requestDispatcher = portletContext.getRequestDispatcher(publishingURL);
        requestDispatcher.include(request, response);
    }
}

