/*
 * Decompiled with CFR 0.152.
 */
package it.eng.spago.init;

import it.eng.spago.base.SourceBean;
import it.eng.spago.configuration.ConfigSingleton;
import it.eng.spago.init.InitializerIFace;
import it.eng.spago.tracing.TracerSingleton;
import java.util.List;

public class PortletInitializerManager {
    private PortletInitializerManager() {
    }

    public static void init() {
        PortletInitializerManager.init("PORTLETINITIALIZERS.INITIALIZER");
    }

    public static void init(String cgfInitializerPath) {
        ConfigSingleton configure = ConfigSingleton.getInstance();
        String startupConsoleStr = (String)configure.getAttribute("COMMON.startup_console");
        if (startupConsoleStr == null || !startupConsoleStr.equalsIgnoreCase("FALSE")) {
            System.out.println("PortletInitializerManager::init: configuration\n" + configure.toXML(false));
        }
        List initializers = configure.getAttributeAsList("PORTLETINITIALIZERS.INITIALIZER");
        for (int i = 0; i < initializers.size(); ++i) {
            try {
                SourceBean initializerDefinition = (SourceBean)initializers.get(i);
                String initializerClassName = (String)initializerDefinition.getAttribute("CLASS");
                String initializerConfigName = (String)initializerDefinition.getAttribute("CONFIG");
                TracerSingleton.log((String)"Spago", (int)5, (String)("PortletInitializerManager::init: " + initializerClassName + " [" + initializerConfigName + "]"));
                SourceBean initializerConfig = (SourceBean)configure.getAttribute(initializerConfigName);
                InitializerIFace initializer = (InitializerIFace)Class.forName(initializerClassName).newInstance();
                initializer.init(initializerConfig);
                continue;
            }
            catch (Exception ex) {
                TracerSingleton.log((String)"Spago", (int)4, (String)"PortletInitializerManager::init:", (Exception)ex);
            }
        }
    }
}

