/*
 * Decompiled with CFR 0.152.
 */
package it.eng.spago.navigation;

import it.eng.spago.base.SourceBean;
import it.eng.spago.navigation.LightNavigator;
import it.eng.spago.navigation.MarkedRequest;
import it.eng.spago.tracing.TracerSingleton;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

public class LightNavigationManager {
    public static final String LIGHT_NAVIGATOR_RESET = "LIGHT_NAVIGATOR_RESET";
    public static final String LIGHT_NAVIGATOR_DISABLED = "LIGHT_NAVIGATOR_DISABLED";
    public static final String LIGHT_NAVIGATOR_BACK_TO = "LIGHT_NAVIGATOR_BACK_TO";
    public static final String LIGHT_NAVIGATOR_REPLACE_LAST = "LIGHT_NAVIGATOR_REPLACE_LAST";
    public static final String LIGHT_NAVIGATOR_BACK_TO_MARK = "LIGHT_NAVIGATOR_BACK_TO_MARK";
    public static final String LIGHT_NAVIGATOR_MARK = "LIGHT_NAVIGATOR_MARK";

    public static SourceBean controlLightNavigation(PortletRequest portletRequest, SourceBean serviceRequest) throws Exception {
        TracerSingleton.log((String)"Spago", (int)5, (String)("Method controlNavigation in LightNavigationManager class invoked with service request:\n" + serviceRequest));
        if (portletRequest == null) {
            TracerSingleton.log((String)"Spago", (int)4, (String)"LightNavigationManager: controlLightNavigation: PortletRequest object at input is null.");
            throw new Exception("PortletRequest object is null.");
        }
        if (serviceRequest == null) {
            TracerSingleton.log((String)"Spago", (int)4, (String)"LightNavigationManager: controlLightNavigation: the service request SourceBean at input is null.");
            throw new Exception("Service request SourceBean is null.");
        }
        SourceBean savedServiceRequest = (SourceBean)serviceRequest.cloneObject();
        LightNavigator lightNavigator = LightNavigationManager.retrieveLightNavigatorFromSession(portletRequest);
        try {
            String lightNavigatorDisabled = (String)serviceRequest.getAttribute(LIGHT_NAVIGATOR_DISABLED);
            if ("true".equalsIgnoreCase(lightNavigatorDisabled)) {
                TracerSingleton.log((String)"Spago", (int)5, (String)"LightNavigator disabled; return from the method controlNavigation without any modifications to the original request.");
                TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack is not modified:\n" + lightNavigator.toString()));
                return serviceRequest;
            }
            String lightNavigatorBackTo = (String)serviceRequest.getAttribute(LIGHT_NAVIGATOR_BACK_TO);
            if (lightNavigatorBackTo != null) {
                int position = Integer.parseInt(lightNavigatorBackTo);
                MarkedRequest markedRequest = lightNavigator.goBackToPosition(position);
                TracerSingleton.log((String)"Spago", (int)5, (String)("LightNavigationManager: controlLightNavigation: returning request at position " + position + " of the stack."));
                TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack now is:\n" + lightNavigator.toString()));
                return markedRequest.getRequest();
            }
            String lightNavigatorReplaceLast = (String)serviceRequest.getAttribute(LIGHT_NAVIGATOR_REPLACE_LAST);
            if (lightNavigatorReplaceLast != null) {
                String mark = (String)serviceRequest.getAttribute(LIGHT_NAVIGATOR_MARK);
                MarkedRequest markedRequest = new MarkedRequest(serviceRequest, mark);
                lightNavigator.replaceLast(markedRequest);
                TracerSingleton.log((String)"Spago", (int)5, (String)"LightNavigationManager: controlLightNavigation: substituted the more recent request (at position 0) of the stack with the input one.");
                TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack now is:\n" + lightNavigator.toString()));
                return markedRequest.getRequest();
            }
            String lightNavigatorBackToMark = (String)serviceRequest.getAttribute(LIGHT_NAVIGATOR_BACK_TO_MARK);
            if (lightNavigatorBackToMark != null) {
                MarkedRequest markedRequest = lightNavigator.goBackToMark(lightNavigatorBackToMark);
                TracerSingleton.log((String)"Spago", (int)5, (String)("LightNavigationManager: controlLightNavigation: returning request with mark " + lightNavigatorBackToMark + " of the stack."));
                TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack now is:\n" + lightNavigator.toString()));
                return markedRequest.getRequest();
            }
            String lightNavigatorReset = (String)serviceRequest.getAttribute(LIGHT_NAVIGATOR_RESET);
            if (lightNavigatorReset != null) {
                lightNavigator.reset();
                TracerSingleton.log((String)"Spago", (int)5, (String)"LightNavigationManager: controlLightNavigation: stack reset executed.");
                TracerSingleton.log((String)"Spago", (int)5, (String)"The requests stack now is empty.");
                return serviceRequest;
            }
            String mark = (String)serviceRequest.getAttribute(LIGHT_NAVIGATOR_MARK);
            MarkedRequest markedRequest = new MarkedRequest(serviceRequest, mark);
            lightNavigator.add(markedRequest);
            TracerSingleton.log((String)"Spago", (int)5, (String)("LightNavigationManager: controlLightNavigation: putting the request in the stack " + (mark == null ? "without mark" : "with mark '" + mark + "'") + ". Returning unmodified request."));
            TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack now is:\n" + lightNavigator.toString()));
            return serviceRequest;
        }
        catch (Exception e) {
            TracerSingleton.log((String)"Spago", (int)3, (String)"LightNavigationManager: controlLightNavigation: an exception occurred. Returning the original request.", (Exception)e);
            TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack now is:\n" + lightNavigator.toString()));
            return savedServiceRequest;
        }
    }

    private static LightNavigator retrieveLightNavigatorFromSession(PortletRequest portletRequest) throws Exception {
        PortletSession session = portletRequest.getPortletSession();
        if (session == null) {
            TracerSingleton.log((String)"Spago", (int)4, (String)"LightNavigationManager: controlLightNavigation: PortletSession object is null.");
            throw new Exception("PortletSession object is null.");
        }
        Object lightNavigatorObj = session.getAttribute("LIGHT_NAVIGATOR");
        LightNavigator lightNavigator = null;
        if (lightNavigatorObj != null) {
            lightNavigator = (LightNavigator)lightNavigatorObj;
        } else {
            lightNavigator = new LightNavigator();
            session.setAttribute("LIGHT_NAVIGATOR", (Object)lightNavigator);
        }
        return lightNavigator;
    }
}

