/*
 * Decompiled with CFR 0.152.
 */
package it.eng.spago.navigation;

import it.eng.spago.navigation.MarkedRequest;
import it.eng.spago.navigation.NavigationException;
import it.eng.spago.tracing.TracerSingleton;
import java.util.ArrayList;

public class LightNavigator {
    private ArrayList list = new ArrayList();

    public void add(MarkedRequest markedRequest) throws NavigationException {
        if (markedRequest == null) {
            TracerSingleton.log((String)"Spago", (int)4, (String)"LightNavigator: add: the MarkedRequest object at input is null.");
            throw new NavigationException("The MarkedRequest object at input is null.");
        }
        this.list.add(0, markedRequest);
    }

    public MarkedRequest goBackToPosition(int i) throws NavigationException {
        if (i < 0 || i > this.list.size() - 1) {
            TracerSingleton.log((String)"Spago", (int)4, (String)("LightNavigator: goBackToPosition: the position " + i + " is not present in the stack."));
            TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack is:\n" + this.toString()));
            throw new NavigationException("Index of the required request is not correct.");
        }
        MarkedRequest markedRequest = (MarkedRequest)this.list.get(i);
        for (int j = 0; j < i; ++j) {
            this.list.remove(0);
        }
        return markedRequest;
    }

    public void replaceLast(MarkedRequest markedRequest) throws NavigationException {
        if (markedRequest == null) {
            TracerSingleton.log((String)"Spago", (int)4, (String)"LightNavigator: replaceLast: the MarkedRequest object at input is null.");
            throw new NavigationException("The MarkedRequest object at input is null.");
        }
        if (this.list.size() == 0) {
            TracerSingleton.log((String)"Spago", (int)4, (String)"LightNavigator: replaceLast: the stack is empty: it is not possible to substitute the request.");
            throw new NavigationException("The stack is empty: it is not possible to substitute the request.");
        }
        this.list.remove(0);
        this.list.add(0, markedRequest);
    }

    public void reset() {
        this.list = new ArrayList();
    }

    public MarkedRequest goBackToMark(String mark) throws NavigationException {
        int i;
        if (mark == null) {
            TracerSingleton.log((String)"Spago", (int)3, (String)"LightNavigator: goBackToMark: the input mark is null.");
            throw new NavigationException("The input mark for navigation research cannot be null.");
        }
        MarkedRequest toReturn = null;
        for (i = 1; i <= this.list.size(); ++i) {
            MarkedRequest markedRequest = (MarkedRequest)this.list.get(i - 1);
            if (!mark.equalsIgnoreCase(markedRequest.getMark())) continue;
            toReturn = markedRequest;
            break;
        }
        if (toReturn == null) {
            TracerSingleton.log((String)"Spago", (int)3, (String)("LightNavigator: goBackToMark: Request with mark '" + mark + "' not found."));
            TracerSingleton.log((String)"Spago", (int)5, (String)("The requests stack is:\n" + this.toString()));
            throw new NavigationException("Request with mark '" + mark + "' not found.");
        }
        for (int j = 0; j < i - 1; ++j) {
            this.list.remove(0);
        }
        return toReturn;
    }

    public String toString() {
        String toReturn = "";
        for (int i = 0; i < this.list.size(); ++i) {
            toReturn = toReturn + "Position " + i + ":\n";
            toReturn = toReturn + this.list.get(i).toString();
            toReturn = toReturn + "\n-------------------------------------------\n";
        }
        return toReturn;
    }
}

