/*
 * Decompiled with CFR 0.152.
 */
package it.eng.spago.util;

import it.eng.spago.base.PortletAccess;
import it.eng.spago.base.RequestContainer;
import it.eng.spago.base.RequestContainerPortletAccess;
import it.eng.spago.base.SourceBean;
import it.eng.spago.util.GeneralUtilities;
import it.eng.spago.util.PortletTracer;
import it.eng.spago.util.UploadedFile;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;

public class PortletUtilities {
    public static String createPortletURL(HttpServletRequest aHttpServletRequest, String originalURL) {
        RenderResponse renderResponse = (RenderResponse)aHttpServletRequest.getAttribute("javax.portlet.response");
        RequestContainer requestContainer = RequestContainerPortletAccess.getRequestContainer(aHttpServletRequest);
        PortletURL aPortletURL = renderResponse.createActionURL();
        PortletTracer.debug("Spago", PortletUtilities.class.getName(), "createPortletURL()", "Original URL.... " + originalURL + "indexOf ? is " + originalURL.indexOf("?"));
        String parameters = originalURL.substring(originalURL.indexOf("?") + 1);
        StringTokenizer st = new StringTokenizer(parameters, "&", false);
        String parameterToken = null;
        String parameterName = null;
        String parameterValue = null;
        while (st.hasMoreTokens()) {
            parameterToken = st.nextToken();
            PortletTracer.debug("Spago", PortletUtilities.class.getName(), "createPortletURL()", "Parameter Token [" + parameterToken + "]");
            parameterName = parameterToken.substring(0, parameterToken.indexOf("="));
            parameterValue = parameterToken.substring(parameterToken.indexOf("=") + 1);
            PortletTracer.debug("Spago", PortletUtilities.class.getName(), "createPortletURL()", "Parameter Name [" + parameterName + "]");
            PortletTracer.debug("Spago", PortletUtilities.class.getName(), "createPortletURL()", "Parameter Value [" + parameterValue + "]");
            aPortletURL.setParameter(parameterName, parameterValue);
        }
        return aPortletURL.toString();
    }

    public static String createPortletURLForResource(HttpServletRequest aHttpServletRequest, String resourcePath) {
        RenderResponse renderResponse = (RenderResponse)aHttpServletRequest.getAttribute("javax.portlet.response");
        RenderRequest renderRequest = (RenderRequest)aHttpServletRequest.getAttribute("javax.portlet.request");
        String resourceAbsPathFromPortletContex = null;
        int idx = resourcePath.indexOf(47);
        if (idx > -1) {
            PortletTracer.debug("Spago", PortletUtilities.class.getName(), "createPortletURLForResource", "URL [" + resourcePath + "] is relative !!!!");
            resourceAbsPathFromPortletContex = resourcePath.substring(idx);
            PortletTracer.debug("Spago", PortletUtilities.class.getName(), "createPortletURLForResource", "Absolute URL From Portlet Context [" + resourceAbsPathFromPortletContex + "]");
        }
        String urlToReturn = renderResponse.encodeURL(renderRequest.getContextPath() + resourceAbsPathFromPortletContex);
        return urlToReturn;
    }

    public static PortletRequest getPortletRequest() {
        return PortletAccess.getPortletRequest();
    }

    public static PortletResponse getPortletResponse() {
        return PortletAccess.getPortletResponse();
    }

    public static SourceBean getServiceRequestFromMultipartPortletRequest(PortletRequest portletRequest) {
        SourceBean serviceRequest = null;
        try {
            serviceRequest = new SourceBean("SERVICEREQUEST");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            PortletFileUpload upload = new PortletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest((ActionRequest)portletRequest);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    serviceRequest.setAttribute(item.getFieldName(), (Object)item.getString());
                    continue;
                }
                UploadedFile uploadedFile = new UploadedFile();
                uploadedFile.setFileContent(item.get());
                uploadedFile.setFieldNameInForm(item.getFieldName());
                uploadedFile.setSizeInBytes(item.getSize());
                uploadedFile.setFileName(GeneralUtilities.getRelativeFileNames(item.getName()));
                serviceRequest.setAttribute("UPLOADED_FILE", (Object)uploadedFile);
            }
        }
        catch (Exception e) {
            PortletTracer.major("Spago", PortletUtilities.class.getName(), "getServiceRequestFromMultipartPortletRequets", "Cannot parse multipart request", e);
        }
        return serviceRequest;
    }

    public static UploadedFile getFirstUploadedFile(PortletRequest portletRequest) {
        UploadedFile uploadedFile = null;
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            PortletFileUpload upload = new PortletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest((ActionRequest)portletRequest);
            Iterator iter = items.iterator();
            boolean endLoop = false;
            while (iter.hasNext() && !endLoop) {
                FileItem item = (FileItem)iter.next();
                if (item.isFormField()) continue;
                uploadedFile = new UploadedFile();
                uploadedFile.setFileContent(item.get());
                uploadedFile.setFieldNameInForm(item.getFieldName());
                uploadedFile.setSizeInBytes(item.getSize());
                uploadedFile.setFileName(item.getName());
                endLoop = true;
            }
        }
        catch (Exception e) {
            PortletTracer.major("Spago", PortletUtilities.class.getName(), "getServiceRequestFromMultipartPortletRequets", "Cannot parse multipart request", e);
        }
        return uploadedFile;
    }

    public static String cleanString(String original) {
        StringBuffer sb = new StringBuffer();
        char[] arrayChar = original.toCharArray();
        for (int i = 0; i < arrayChar.length; ++i) {
            if (arrayChar[i] == '\n' || arrayChar[i] == '\t' || arrayChar[i] == '\r') continue;
            sb.append(arrayChar[i]);
        }
        return sb.toString().trim();
    }

    public static String getMessage(String code, String bundle) {
        Locale portalLocale = PortletAccess.getPortalLocale();
        String portalLang = portalLocale.getLanguage();
        String portalCountry = portalLocale.getCountry();
        Locale locale = new Locale(portalLang, portalCountry);
        ResourceBundle messages = null;
        try {
            messages = ResourceBundle.getBundle(bundle, locale);
        }
        catch (Exception e) {
            messages = ResourceBundle.getBundle("messages");
        }
        if (messages == null) {
            return null;
        }
        String message = code;
        try {
            message = messages.getString(code);
        }
        catch (Exception ex) {
            PortletTracer.warning("Spago", PortletUtilities.class.getName(), "getMessage", "code [" + code + "] not found ");
        }
        return message;
    }
}

