/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import it.fabioformosa.quartzmanager.api.dto.SchedulerDTO;
import it.fabioformosa.quartzmanager.api.services.SchedulerService;
import lombok.Generated;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SecurityRequirement(name="quartz-manager-auth")
@RequestMapping(value={"/quartz-manager/scheduler"})
public class SchedulerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerController.class);
    protected static final String SCHEDULER_CONTROLLER_BASE_URL = "/quartz-manager/scheduler";
    private final SchedulerService schedulerService;

    public SchedulerController(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @GetMapping
    @Operation(summary="Get the scheduler details")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the scheduler config", content={@Content(mediaType="application/json", schema=@Schema(implementation=SchedulerDTO.class))})})
    public SchedulerDTO getScheduler() {
        log.trace("SCHEDULER - GET Scheduler...");
        return this.schedulerService.getScheduler();
    }

    @GetMapping(value={"/pause"})
    @Operation(summary="Get paused the scheduler")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Got paused successfully")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void pause() throws SchedulerException {
        log.info("SCHEDULER - PAUSE COMMAND");
        this.schedulerService.standby();
    }

    @GetMapping(value={"/resume"})
    @Operation(summary="Get resumed the scheduler")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Got resumed successfully")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resume() throws SchedulerException {
        log.info("SCHEDULER - RESUME COMMAND");
        this.schedulerService.start();
    }

    @GetMapping(value={"/run"})
    @Operation(summary="Start the scheduler")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Got started successfully")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void run() throws SchedulerException {
        log.info("SCHEDULER - START COMMAND");
        this.schedulerService.start();
    }

    @GetMapping(value={"/stop"})
    @Operation(summary="Stop the scheduler")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Got stopped successfully")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void stop() throws SchedulerException {
        log.info("SCHEDULER - STOP COMMAND");
        this.schedulerService.shutdown();
    }
}

