/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import it.fabioformosa.quartzmanager.api.dto.SimpleTriggerCommandDTO;
import it.fabioformosa.quartzmanager.api.dto.SimpleTriggerDTO;
import it.fabioformosa.quartzmanager.api.dto.SimpleTriggerInputDTO;
import it.fabioformosa.quartzmanager.api.dto.TriggerDTO;
import it.fabioformosa.quartzmanager.api.exceptions.TriggerNotFoundException;
import it.fabioformosa.quartzmanager.api.services.SimpleTriggerService;
import javax.validation.Valid;
import lombok.Generated;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/quartz-manager/simple-triggers"})
@SecurityRequirement(name="quartz-manager-auth")
@RestController
public class SimpleTriggerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleTriggerController.class);
    protected static final String SIMPLE_TRIGGER_CONTROLLER_BASE_URL = "/quartz-manager/simple-triggers";
    private final SimpleTriggerService simpleSchedulerService;

    public SimpleTriggerController(SimpleTriggerService simpleSchedulerService) {
        this.simpleSchedulerService = simpleSchedulerService;
    }

    @GetMapping(value={"/{name}"})
    @Operation(summary="Get a simple trigger by name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Got the trigger by its name", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimpleTriggerDTO.class))}), @ApiResponse(responseCode="404", description="Trigger not found", content={@Content})})
    public SimpleTriggerDTO getSimpleTrigger(@PathVariable String name) throws SchedulerException, TriggerNotFoundException {
        return this.simpleSchedulerService.getSimpleTriggerByName(name);
    }

    @PostMapping(value={"/{name}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Schedule a new simple trigger")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Scheduled a new simple trigger", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimpleTriggerDTO.class))}), @ApiResponse(responseCode="400", description="Invalid trigger configuration", content={@Content})})
    public SimpleTriggerDTO postSimpleTrigger(@PathVariable String name, @Valid @RequestBody SimpleTriggerInputDTO simpleTriggerInputDTO) throws SchedulerException, ClassNotFoundException {
        log.info("SIMPLE TRIGGER - CREATING a SimpleTrigger {} {}", (Object)name, (Object)simpleTriggerInputDTO);
        SimpleTriggerCommandDTO simpleTriggerCommandDTO = SimpleTriggerCommandDTO.builder().triggerName(name).simpleTriggerInputDTO(simpleTriggerInputDTO).build();
        SimpleTriggerDTO newTriggerDTO = this.simpleSchedulerService.scheduleSimpleTrigger(simpleTriggerCommandDTO);
        log.info("SIMPLE TRIGGER - CREATED a SimpleTrigger {}", (Object)newTriggerDTO);
        return newTriggerDTO;
    }

    @PutMapping(value={"/{name}"})
    @Operation(summary="Reschedule a simple trigger")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Rescheduled a simple trigger", content={@Content(mediaType="application/json", schema=@Schema(implementation=TriggerDTO.class))}), @ApiResponse(responseCode="400", description="Invalid trigger configuration", content={@Content})})
    public TriggerDTO rescheduleSimpleTrigger(@PathVariable String name, @Valid @RequestBody SimpleTriggerInputDTO simpleTriggerInputDTO) throws SchedulerException {
        log.info("SIMPLE TRIGGER - RESCHEDULING the trigger {} {}", (Object)name, (Object)simpleTriggerInputDTO);
        SimpleTriggerCommandDTO simpleTriggerCommandDTO = SimpleTriggerCommandDTO.builder().triggerName(name).simpleTriggerInputDTO(simpleTriggerInputDTO).build();
        SimpleTriggerDTO triggerDTO = this.simpleSchedulerService.rescheduleSimpleTrigger(simpleTriggerCommandDTO);
        log.info("SIMPLE TRIGGER - RESCHEDULED the trigger {}", (Object)triggerDTO);
        return triggerDTO;
    }
}

