/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import it.fabioformosa.quartzmanager.api.dto.TriggerKeyDTO;
import it.fabioformosa.quartzmanager.api.services.TriggerService;
import java.util.List;
import lombok.Generated;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/quartz-manager/triggers"})
@SecurityRequirement(name="quartz-manager-auth")
@RestController
public class TriggerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TriggerController.class);
    protected static final String TRIGGER_CONTROLLER_BASE_URL = "/quartz-manager/triggers";
    private final TriggerService triggerService;

    public TriggerController(TriggerService triggerService) {
        this.triggerService = triggerService;
    }

    @GetMapping
    @Operation(summary="Get a list of triggers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Got the trigger list", content={@Content(mediaType="application/json", schema=@Schema(implementation=TriggerKeyDTO.class))})})
    public List<TriggerKeyDTO> listTriggers() throws SchedulerException {
        return this.triggerService.fetchTriggers();
    }
}

