/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.controllers.advices;

import it.fabioformosa.quartzmanager.api.exceptions.ExceptionResponse;
import it.fabioformosa.quartzmanager.api.exceptions.ResourceConflictException;
import it.fabioformosa.quartzmanager.api.exceptions.TriggerNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ExceptionHandlingController {
    @ExceptionHandler(value={ResourceConflictException.class})
    public ResponseEntity<ExceptionResponse> resourceConflict(ResourceConflictException ex) {
        ExceptionResponse response = new ExceptionResponse();
        response.setErrorCode("Conflict");
        response.setErrorMessage(ex.getMessage());
        return new ResponseEntity((Object)response, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={TriggerNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public ExceptionResponse triggerNotFound(TriggerNotFoundException ex) {
        return ExceptionResponse.builder().errorCode(HttpStatus.NOT_FOUND.toString()).errorMessage(ex.getMessage()).build();
    }
}

