/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.jobs;

import it.fabioformosa.quartzmanager.api.dto.TriggerFiredBundleDTO;
import it.fabioformosa.quartzmanager.api.jobs.entities.LogRecord;
import it.fabioformosa.quartzmanager.api.websockets.WebSocketProgressNotifier;
import it.fabioformosa.quartzmanager.api.websockets.WebhookSender;
import javax.annotation.Resource;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzManagerJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractQuartzManagerJob.class);
    @Resource
    private WebhookSender<TriggerFiredBundleDTO> webSocketProgressNotifier;
    @Resource
    private WebhookSender<LogRecord> webSocketLogsNotifier;

    public abstract LogRecord doIt(JobExecutionContext var1);

    public final void execute(JobExecutionContext jobExecutionContext) {
        LogRecord logMsg = this.doIt(jobExecutionContext);
        log.info(logMsg.getMessage());
        logMsg.setThreadName(Thread.currentThread().getName());
        this.webSocketLogsNotifier.send(logMsg);
        TriggerFiredBundleDTO triggerFiredBundleDTO = WebSocketProgressNotifier.buildTriggerFiredBundle(jobExecutionContext);
        this.webSocketProgressNotifier.send(triggerFiredBundleDTO);
    }
}

