/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.services;

import it.fabioformosa.quartzmanager.api.jobs.AbstractQuartzManagerJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JobService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobService.class);
    private List<Class<? extends AbstractQuartzManagerJob>> jobClasses = new ArrayList<Class<? extends AbstractQuartzManagerJob>>();
    private List<String> jobClassPackages = new ArrayList<String>();

    public JobService(@Value(value="${quartz-manager.jobClassPackages}") String jobClassPackages) {
        List splitPackages = Arrays.stream(Optional.of(jobClassPackages).map(str -> str.split(",")).orElseThrow(() -> new RuntimeException("The prop quartz-manager.jobClassPackages  cannot be blank!"))).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (!splitPackages.isEmpty()) {
            this.jobClassPackages.addAll(splitPackages);
        }
    }

    @PostConstruct
    public void initJobClassList() {
        List foundJobClasses = this.jobClassPackages.stream().flatMap(jobClassPackage -> JobService.findJobClassesInPackage(jobClassPackage).stream()).collect(Collectors.toList());
        if (!foundJobClasses.isEmpty()) {
            log.info("Found the following eligible job classes: {}", foundJobClasses);
            this.jobClasses.addAll(foundJobClasses);
        } else {
            log.warn("Not found any eligible job classes!");
        }
    }

    private static Set<Class<? extends AbstractQuartzManagerJob>> findJobClassesInPackage(String packageStr) {
        Reflections reflections = new Reflections(packageStr, new Scanner[0]);
        return reflections.getSubTypesOf(AbstractQuartzManagerJob.class);
    }

    @Generated
    public List<Class<? extends AbstractQuartzManagerJob>> getJobClasses() {
        return this.jobClasses;
    }
}

