/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.services;

import it.fabioformosa.quartzmanager.api.dto.SimpleTriggerCommandDTO;
import it.fabioformosa.quartzmanager.api.dto.SimpleTriggerDTO;
import it.fabioformosa.quartzmanager.api.exceptions.TriggerNotFoundException;
import it.fabioformosa.quartzmanager.api.services.AbstractSchedulerService;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class SimpleTriggerService
extends AbstractSchedulerService {
    public SimpleTriggerService(@Qualifier(value="quartzManagerScheduler") Scheduler scheduler, ConversionService conversionService) {
        super(scheduler, conversionService);
    }

    public SimpleTriggerDTO getSimpleTriggerByName(String name) throws SchedulerException, TriggerNotFoundException {
        Trigger trigger = this.getTriggerByName(name);
        return (SimpleTriggerDTO)this.conversionService.convert((Object)trigger, SimpleTriggerDTO.class);
    }

    public SimpleTriggerDTO scheduleSimpleTrigger(SimpleTriggerCommandDTO simpleTriggerCommandDTO) throws SchedulerException, ClassNotFoundException {
        Class<?> jobClass = Class.forName(simpleTriggerCommandDTO.getSimpleTriggerInputDTO().getJobClass());
        JobDetail jobDetail = JobBuilder.newJob().ofType(jobClass).storeDurably(false).build();
        SimpleTrigger newSimpleTrigger = (SimpleTrigger)this.conversionService.convert((Object)simpleTriggerCommandDTO, SimpleTrigger.class);
        this.scheduler.scheduleJob(jobDetail, (Trigger)newSimpleTrigger);
        return (SimpleTriggerDTO)this.conversionService.convert((Object)newSimpleTrigger, SimpleTriggerDTO.class);
    }

    public SimpleTriggerDTO rescheduleSimpleTrigger(SimpleTriggerCommandDTO triggerCommandDTO) throws SchedulerException {
        SimpleTrigger newSimpleTrigger = (SimpleTrigger)this.conversionService.convert((Object)triggerCommandDTO, SimpleTrigger.class);
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerCommandDTO.getTriggerName());
        this.scheduler.rescheduleJob(triggerKey, (Trigger)newSimpleTrigger);
        return (SimpleTriggerDTO)this.conversionService.convert((Object)newSimpleTrigger, SimpleTriggerDTO.class);
    }
}

