/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.websockets;

import it.fabioformosa.quartzmanager.api.dto.TriggerFiredBundleDTO;
import it.fabioformosa.quartzmanager.api.websockets.WebhookSender;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.stereotype.Component;

@Component
public class WebSocketProgressNotifier
implements WebhookSender<TriggerFiredBundleDTO> {
    public static final String TOPIC_PROGRESS = "/topic/progress";
    @Autowired
    private SimpMessageSendingOperations messagingTemplate;

    @Override
    public void send(TriggerFiredBundleDTO triggerFiredBundleDTO) {
        this.messagingTemplate.convertAndSend((Object)TOPIC_PROGRESS, (Object)triggerFiredBundleDTO);
    }

    public static TriggerFiredBundleDTO buildTriggerFiredBundle(JobExecutionContext jobExecutionContext) {
        TriggerFiredBundleDTO triggerFiredBundleDTO = new TriggerFiredBundleDTO();
        Trigger trigger = jobExecutionContext.getTrigger();
        triggerFiredBundleDTO.setFinalFireTime(trigger.getFinalFireTime());
        triggerFiredBundleDTO.setNextFireTime(trigger.getNextFireTime());
        triggerFiredBundleDTO.setPreviousFireTime(trigger.getPreviousFireTime());
        if (trigger instanceof SimpleTrigger) {
            SimpleTrigger simpleTrigger = (SimpleTrigger)trigger;
            triggerFiredBundleDTO.setRepeatCount(simpleTrigger.getRepeatCount() + 1);
            triggerFiredBundleDTO.setTimesTriggered(simpleTrigger.getTimesTriggered());
        } else if (trigger instanceof DailyTimeIntervalTrigger) {
            DailyTimeIntervalTrigger dailyTrigger = (DailyTimeIntervalTrigger)trigger;
            triggerFiredBundleDTO.setRepeatCount(dailyTrigger.getRepeatCount() + 1);
        }
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        triggerFiredBundleDTO.setJobKey(jobDetail.getKey().getName());
        triggerFiredBundleDTO.setJobClass(jobDetail.getJobClass().getName());
        return triggerFiredBundleDTO;
    }
}

