/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.fabioformosa.quartzmanager.api.security.helpers.LoginConfigurer;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.AuthenticationFailureHandler;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.AuthenticationSuccessHandler;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.FormLoginConfig;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtAuthenticationSuccessHandler;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtAuthenticationSuccessHandlerImpl;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtTokenAuthenticationFilter;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtTokenHelper;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtUsernamePasswordFiterLoginConfig;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.LogoutSuccess;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.QuartzManagerHttpSecurity;
import it.fabioformosa.quartzmanager.api.security.properties.InMemoryAccountProperties;
import it.fabioformosa.quartzmanager.api.security.properties.JwtSecurityProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@ComponentScan(basePackages={"it.fabioformosa.quartzmanager.api.security"})
@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class QuartzManagerSecurityConfig {
    private static final String[] PATTERNS_SWAGGER_UI = new String[]{"/swagger-ui/**", "/swagger-ui.html", "/v3/api-docs/**", "/swagger-resources/**", "/webjars/**"};
    public static final String QUARTZ_MANAGER_API_ANT_MATCHER = "/quartz-manager/**";
    public static final String QUARTZ_MANAGER_UI_ANT_MATCHER = "/quartz-manager-ui/**";
    @Value(value="${server.servlet.context-path:/}")
    private String contextPath;
    @Value(value="${app.name:quartz-manager}")
    private String appName;
    @Value(value="${quartz-manager.security.login-model.form-login-enabled:true}")
    private Boolean formLoginEnabled;
    @Value(value="${quartz-manager.security.login-model.userpwd-filter-enabled:false}")
    private Boolean userpwdFilterEnabled;
    @Autowired
    private JwtSecurityProperties jwtSecurityProps;
    @Autowired
    private ObjectMapper objectMapper;

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Bean
    public PasswordEncoder quartzManagerPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean(name={"quartzManagerInMemoryAuthentication"})
    public InMemoryUserDetailsManager configureInMemoryAuthentication(InMemoryAccountProperties inMemoryAccountProps, PasswordEncoder quartzManagerPasswordEncoder) throws Exception {
        List<Object> users = new ArrayList();
        if (inMemoryAccountProps.isEnabled() && inMemoryAccountProps.getUsers() != null && !inMemoryAccountProps.getUsers().isEmpty()) {
            users = inMemoryAccountProps.getUsers().stream().map(u -> User.withUsername((String)u.getUsername()).password(quartzManagerPasswordEncoder.encode((CharSequence)u.getPassword())).roles(u.getRoles().toArray(new String[0])).build()).collect(Collectors.toList());
        }
        return new InMemoryUserDetailsManager(users);
    }

    @Order(value=-2147483648)
    @Bean(name={"quartzManagerFilterChain"})
    public SecurityFilterChain filterChain(HttpSecurity http, @Qualifier(value="quartzManagerInMemoryAuthentication") InMemoryUserDetailsManager userDetailsService, AuthenticationManager authenticationManager) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.antMatcher(QUARTZ_MANAGER_API_ANT_MATCHER).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().authenticationEntryPoint(this.restAuthEntryPoint()).and()).addFilterBefore((Filter)this.jwtAuthenticationTokenFilter((UserDetailsService)userDetailsService), BasicAuthenticationFilter.class).authorizeRequests();
        QuartzManagerHttpSecurity.from(http).withLoginConfigurer(this.loginConfigurer(), this.logoutConfigurer()).login("/quartz-manager/auth/login", authenticationManager).logout("/quartz-manager/auth/logout");
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{QUARTZ_MANAGER_API_ANT_MATCHER})).authenticated();
        return (SecurityFilterChain)http.build();
    }

    @Bean(name={"quartzManagerWebSecurityCustomizer"})
    public WebSecurityCustomizer webSecurityCustomizer(@Value(value="${quartz-manager.oas.enabled:false}") Boolean oasEnabled) {
        return web -> {
            web.ignoring().antMatchers(HttpMethod.GET, new String[]{QUARTZ_MANAGER_UI_ANT_MATCHER});
            if (BooleanUtils.isNotFalse((Boolean)oasEnabled)) {
                web.ignoring().antMatchers(HttpMethod.GET, PATTERNS_SWAGGER_UI);
            }
        };
    }

    public LoginConfigurer formLoginConfigurer() {
        JwtAuthenticationSuccessHandler jwtAuthenticationSuccessHandler = this.jwtAuthenticationSuccessHandler();
        AuthenticationSuccessHandler authenticationSuccessHandler = new AuthenticationSuccessHandler(jwtAuthenticationSuccessHandler);
        AuthenticationFailureHandler authenticationFailureHandler = new AuthenticationFailureHandler();
        return new FormLoginConfig(authenticationSuccessHandler, authenticationFailureHandler);
    }

    @Bean(name={"quartzManagerJwtAuthenticationSuccessHandler"})
    public JwtAuthenticationSuccessHandler jwtAuthenticationSuccessHandler() {
        JwtTokenHelper jwtTokenHelper = this.jwtTokenHelper();
        return new JwtAuthenticationSuccessHandlerImpl(this.contextPath, this.jwtSecurityProps, jwtTokenHelper, this.objectMapper);
    }

    public JwtTokenAuthenticationFilter jwtAuthenticationTokenFilter(UserDetailsService userDetailsService) {
        return new JwtTokenAuthenticationFilter(this.jwtTokenHelper(), userDetailsService);
    }

    @Bean(name={"quartzManagerJwtTokenHelper"})
    public JwtTokenHelper jwtTokenHelper() {
        return new JwtTokenHelper(this.appName, this.jwtSecurityProps);
    }

    public LoginConfigurer loginConfigurer() {
        if (BooleanUtils.isTrue((Boolean)this.userpwdFilterEnabled)) {
            return this.userpwdFilterLoginConfigurer();
        }
        if (BooleanUtils.isNotFalse((Boolean)this.formLoginEnabled)) {
            return this.formLoginConfigurer();
        }
        throw new IllegalStateException("No login configurer enabled!");
    }

    public LogoutSuccess logoutConfigurer() {
        return new LogoutSuccess(this.objectMapper);
    }

    @Bean(name={"quartzManagerRestAuthEntryPoint"})
    public AuthenticationEntryPoint restAuthEntryPoint() {
        return new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED);
    }

    public LoginConfigurer userpwdFilterLoginConfigurer() {
        return new JwtUsernamePasswordFiterLoginConfig(this.jwtAuthenticationSuccessHandler());
    }
}

