/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import it.fabioformosa.quartzmanager.api.security.properties.JwtSecurityProperties;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(name={"quartz-manager.oas.enabled"})
@Configuration
@Generated
public class SecurityOpenApiConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityOpenApiConfig.class);

    @Order(value=-2147483648)
    @Bean(value={"quartzManagerOpenApiCustomiser"})
    public OpenApiCustomiser configureQuartzManagerOpenAPI(JwtSecurityProperties jwtSecurityProps) {
        return openAPI -> {
            if (!jwtSecurityProps.getCookieStrategy().isEnabled()) {
                openAPI.components(new Components().addSecuritySchemes("quartz-manager-auth", this.buildBasicAuthScheme()));
            }
            openAPI.path("/quartz-manager/auth/login", new PathItem().post(new Operation().operationId("login").tags(Arrays.asList("auth")).requestBody(new RequestBody().content(new Content().addMediaType("application/x-www-form-urlencoded", new MediaType().schema(new Schema().type("object").addProperties("username", (Schema)new StringSchema()).addProperties("password", (Schema)new PasswordSchema()).required(Arrays.asList("username", "password")))))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("JWT Token to authenticate the next requests"))).responses(new ApiResponses().addApiResponse("401", new ApiResponse().description("Unauthorized - Username or password are incorrect!")))));
        };
    }

    private SecurityScheme buildBasicAuthScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT").description("A JWT Token in required to access this API. You can obtain a JWT Token by providing the username and password in the login API");
    }
}

