/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security.helpers.impl;

import it.fabioformosa.quartzmanager.api.security.helpers.LoginConfigurer;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.AuthenticationFailureHandler;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.AuthenticationSuccessHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;

public class FormLoginConfig
implements LoginConfigurer {
    private static final Logger log = LoggerFactory.getLogger(FormLoginConfig.class);
    private final AuthenticationSuccessHandler authenticationSuccessHandler;
    private final AuthenticationFailureHandler authenticationFailureHandler;

    public FormLoginConfig() {
        this.authenticationSuccessHandler = null;
        this.authenticationFailureHandler = null;
    }

    public FormLoginConfig(AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationSuccessHandler = null;
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public FormLoginConfig(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        this.authenticationFailureHandler = null;
    }

    public FormLoginConfig(AuthenticationSuccessHandler authenticationSuccessHandler, AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    @Override
    public String cookieMustBeDeletedAtLogout() {
        return this.authenticationSuccessHandler.cookieMustBeDeletedAtLogout();
    }

    @Override
    public HttpSecurity login(String loginPath, HttpSecurity http, AuthenticationManager authenticationManager) throws Exception {
        log.debug("Configuring login through FormLoginConfigurer...");
        FormLoginConfigurer login = http.formLogin().loginPage(loginPath);
        if (this.authenticationSuccessHandler != null) {
            log.debug("Setting an authenticationSuccessHandler");
            login = (FormLoginConfigurer)login.successHandler((org.springframework.security.web.authentication.AuthenticationSuccessHandler)this.authenticationSuccessHandler);
        }
        if (this.authenticationFailureHandler != null) {
            log.debug("Setting an authenticationFailureHandler");
            login = (FormLoginConfigurer)login.failureHandler((org.springframework.security.web.authentication.AuthenticationFailureHandler)this.authenticationFailureHandler);
        }
        return (HttpSecurity)login.and();
    }
}

