/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security.helpers.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtAuthenticationSuccessHandler;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtTokenHelper;
import it.fabioformosa.quartzmanager.api.security.models.UserTokenState;
import it.fabioformosa.quartzmanager.api.security.properties.JwtSecurityProperties;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;

public class JwtAuthenticationSuccessHandlerImpl
implements JwtAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationSuccessHandlerImpl.class);
    private final JwtSecurityProperties jwtSecurityProps;
    private final JwtTokenHelper jwtTokenHelper;
    private final ObjectMapper objectMapper;
    private final String contextPath;

    @Autowired
    public JwtAuthenticationSuccessHandlerImpl(String contextPath, JwtSecurityProperties jwtSecurityProps, JwtTokenHelper jwtTokenHelper, ObjectMapper objectMapper) {
        this.contextPath = contextPath;
        this.jwtSecurityProps = jwtSecurityProps;
        this.jwtTokenHelper = jwtTokenHelper;
        this.objectMapper = objectMapper;
    }

    @Override
    public String cookieMustBeDeletedAtLogout() {
        if (!this.jwtSecurityProps.getCookieStrategy().isEnabled()) {
            return null;
        }
        return this.jwtSecurityProps.getCookieStrategy().getCookie();
    }

    @Override
    public void onLoginSuccess(Authentication authentication, HttpServletResponse response) throws IOException {
        log.debug("Login succeeded, generating jwtToken...");
        User user = (User)authentication.getPrincipal();
        String jwtToken = this.jwtTokenHelper.generateToken(user.getUsername());
        if (this.jwtSecurityProps.getCookieStrategy().isEnabled()) {
            Cookie authCookie = new Cookie(this.jwtSecurityProps.getCookieStrategy().getCookie(), jwtToken);
            authCookie.setHttpOnly(true);
            authCookie.setMaxAge((int)this.jwtSecurityProps.getExpirationInSec());
            authCookie.setPath(this.contextPath);
            response.addCookie(authCookie);
            log.debug("Set jwtToken into the cookie {}", (Object)this.jwtSecurityProps.getCookieStrategy().getCookie());
        }
        if (this.jwtSecurityProps.getHeaderStrategy().isEnabled()) {
            this.jwtTokenHelper.setHeader(response, jwtToken);
            log.debug("Set jwtToken into the response header {}", (Object)this.jwtSecurityProps.getHeaderStrategy().getHeader());
        }
        UserTokenState userTokenState = new UserTokenState(jwtToken, this.jwtSecurityProps.getExpirationInSec());
        String jwtResponse = this.objectMapper.writeValueAsString((Object)userTokenState);
        response.setContentType("application/json");
        response.getWriter().write(jwtResponse);
    }
}

