/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security.helpers.impl;

import it.fabioformosa.quartzmanager.api.security.helpers.impl.AnonAuthentication;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtTokenBasedAuthentication;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.JwtTokenHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtTokenAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenAuthenticationFilter.class);
    private static final String ROOT_MATCHER = "/";
    private static final String FAVICON_MATCHER = "/favicon.ico";
    private static final String HTML_MATCHER = "/**/*.html";
    private static final String CSS_MATCHER = "/**/*.css";
    private static final String JS_MATCHER = "/**/*.js";
    private static final String IMG_MATCHER = "/images/*";
    private static final String LOGIN_MATCHER = "/api/login";
    private static final String LOGOUT_MATCHER = "/api/logout";
    private static final List<String> PATH_TO_SKIP = Arrays.asList("/", "/**/*.html", "/favicon.ico", "/**/*.css", "/**/*.js", "/images/*", "/api/login", "/api/logout");
    private final JwtTokenHelper jwtTokenHelper;
    private final UserDetailsService userDetailsService;

    public JwtTokenAuthenticationFilter(JwtTokenHelper jwtTokenHelper, UserDetailsService userDetailsService) {
        this.jwtTokenHelper = jwtTokenHelper;
        this.userDetailsService = userDetailsService;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String jwtToken = this.jwtTokenHelper.retrieveToken(request);
        if (jwtToken != null) {
            log.debug("Found a jwtToken into the request {}", (Object)request.getPathInfo());
            try {
                String username = this.jwtTokenHelper.verifyTokenAndExtractUsername(jwtToken);
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                JwtTokenBasedAuthentication authentication = new JwtTokenBasedAuthentication(userDetails);
                authentication.setToken(jwtToken);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
            catch (Exception e) {
                log.error("Authentication failed! an expected error occurred authenticating the request {} due to {}", new Object[]{request.getRequestURL(), e.getMessage(), e});
            }
        } else if (this.skipPathRequest(request, PATH_TO_SKIP)) {
            log.debug("Detected a path to be skipped from authentication, so activated anonymous auth for {}", (Object)request.getRequestURL());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonAuthentication());
        } else {
            log.debug("Not found any jwtToken and the request hasn't a path to be skipped from auth. Path: {}", (Object)request.getRequestURL());
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean skipPathRequest(HttpServletRequest request, List<String> pathsToSkip) {
        if (pathsToSkip == null) {
            pathsToSkip = new ArrayList<String>();
        }
        List matchers = pathsToSkip.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList());
        OrRequestMatcher compositeMatchers = new OrRequestMatcher(matchers);
        return compositeMatchers.matches(request);
    }
}

