/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security.helpers.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import it.fabioformosa.quartzmanager.api.security.properties.JwtSecurityProperties;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenHelper {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenHelper.class);
    private final String appName;
    private final JwtSecurityProperties jwtSecurityProps;
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.HS512;

    private static String base64EncodeSecretKey(String secretKey) {
        return Base64.getEncoder().encodeToString(secretKey.getBytes(StandardCharsets.UTF_8));
    }

    public JwtTokenHelper(String appName, JwtSecurityProperties jwtSecurityProps) {
        this.appName = appName;
        this.jwtSecurityProps = jwtSecurityProps;
    }

    public Boolean canTokenBeRefreshed(String token) {
        try {
            Date expirationDate = this.verifyAndGetClaimsFromToken(token).getExpiration();
            return expirationDate.compareTo(this.generateCurrentDate()) > 0;
        }
        catch (Exception e) {
            log.error("Error getting claims from jwt token due to " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private Date generateCurrentDate() {
        return new Date(this.getCurrentTimeMillis());
    }

    private Date generateExpirationDate() {
        return new Date(this.getCurrentTimeMillis() + this.jwtSecurityProps.getExpirationInSec() * 1000L);
    }

    private String generateToken(Map<String, Object> claims) {
        return Jwts.builder().setClaims(claims).setExpiration(this.generateExpirationDate()).signWith(SIGNATURE_ALGORITHM, JwtTokenHelper.base64EncodeSecretKey(this.jwtSecurityProps.getSecret())).compact();
    }

    public String generateToken(String username) {
        return Jwts.builder().setIssuer(this.appName).setSubject(username).setIssuedAt(this.generateCurrentDate()).setExpiration(this.generateExpirationDate()).signWith(SIGNATURE_ALGORITHM, JwtTokenHelper.base64EncodeSecretKey(this.jwtSecurityProps.getSecret())).compact();
    }

    private Claims verifyAndGetClaimsFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(JwtTokenHelper.base64EncodeSecretKey(this.jwtSecurityProps.getSecret())).parseClaimsJws(token).getBody();
        if (claims == null) {
            throw new IllegalStateException("Not found any claims into the JWT token!");
        }
        return claims;
    }

    public Cookie getCookieValueByName(HttpServletRequest request, String name) {
        if (request.getCookies() == null) {
            return null;
        }
        for (int i = 0; i < request.getCookies().length; ++i) {
            if (!request.getCookies()[i].getName().equals(name)) continue;
            return request.getCookies()[i];
        }
        return null;
    }

    private long getCurrentTimeMillis() {
        return LocalDateTime.now().atZone(ZoneId.of("Europe/Rome")).toInstant().toEpochMilli();
    }

    public String verifyTokenAndExtractUsername(String token) {
        Claims claims = this.verifyAndGetClaimsFromToken(token);
        return claims.getSubject();
    }

    public String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = this.verifyAndGetClaimsFromToken(token);
            claims.setIssuedAt(this.generateCurrentDate());
            refreshedToken = this.generateToken((Map<String, Object>)claims);
        }
        catch (Exception e) {
            log.error("Error refreshing jwt token due to " + e.getMessage(), (Throwable)e);
            refreshedToken = null;
        }
        return refreshedToken;
    }

    public String retrieveToken(HttpServletRequest request) {
        String authHeader;
        Cookie authCookie;
        if (this.jwtSecurityProps.getCookieStrategy().isEnabled() && (authCookie = this.getCookieValueByName(request, this.jwtSecurityProps.getCookieStrategy().getCookie())) != null) {
            return authCookie.getValue();
        }
        if (this.jwtSecurityProps.getHeaderStrategy().isEnabled() && (authHeader = request.getHeader(this.jwtSecurityProps.getHeaderStrategy().getHeader())) != null && authHeader.startsWith("Bearer ")) {
            return authHeader.substring(7);
        }
        if (request.getParameter("access_token") != null) {
            return request.getParameter("access_token");
        }
        return null;
    }

    public void setHeader(HttpServletResponse response, String token) {
        response.addHeader(this.jwtSecurityProps.getHeaderStrategy().getHeader(), "Bearer " + token);
    }
}

