/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security.helpers.impl;

import it.fabioformosa.quartzmanager.api.security.helpers.LoginConfigurer;
import it.fabioformosa.quartzmanager.api.security.helpers.impl.LogoutSuccess;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class QuartzManagerHttpSecurity
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private HttpSecurity httpSecurity;
    private LoginConfigurer loginConfigurer;
    private LogoutSuccess logoutSuccess;

    public static QuartzManagerHttpSecurity from(HttpSecurity httpSecurity) {
        QuartzManagerHttpSecurity newInstance = new QuartzManagerHttpSecurity(httpSecurity);
        newInstance.setBuilder((SecurityBuilder)httpSecurity);
        return newInstance;
    }

    public QuartzManagerHttpSecurity(HttpSecurity httpSecurity) {
        this.httpSecurity = httpSecurity;
    }

    public QuartzManagerHttpSecurity login(String loginPath, AuthenticationManager authenticationManager) throws Exception {
        if (this.loginConfigurer == null || this.logoutSuccess == null) {
            throw new IllegalStateException("QuartzManagerHttpSecurity requires to be set loginConfigurer and logoutSuccess!");
        }
        this.httpSecurity = this.loginConfigurer.login(loginPath, this.httpSecurity, authenticationManager);
        return this;
    }

    public LogoutConfigurer<HttpSecurity> logout(String logoutPath) throws Exception {
        LogoutConfigurer logoutConfigurer = this.httpSecurity.logout().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher(logoutPath)).logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccess);
        String cookie = this.loginConfigurer.cookieMustBeDeletedAtLogout();
        if (cookie != null) {
            logoutConfigurer.deleteCookies(new String[]{cookie});
        }
        return logoutConfigurer;
    }

    public QuartzManagerHttpSecurity withLoginConfigurer(LoginConfigurer loginConfigurer, LogoutSuccess logoutSuccess) {
        this.loginConfigurer = loginConfigurer;
        this.logoutSuccess = logoutSuccess;
        return this;
    }
}

