/*
 * Decompiled with CFR 0.152.
 */
package it.fabioformosa.quartzmanager.api.security.properties;

import java.security.SecureRandom;
import java.util.Base64;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="quartz-manager.security.jwt")
public class JwtSecurityProperties {
    private String secret;
    private long expirationInSec = 28800L;
    private CookieStrategy cookieStrategy = new CookieStrategy();
    private HeaderStrategy headerStrategy = new HeaderStrategy();

    public JwtSecurityProperties() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        this.secret = encoder.encodeToString(bytes);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtSecurityProperties)) {
            return false;
        }
        JwtSecurityProperties other = (JwtSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpirationInSec() != other.getExpirationInSec()) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        CookieStrategy this$cookieStrategy = this.getCookieStrategy();
        CookieStrategy other$cookieStrategy = other.getCookieStrategy();
        if (this$cookieStrategy == null ? other$cookieStrategy != null : !((Object)this$cookieStrategy).equals(other$cookieStrategy)) {
            return false;
        }
        HeaderStrategy this$headerStrategy = this.getHeaderStrategy();
        HeaderStrategy other$headerStrategy = other.getHeaderStrategy();
        return !(this$headerStrategy == null ? other$headerStrategy != null : !((Object)this$headerStrategy).equals(other$headerStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JwtSecurityProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expirationInSec = this.getExpirationInSec();
        result = result * 59 + (int)($expirationInSec >>> 32 ^ $expirationInSec);
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        CookieStrategy $cookieStrategy = this.getCookieStrategy();
        result = result * 59 + ($cookieStrategy == null ? 43 : ((Object)$cookieStrategy).hashCode());
        HeaderStrategy $headerStrategy = this.getHeaderStrategy();
        result = result * 59 + ($headerStrategy == null ? 43 : ((Object)$headerStrategy).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JwtSecurityProperties(secret=" + this.getSecret() + ", expirationInSec=" + this.getExpirationInSec() + ", cookieStrategy=" + this.getCookieStrategy() + ", headerStrategy=" + this.getHeaderStrategy() + ")";
    }

    @Generated
    public JwtSecurityProperties(String secret, long expirationInSec, CookieStrategy cookieStrategy, HeaderStrategy headerStrategy) {
        this.secret = secret;
        this.expirationInSec = expirationInSec;
        this.cookieStrategy = cookieStrategy;
        this.headerStrategy = headerStrategy;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public long getExpirationInSec() {
        return this.expirationInSec;
    }

    @Generated
    public CookieStrategy getCookieStrategy() {
        return this.cookieStrategy;
    }

    @Generated
    public HeaderStrategy getHeaderStrategy() {
        return this.headerStrategy;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setExpirationInSec(long expirationInSec) {
        this.expirationInSec = expirationInSec;
    }

    @Generated
    public void setCookieStrategy(CookieStrategy cookieStrategy) {
        this.cookieStrategy = cookieStrategy;
    }

    @Generated
    public void setHeaderStrategy(HeaderStrategy headerStrategy) {
        this.headerStrategy = headerStrategy;
    }

    public static class HeaderStrategy {
        private boolean enabled = true;
        private String header = "Authorization";

        @Generated
        public HeaderStrategy() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getHeader() {
            return this.header;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setHeader(String header) {
            this.header = header;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HeaderStrategy)) {
                return false;
            }
            HeaderStrategy other = (HeaderStrategy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$header = this.getHeader();
            String other$header = other.getHeader();
            return !(this$header == null ? other$header != null : !this$header.equals(other$header));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HeaderStrategy;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JwtSecurityProperties.HeaderStrategy(enabled=" + this.isEnabled() + ", header=" + this.getHeader() + ")";
        }
    }

    public static class CookieStrategy {
        private boolean enabled = false;
        private String cookie = "AUTH-TOKEN";

        @Generated
        public CookieStrategy() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getCookie() {
            return this.cookie;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setCookie(String cookie) {
            this.cookie = cookie;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CookieStrategy)) {
                return false;
            }
            CookieStrategy other = (CookieStrategy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$cookie = this.getCookie();
            String other$cookie = other.getCookie();
            return !(this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CookieStrategy;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $cookie = this.getCookie();
            result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JwtSecurityProperties.CookieStrategy(enabled=" + this.isEnabled() + ", cookie=" + this.getCookie() + ")";
        }
    }
}

