/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork;

import android.content.Context;
import android.net.NetworkRequest;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RequiresPermission;
import android.support.annotation.VisibleForTesting;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.net.RxNetworkInfo;
import greyfox.rxnetwork.internal.strategy.internet.InternetObservingStrategy;
import greyfox.rxnetwork.internal.strategy.internet.InternetObservingStrategyFactory;
import greyfox.rxnetwork.internal.strategy.internet.impl.WalledGardenInternetObservingStrategy;
import greyfox.rxnetwork.internal.strategy.network.NetworkObservingStrategy;
import greyfox.rxnetwork.internal.strategy.network.NetworkObservingStrategyFactory;
import greyfox.rxnetwork.internal.strategy.network.factory.BuiltInNetworkObservingStrategyFactory;
import greyfox.rxnetwork.internal.strategy.network.helpers.Functions;
import greyfox.rxnetwork.internal.strategy.network.providers.BuiltInNetworkObservingStrategyProviders;
import io.reactivex.Observable;
import io.reactivex.Scheduler;

public final class RxNetwork {
    @NonNull
    private final NetworkObservingStrategy networkObservingStrategy;
    @NonNull
    private final InternetObservingStrategy internetObservingStrategy;
    @Nullable
    private final NetworkRequest networkRequest;
    @Nullable
    private final Scheduler scheduler;

    @VisibleForTesting
    RxNetwork() {
        throw new AssertionError((Object)"Use static factory methods or Builder to initialize RxNetwork");
    }

    @VisibleForTesting
    RxNetwork(@NonNull Builder builder) {
        Preconditions.checkNotNull(builder, "builder");
        this.scheduler = builder.scheduler;
        this.networkObservingStrategy = builder.networkObservingStrategy;
        this.internetObservingStrategy = builder.internetObservingStrategy;
        this.networkRequest = builder.networkRequest;
    }

    @NonNull
    public static RxNetwork init(@NonNull Context context) {
        return RxNetwork.builder().init(context.getApplicationContext());
    }

    @NonNull
    public static RxNetwork init() {
        return RxNetwork.builder().init();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    @VisibleForTesting
    Scheduler scheduler() {
        return this.scheduler;
    }

    @NonNull
    @VisibleForTesting
    NetworkObservingStrategy networkObservingStrategy() {
        return this.networkObservingStrategy;
    }

    @NonNull
    @VisibleForTesting
    InternetObservingStrategy internetObservingStrategy() {
        return this.internetObservingStrategy;
    }

    @Nullable
    @VisibleForTesting
    NetworkRequest networkRequest() {
        return this.networkRequest;
    }

    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public Observable<RxNetworkInfo> observe() {
        return this.observe(this.networkObservingStrategy);
    }

    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public Observable<RxNetworkInfo> observe(@NonNull NetworkObservingStrategy strategy) {
        Preconditions.checkNotNullWithMessage(strategy, "Please provide network observing strategy or initialize RxNetwork with proper Context to use the default one");
        Observable observable = strategy.observe();
        if (this.scheduler != null) {
            observable.subscribeOn(this.scheduler);
        }
        return observable;
    }

    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public Observable<Boolean> observeSimple() {
        return this.observe().map(Functions.TO_CONNECTION_STATE);
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERNET")
    public Observable<Boolean> observeInternetAccess() {
        return this.observeInternetAccess(this.internetObservingStrategy);
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERNET")
    public Observable<Boolean> observeInternetAccess(@NonNull InternetObservingStrategy strategy) {
        Preconditions.checkNotNull(strategy, "internet observing strategy");
        Observable observable = strategy.observe();
        if (this.scheduler != null) {
            observable.subscribeOn(this.scheduler);
        }
        return observable;
    }

    public static final class Builder {
        private Scheduler scheduler;
        private NetworkObservingStrategy networkObservingStrategy;
        private InternetObservingStrategy internetObservingStrategy;
        private NetworkRequest networkRequest;

        Builder() {
        }

        public Builder defaultScheduler(@NonNull Scheduler scheduler) {
            this.scheduler = Preconditions.checkNotNull(scheduler, "scheduler");
            return this;
        }

        public Builder networkObservingStrategy(@NonNull NetworkObservingStrategy strategy) {
            this.networkObservingStrategy = Preconditions.checkNotNull(strategy, "network observing strategy");
            return this;
        }

        public Builder networkObservingStrategyFactory(@NonNull NetworkObservingStrategyFactory factory) {
            Preconditions.checkNotNull(factory, "network observing strategy factory");
            this.networkObservingStrategy = (NetworkObservingStrategy)factory.get();
            return this;
        }

        public Builder internetObservingStrategy(@NonNull InternetObservingStrategy strategy) {
            this.internetObservingStrategy = Preconditions.checkNotNull(strategy, "internet observing strategy");
            return this;
        }

        public Builder internetObservingStrategyFactory(@NonNull InternetObservingStrategyFactory factory) {
            Preconditions.checkNotNull(factory, "internet observing strategy factory");
            this.internetObservingStrategy = (InternetObservingStrategy)factory.get();
            return this;
        }

        @RequiresApi(value=21)
        public Builder defaultNetworkRequest(@NonNull NetworkRequest networkRequest) {
            this.networkRequest = Preconditions.checkNotNull(networkRequest, "networkRequest");
            return this;
        }

        @NonNull
        public RxNetwork init(@NonNull Context context) {
            Preconditions.checkNotNull(context, "Cannot initialize RxNetwork with null context");
            if (this.networkObservingStrategy == null) {
                this.networkObservingStrategy = this.getNetworkObservingStrategy(context);
            }
            return this.init();
        }

        @NonNull
        public RxNetwork init() {
            if (this.internetObservingStrategy == null) {
                this.internetObservingStrategy = WalledGardenInternetObservingStrategy.create();
            }
            return new RxNetwork(this);
        }

        private NetworkObservingStrategy getNetworkObservingStrategy(@NonNull Context context) {
            BuiltInNetworkObservingStrategyProviders providers = this.networkRequest == null ? new BuiltInNetworkObservingStrategyProviders(context) : new BuiltInNetworkObservingStrategyProviders(context, this.networkRequest);
            this.networkObservingStrategy = (NetworkObservingStrategy)BuiltInNetworkObservingStrategyFactory.create(providers).get();
            return this.networkObservingStrategy;
        }
    }
}

