/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.common.base;

import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Preconditions {
    @VisibleForTesting
    Preconditions() {
        throw new AssertionError((Object)"No instances");
    }

    public static <T> T checkNotNull(T reference) {
        return Preconditions.checkNotNull(reference, "Provided reference must not be null");
    }

    public static <T> T checkNotNull(T reference, String name) {
        if (reference == null) {
            throw new NullPointerException(name + " must not be null");
        }
        return reference;
    }

    public static <T> T checkNotNullWithMessage(T reference, String message) {
        if (reference == null) {
            throw new NullPointerException(message);
        }
        return reference;
    }

    public static <T> T checkNotNullWithMessage(T reference, String messageFormat, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(String.format(messageFormat, args));
        }
        return reference;
    }
}

