/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import greyfox.rxnetwork.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RxNetworkInfo {
    private final NetworkInfo.State state;
    private final NetworkInfo.DetailedState detailedState;
    private final int type;
    private final int subType;
    private final boolean available;
    private final boolean connectedOrConnecting;
    private final boolean connected;
    private final boolean failover;
    private final boolean roaming;
    private final String typeName;
    private final String subTypeName;
    private final String reason;
    private final String extraInfo;
    private final NetworkCapabilities networkCapabilities;

    @VisibleForTesting
    RxNetworkInfo() {
        throw new AssertionError((Object)"Use static factory methods or Builder to create RxNetworkInfo");
    }

    @VisibleForTesting
    RxNetworkInfo(@NonNull Builder builder) {
        Preconditions.checkNotNull(builder, "builder");
        this.state = builder.state;
        this.detailedState = builder.detailedState;
        this.type = builder.type;
        this.subType = builder.subType;
        this.available = builder.available;
        this.connectedOrConnecting = builder.connectedOrConnecting;
        this.connected = builder.connected;
        this.failover = builder.failover;
        this.roaming = builder.roaming;
        this.typeName = builder.typeName;
        this.subTypeName = builder.subTypeName;
        this.reason = builder.reason;
        this.extraInfo = builder.extraInfo;
        this.networkCapabilities = builder.networkCapabilities;
    }

    public static RxNetworkInfo create() {
        return new Builder().build();
    }

    public static RxNetworkInfo create(@NonNull NetworkInfo networkInfo) {
        Preconditions.checkNotNull(networkInfo, "networkInfo");
        return RxNetworkInfo.builder(networkInfo).build();
    }

    public static RxNetworkInfo create(@NonNull Context context) {
        Preconditions.checkNotNull(context, "context");
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        return networkInfo == null ? RxNetworkInfo.create() : RxNetworkInfo.create(networkInfo);
    }

    @RequiresApi(value=21)
    public static RxNetworkInfo create(@NonNull Network network, @NonNull ConnectivityManager connectivityManager) {
        Preconditions.checkNotNull(network, "network");
        Preconditions.checkNotNull(connectivityManager, "manager");
        NetworkInfo networkInfo = Helper.getNetworkInfo(network, connectivityManager);
        NetworkCapabilities capabilities = Helper.getCapabilities(network, connectivityManager);
        return networkInfo != null ? RxNetworkInfo.builder(networkInfo).networkCapabilities(capabilities).build() : RxNetworkInfo.create();
    }

    public static Builder builder() {
        return new Builder();
    }

    static Builder builder(@NonNull NetworkInfo networkInfo) {
        Preconditions.checkNotNull(networkInfo, "networkInfo");
        return new Builder().state(networkInfo.getState()).detailedState(networkInfo.getDetailedState()).type(networkInfo.getType()).subType(networkInfo.getSubtype()).available(networkInfo.isAvailable()).connected(networkInfo.isConnected()).connectedOrConnecting(networkInfo.isConnectedOrConnecting()).failover(networkInfo.isFailover()).roaming(networkInfo.isRoaming()).typeName(networkInfo.getTypeName()).subTypeName(networkInfo.getSubtypeName()).reason(networkInfo.getReason()).extraInfo(networkInfo.getExtraInfo());
    }

    public NetworkInfo.State getState() {
        return this.state;
    }

    public NetworkInfo.DetailedState getDetailedState() {
        return this.detailedState;
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subType;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isFailover() {
        return this.failover;
    }

    public boolean isRoaming() {
        return this.roaming;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getSubTypeName() {
        return this.subTypeName;
    }

    public boolean isConnectedOrConnecting() {
        return this.connectedOrConnecting;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getReason() {
        return this.reason;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    @RequiresApi(value=21)
    public NetworkCapabilities getNetworkCapabilities() {
        return this.networkCapabilities;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.state == null ? 0 : this.state.hashCode();
        h *= 1000003;
        h ^= this.detailedState == null ? 0 : this.detailedState.hashCode();
        h *= 1000003;
        h ^= this.type;
        h *= 1000003;
        h ^= this.subType;
        h *= 1000003;
        h ^= this.available ? 1231 : 1237;
        h *= 1000003;
        h ^= this.connectedOrConnecting ? 1231 : 1237;
        h *= 1000003;
        h ^= this.connected ? 1231 : 1237;
        h *= 1000003;
        h ^= this.failover ? 1231 : 1237;
        h *= 1000003;
        h ^= this.roaming ? 1231 : 1237;
        h *= 1000003;
        h ^= this.typeName == null ? 0 : this.typeName.hashCode();
        h *= 1000003;
        h ^= this.subTypeName == null ? 0 : this.subTypeName.hashCode();
        h *= 1000003;
        h ^= this.reason == null ? 0 : this.reason.hashCode();
        h *= 1000003;
        h ^= this.extraInfo == null ? 0 : this.extraInfo.hashCode();
        h *= 1000003;
        return h ^= this.networkCapabilities == null ? 0 : this.networkCapabilities.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RxNetworkInfo) {
            RxNetworkInfo that = (RxNetworkInfo)o;
            return (this.state == null ? that.state == null : this.state.equals((Object)that.state)) && (this.detailedState == null ? that.detailedState == null : this.detailedState.equals((Object)that.detailedState)) && this.type == that.type && this.subType == that.subType && this.available == that.available && this.connectedOrConnecting == that.connectedOrConnecting && this.connected == that.connected && this.failover == that.failover && this.roaming == that.roaming && (this.typeName == null ? that.typeName == null : this.typeName.equals(that.typeName)) && (this.subTypeName == null ? that.subTypeName == null : this.subTypeName.equals(that.subTypeName)) && (this.reason == null ? that.reason == null : this.reason.equals(that.reason)) && (this.extraInfo == null ? that.extraInfo == null : this.extraInfo.equals(that.extraInfo)) && (this.networkCapabilities == null ? that.networkCapabilities == null : this.networkCapabilities.equals((Object)that.networkCapabilities));
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public String toString() {
        return "RxNetworkInfo{state=" + this.state + ", detailedState=" + this.detailedState + ", type=" + this.type + ", subType=" + this.subType + ", available=" + this.available + ", connectedOrConnecting=" + this.connectedOrConnecting + ", connected=" + this.connected + ", failover=" + this.failover + ", roaming=" + this.roaming + ", typeName=" + this.typeName + ", subTypeName=" + this.subTypeName + ", reason=" + this.reason + ", extraInfo=" + this.extraInfo + ", networkCapabilities=" + this.networkCapabilities + "}";
    }

    static final class Helper {
        private static final Logger logger = Logger.getLogger(Helper.class.getSimpleName());

        @VisibleForTesting
        Helper() {
            throw new AssertionError((Object)"No instances.");
        }

        @RequiresApi(value=21)
        @Nullable
        static NetworkCapabilities getCapabilities(@NonNull Network network, @NonNull ConnectivityManager connectivityManager) {
            NetworkCapabilities networkCapabilities = null;
            try {
                networkCapabilities = connectivityManager.getNetworkCapabilities(network);
            }
            catch (Exception exc) {
                logger.log(Level.WARNING, "Could not retrieve network capabilities from provided network: " + exc.getMessage());
            }
            return networkCapabilities;
        }

        @RequiresApi(value=21)
        @Nullable
        static NetworkInfo getNetworkInfo(@NonNull Network network, @NonNull ConnectivityManager connectivityManager) {
            NetworkInfo networkInfo = null;
            try {
                networkInfo = connectivityManager.getNetworkInfo(network);
            }
            catch (Exception exc) {
                logger.log(Level.WARNING, "Could not retrieve network info from provided network: " + exc.getMessage());
            }
            return networkInfo;
        }
    }

    public static final class Builder {
        private static final int TYPE_UNKNOWN = -1;
        private static final String NAME_UNKNOWN = "unknown";
        private NetworkInfo.State state = NetworkInfo.State.UNKNOWN;
        private NetworkInfo.DetailedState detailedState = NetworkInfo.DetailedState.IDLE;
        private int type = -1;
        private int subType = -1;
        private boolean available;
        private boolean connectedOrConnecting;
        private boolean connected;
        private boolean failover;
        private boolean roaming;
        private String typeName = "unknown";
        private String subTypeName = "unknown";
        private String reason = "";
        private String extraInfo = "";
        private NetworkCapabilities networkCapabilities;

        Builder() {
        }

        public Builder state(NetworkInfo.State state) {
            this.state = state;
            return this;
        }

        public Builder detailedState(NetworkInfo.DetailedState detailedState) {
            this.detailedState = detailedState;
            return this;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder subType(int subType) {
            this.subType = subType;
            return this;
        }

        public Builder available(boolean available) {
            this.available = available;
            return this;
        }

        public Builder connectedOrConnecting(boolean connectedOrConnecting) {
            this.connectedOrConnecting = connectedOrConnecting;
            return this;
        }

        public Builder connected(boolean connected) {
            this.connected = connected;
            return this;
        }

        public Builder failover(boolean failover) {
            this.failover = failover;
            return this;
        }

        public Builder roaming(boolean roaming) {
            this.roaming = roaming;
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder subTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder extraInfo(String extraInfo) {
            this.extraInfo = extraInfo;
            return this;
        }

        @RequiresApi(value=21)
        public Builder networkCapabilities(NetworkCapabilities networkCapabilities) {
            this.networkCapabilities = networkCapabilities;
            return this;
        }

        public RxNetworkInfo build() {
            return new RxNetworkInfo(this);
        }
    }
}

