/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.internet.impl;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.strategy.internet.InternetObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class BaseInternetObservingStrategy
implements InternetObservingStrategy {
    private long delay;
    private long interval;

    BaseInternetObservingStrategy(@NonNull Builder builder) {
        Preconditions.checkNotNull(builder, "builder");
        this.delay = builder.delay;
        this.interval = builder.interval;
    }

    abstract Logger logger();

    private Function<Long, Boolean> toConnectionState() {
        return new Function<Long, Boolean>(){

            public Boolean apply(Long tick) throws Exception {
                return BaseInternetObservingStrategy.this.checkConnection();
            }
        };
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Observable<Boolean> observe() {
        return Observable.interval((long)this.delay, (long)this.interval, (TimeUnit)TimeUnit.MILLISECONDS).map(this.toConnectionState()).distinctUntilChanged();
    }

    abstract boolean checkConnection();

    void onError(String message, Exception exception) {
        this.logger().log(Level.WARNING, message + ": " + exception.getMessage() + (exception.getCause() != null ? ": " + exception.getCause().getMessage() : ""));
    }

    static abstract class Builder<S extends BaseInternetObservingStrategy, B extends Builder<S, B>> {
        private static final int DEFAULT_DELAY_MS = 0;
        private static final int DEFAULT_INTERVAL_MS = 3000;
        private long delay = 0L;
        private long interval = 3000L;

        protected Builder() {
        }

        final B self() {
            return (B)this;
        }

        @NonNull
        public B delay(long delay) {
            this.delay = delay;
            return this.self();
        }

        @NonNull
        public B interval(long interval) {
            this.interval = interval;
            return this.self();
        }

        @NonNull
        public abstract S build();
    }
}

