/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.internet.impl;

import android.support.annotation.NonNull;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.strategy.internet.error.InternetObservingStrategyException;
import greyfox.rxnetwork.internal.strategy.internet.impl.UrlConnectionInternetObservingStrategy;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Logger;

public final class HttpOkInternetObservingStrategy
extends UrlConnectionInternetObservingStrategy {
    HttpOkInternetObservingStrategy(@NonNull Builder builder) {
        super(builder);
    }

    @NonNull
    public static HttpOkInternetObservingStrategy create() {
        return HttpOkInternetObservingStrategy.builder().build();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    boolean isConnected(@NonNull HttpURLConnection urlConnection) throws InternetObservingStrategyException {
        Preconditions.checkNotNull(urlConnection, "urlConnection");
        try {
            return urlConnection.getResponseCode() == 200;
        }
        catch (IOException ioe) {
            throw new InternetObservingStrategyException("Unable to check internet access", ioe);
        }
    }

    @Override
    Logger logger() {
        return Logger.getLogger(HttpOkInternetObservingStrategy.class.getSimpleName());
    }

    public static final class Builder
    extends UrlConnectionInternetObservingStrategy.Builder<HttpOkInternetObservingStrategy, Builder> {
        private static final String DEFAULT_ENDPOINT = "http://google.cn/blank.html";
        private static final int DEFAULT_TIMEOUT_MS = 3000;

        Builder() {
            this.endpoint(DEFAULT_ENDPOINT);
            this.timeout(3000);
        }

        @Override
        @NonNull
        public HttpOkInternetObservingStrategy build() {
            return new HttpOkInternetObservingStrategy(this);
        }
    }
}

