/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.internet.impl;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import greyfox.rxnetwork.internal.strategy.internet.impl.EndpointInternetObservingStrategy;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Logger;

public final class SocketInternetObservingStrategy
extends EndpointInternetObservingStrategy {
    private final int port;

    @VisibleForTesting
    SocketInternetObservingStrategy(@NonNull Builder builder) {
        super(builder);
        this.port = builder.port;
    }

    @NonNull
    public static SocketInternetObservingStrategy create() {
        return SocketInternetObservingStrategy.builder().build();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    Logger logger() {
        return Logger.getLogger(SocketInternetObservingStrategy.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean checkConnection() {
        boolean isConnected;
        Socket socket = null;
        try {
            socket = this.connectSocketTo(new InetSocketAddress(this.endpoint(), this.port), this.timeout());
            isConnected = this.isSocketConnected(socket);
        }
        catch (IOException ioe) {
            this.onError("Problem occurred while checking endpoint", ioe);
            isConnected = Boolean.FALSE;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ioe) {
                this.onError("Could not close the socket", ioe);
            }
        }
        return isConnected;
    }

    Socket connectSocketTo(SocketAddress socketAddress, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(socketAddress, timeout);
        return socket;
    }

    private boolean isSocketConnected(Socket socket) {
        return socket.isConnected();
    }

    public static final class Builder
    extends EndpointInternetObservingStrategy.Builder<SocketInternetObservingStrategy, Builder> {
        private static final String DEFAULT_ENDPOINT = "google.cn";
        private static final int DEFAULT_PORT = 80;
        private int port = 80;

        Builder() {
            this.endpoint(DEFAULT_ENDPOINT);
        }

        @NonNull
        public Builder port(int port) {
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("Invalid port: " + port);
            }
            this.port = port;
            return (Builder)this.self();
        }

        @Override
        @NonNull
        public SocketInternetObservingStrategy build() {
            return new SocketInternetObservingStrategy(this);
        }
    }
}

