/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.internet.impl;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.strategy.internet.error.InternetObservingStrategyException;
import greyfox.rxnetwork.internal.strategy.internet.impl.EndpointInternetObservingStrategy;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

abstract class UrlConnectionInternetObservingStrategy
extends EndpointInternetObservingStrategy {
    UrlConnectionInternetObservingStrategy(@NonNull Builder builder) {
        super(builder);
    }

    @VisibleForTesting
    HttpURLConnection buildUrlConnection(@NonNull URL url) throws InternetObservingStrategyException {
        HttpURLConnection urlConnection;
        Preconditions.checkNotNull(url, "url");
        try {
            urlConnection = (HttpURLConnection)url.openConnection();
            this.setUpUrlConnectionForStrategy(urlConnection);
        }
        catch (IOException ioe) {
            throw new InternetObservingStrategyException("Could not create valid connection from " + url.toString(), ioe);
        }
        return urlConnection;
    }

    private void setUpUrlConnectionForStrategy(@NonNull HttpURLConnection urlConnection) throws IOException {
        Preconditions.checkNotNull(urlConnection, "urlConnection");
        urlConnection.setInstanceFollowRedirects(false);
        urlConnection.setConnectTimeout(this.timeout());
        urlConnection.setReadTimeout(this.timeout());
        urlConnection.setUseCaches(false);
        urlConnection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean checkConnection() {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.buildUrlConnection(this.url());
            boolean bl = this.isConnected(urlConnection);
            return bl;
        }
        catch (InternetObservingStrategyException iose) {
            this.onError("Problem occurred while checking endpoint", iose);
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private URL url() throws InternetObservingStrategyException {
        try {
            return new URL(this.endpoint());
        }
        catch (MalformedURLException mue) {
            throw new InternetObservingStrategyException("Couldn't create valid endpoint", mue);
        }
    }

    abstract boolean isConnected(@NonNull HttpURLConnection var1) throws InternetObservingStrategyException;

    static abstract class Builder<S extends UrlConnectionInternetObservingStrategy, B extends Builder<S, B>>
    extends EndpointInternetObservingStrategy.Builder<S, B> {
        protected Builder() {
        }
    }
}

