/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.internet.impl;

import android.support.annotation.NonNull;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.strategy.internet.error.InternetObservingStrategyException;
import greyfox.rxnetwork.internal.strategy.internet.impl.UrlConnectionInternetObservingStrategy;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Logger;

public final class WalledGardenInternetObservingStrategy
extends UrlConnectionInternetObservingStrategy {
    WalledGardenInternetObservingStrategy(@NonNull Builder builder) {
        super(builder);
    }

    @NonNull
    public static WalledGardenInternetObservingStrategy create() {
        return WalledGardenInternetObservingStrategy.builder().build();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    boolean isConnected(@NonNull HttpURLConnection urlConnection) throws InternetObservingStrategyException {
        Preconditions.checkNotNull(urlConnection, "urlConnection");
        try {
            return urlConnection.getResponseCode() == 204;
        }
        catch (IOException ioe) {
            throw new InternetObservingStrategyException("Unable to check internet access", ioe);
        }
    }

    @Override
    Logger logger() {
        return Logger.getLogger(WalledGardenInternetObservingStrategy.class.getSimpleName());
    }

    public static final class Builder
    extends UrlConnectionInternetObservingStrategy.Builder<WalledGardenInternetObservingStrategy, Builder> {
        private static final String DEFAULT_ENDPOINT = "http://google.cn/generate_204";
        private static final int DEFAULT_TIMEOUT_MS = 3000;

        Builder() {
            this.endpoint(DEFAULT_ENDPOINT);
            this.timeout(3000);
        }

        @Override
        @NonNull
        public WalledGardenInternetObservingStrategy build() {
            return new WalledGardenInternetObservingStrategy(this);
        }
    }
}

