/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.network.factory;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.strategy.network.NetworkObservingStrategy;
import greyfox.rxnetwork.internal.strategy.network.NetworkObservingStrategyFactory;
import greyfox.rxnetwork.internal.strategy.network.providers.NetworkObservingStrategyProvider;
import greyfox.rxnetwork.internal.strategy.network.providers.ObservingStrategyProviders;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BuiltInNetworkObservingStrategyFactory
implements NetworkObservingStrategyFactory {
    private final ObservingStrategyProviders<NetworkObservingStrategyProvider> strategyProviders;

    BuiltInNetworkObservingStrategyFactory(@NonNull ObservingStrategyProviders<NetworkObservingStrategyProvider> strategyProviders) {
        this.strategyProviders = Preconditions.checkNotNull(strategyProviders, "strategyProviders");
    }

    public static NetworkObservingStrategyFactory create(@NonNull ObservingStrategyProviders<NetworkObservingStrategyProvider> strategyProviders) {
        return new BuiltInNetworkObservingStrategyFactory(strategyProviders);
    }

    @Override
    @NonNull
    public NetworkObservingStrategy get() {
        for (NetworkObservingStrategyProvider strategyProvider : this.strategyProviders.get()) {
            if (!strategyProvider.canProvide()) continue;
            return strategyProvider.provide();
        }
        throw new NullPointerException("No NetworkObservingStrategy found for API level " + Build.VERSION.SDK_INT + " ( " + Build.VERSION.CODENAME + " )");
    }
}

