/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.network.impl;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkRequest;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.net.RxNetworkInfo;
import greyfox.rxnetwork.internal.strategy.network.impl.Api21BaseNetworkObservingStrategy;
import greyfox.rxnetwork.internal.strategy.network.impl.BaseNetworkObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.util.logging.Logger;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class LollipopNetworkObservingStrategy
extends Api21BaseNetworkObservingStrategy {
    private final ConnectivityManager connectivityManager;
    @Nullable
    private NetworkRequest networkRequest;
    private ConnectivityManager.NetworkCallback networkCallback;

    public LollipopNetworkObservingStrategy(@NonNull Context context) {
        Preconditions.checkNotNull(context, "context");
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    public LollipopNetworkObservingStrategy(@NonNull Context context, @NonNull NetworkRequest networkRequest) {
        this(context);
        this.networkRequest = Preconditions.checkNotNull(networkRequest, "network request");
    }

    @Override
    public Observable<RxNetworkInfo> observe() {
        return Observable.create((ObservableOnSubscribe)new LollipopOnSubscribe()).distinctUntilChanged();
    }

    private void register() {
        NetworkRequest request = this.networkRequest != null ? this.networkRequest : new NetworkRequest.Builder().build();
        this.connectivityManager.registerNetworkCallback(request, this.networkCallback);
    }

    @Override
    void dispose() {
        try {
            this.connectivityManager.unregisterNetworkCallback(this.networkCallback);
        }
        catch (Exception e) {
            this.onError("Could not unregister network callback", e);
        }
    }

    @Override
    Logger logger() {
        return Logger.getLogger(LollipopNetworkObservingStrategy.class.getSimpleName());
    }

    @Override
    ConnectivityManager connectivityManager() {
        return this.connectivityManager;
    }

    private final class LollipopOnSubscribe
    implements ObservableOnSubscribe<RxNetworkInfo> {
        private LollipopOnSubscribe() {
        }

        public void subscribe(ObservableEmitter<RxNetworkInfo> upstream) throws Exception {
            LollipopNetworkObservingStrategy.this.networkCallback = new Api21BaseNetworkObservingStrategy.StrategyNetworkCallback(upstream);
            upstream.setCancellable((Cancellable)new BaseNetworkObservingStrategy.StrategyCancellable());
            LollipopNetworkObservingStrategy.this.register();
        }
    }
}

