/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.network.impl;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkRequest;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.net.RxNetworkInfo;
import greyfox.rxnetwork.internal.strategy.network.impl.Api21BaseNetworkObservingStrategy;
import greyfox.rxnetwork.internal.strategy.network.impl.BaseNetworkObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Action;
import io.reactivex.functions.Cancellable;
import io.reactivex.subjects.PublishSubject;
import java.util.logging.Logger;

@RequiresApi(value=23)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MarshmallowNetworkObservingStrategy
extends Api21BaseNetworkObservingStrategy {
    private static final IntentFilter IDLE_MODE_CHANGED = new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED");
    @NonNull
    private final ConnectivityManager connectivityManager;
    @NonNull
    private final PowerManager powerManager;
    @NonNull
    private final Context context;
    @NonNull
    private final PublishSubject<RxNetworkInfo> networkChange = PublishSubject.create();
    private ConnectivityManager.NetworkCallback networkCallback;
    private BroadcastReceiver idleModeReceiver;
    @Nullable
    private NetworkRequest networkRequest;

    public MarshmallowNetworkObservingStrategy(@NonNull Context context) {
        this.context = Preconditions.checkNotNull(context, "context");
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.powerManager = (PowerManager)context.getSystemService("power");
    }

    public MarshmallowNetworkObservingStrategy(@NonNull Context context, @NonNull NetworkRequest networkRequest) {
        this(context);
        this.networkRequest = Preconditions.checkNotNull(networkRequest, "network request");
    }

    @Override
    public Observable<RxNetworkInfo> observe() {
        Observable.create((ObservableOnSubscribe)new MarshmallowOnSubscribe()).subscribeWith(this.networkChange);
        return this.networkChange.distinctUntilChanged().doOnDispose((Action)new OnDisposeAction());
    }

    @Override
    void dispose() {
        this.unregisterNetworkCallback();
        this.unregisterIdleModeReceiver();
    }

    @Override
    Logger logger() {
        return Logger.getLogger(MarshmallowNetworkObservingStrategy.class.getSimpleName());
    }

    private void unregisterIdleModeReceiver() {
        try {
            this.context.unregisterReceiver(this.idleModeReceiver);
        }
        catch (Exception e) {
            this.onError("Could not unregister idle mode broadcast receiver", e);
        }
    }

    private void unregisterNetworkCallback() {
        try {
            this.connectivityManager.unregisterNetworkCallback(this.networkCallback);
        }
        catch (Exception e) {
            this.onError("Could not unregister network callback", e);
        }
    }

    @Override
    ConnectivityManager connectivityManager() {
        return this.connectivityManager;
    }

    private final class OnDisposeAction
    implements Action {
        private OnDisposeAction() {
        }

        public void run() throws Exception {
            MarshmallowNetworkObservingStrategy.this.dispose();
        }
    }

    private final class MarshmallowOnSubscribe
    implements ObservableOnSubscribe<RxNetworkInfo> {
        private MarshmallowOnSubscribe() {
        }

        public void subscribe(ObservableEmitter<RxNetworkInfo> upstream) throws Exception {
            upstream.setCancellable((Cancellable)new BaseNetworkObservingStrategy.StrategyCancellable());
            this.registerIdleModeReceiver(upstream);
            this.registerNetworkCallback(upstream);
        }

        private void registerIdleModeReceiver(ObservableEmitter<RxNetworkInfo> upstream) {
            MarshmallowNetworkObservingStrategy.this.idleModeReceiver = new DeviceIdleReceiver(upstream);
            MarshmallowNetworkObservingStrategy.this.context.registerReceiver(MarshmallowNetworkObservingStrategy.this.idleModeReceiver, IDLE_MODE_CHANGED);
        }

        private void registerNetworkCallback(ObservableEmitter<RxNetworkInfo> upstream) {
            MarshmallowNetworkObservingStrategy.this.networkCallback = new Api21BaseNetworkObservingStrategy.StrategyNetworkCallback(upstream);
            NetworkRequest request = MarshmallowNetworkObservingStrategy.this.networkRequest != null ? MarshmallowNetworkObservingStrategy.this.networkRequest : new NetworkRequest.Builder().build();
            MarshmallowNetworkObservingStrategy.this.connectivityManager.registerNetworkCallback(request, MarshmallowNetworkObservingStrategy.this.networkCallback);
        }
    }

    @RequiresApi(value=23)
    private final class DeviceIdleReceiver
    extends BroadcastReceiver {
        private final ObservableEmitter<RxNetworkInfo> upstream;

        DeviceIdleReceiver(ObservableEmitter<RxNetworkInfo> upstream) {
            this.upstream = Preconditions.checkNotNull(upstream, "upstream");
        }

        public void onReceive(Context context, Intent intent) {
            if (this.isDeviceInIdleMode(context)) {
                this.upstream.onNext((Object)RxNetworkInfo.create());
            } else {
                this.upstream.onNext((Object)RxNetworkInfo.create(context));
            }
        }

        private boolean isDeviceInIdleMode(Context context) {
            String packageName = context.getPackageName();
            return MarshmallowNetworkObservingStrategy.this.powerManager.isDeviceIdleMode() && !MarshmallowNetworkObservingStrategy.this.powerManager.isIgnoringBatteryOptimizations(packageName);
        }
    }
}

