/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.network.impl;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.net.RxNetworkInfo;
import greyfox.rxnetwork.internal.strategy.network.impl.BaseNetworkObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.util.logging.Logger;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PreLollipopNetworkObservingStrategy
extends BaseNetworkObservingStrategy {
    private static final IntentFilter CONNECTIVITY_INTENT_FILTER = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    @NonNull
    private final Context context;
    private BroadcastReceiver broadcastReceiver;

    public PreLollipopNetworkObservingStrategy(@NonNull Context context) {
        this.context = Preconditions.checkNotNull(context, "context");
    }

    @Override
    public Observable<RxNetworkInfo> observe() {
        return Observable.create((ObservableOnSubscribe)new PreLollipopOnSubscribe()).distinctUntilChanged();
    }

    private void register() {
        this.context.registerReceiver(this.broadcastReceiver, CONNECTIVITY_INTENT_FILTER);
    }

    @Override
    void dispose() {
        try {
            this.context.unregisterReceiver(this.broadcastReceiver);
        }
        catch (Exception exc) {
            this.onError("Could not unregister broadcast receiver", exc);
        }
    }

    @Override
    Logger logger() {
        return Logger.getLogger(PreLollipopNetworkObservingStrategy.class.getSimpleName());
    }

    private final class PreLollipopOnSubscribe
    implements ObservableOnSubscribe<RxNetworkInfo> {
        private PreLollipopOnSubscribe() {
        }

        public void subscribe(final ObservableEmitter<RxNetworkInfo> emitter) throws Exception {
            PreLollipopNetworkObservingStrategy.this.broadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    emitter.onNext((Object)RxNetworkInfo.create(context));
                }
            };
            emitter.setCancellable((Cancellable)new BaseNetworkObservingStrategy.StrategyCancellable());
            PreLollipopNetworkObservingStrategy.this.register();
        }
    }
}

