/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.network.predicate;

import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import greyfox.rxnetwork.internal.net.RxNetworkInfo;
import io.reactivex.functions.Predicate;
import java.util.Arrays;

public final class RxNetworkInfoPredicate {
    @VisibleForTesting
    RxNetworkInfoPredicate() {
        throw new AssertionError((Object)"No instances.");
    }

    @RequiresApi(value=21)
    public static final class Capabilities {
        @VisibleForTesting
        Capabilities() {
            throw new AssertionError((Object)"No instances");
        }

        public static Predicate<RxNetworkInfo> hasTransportType(final int ... transportTypes) {
            return new Predicate<RxNetworkInfo>(){

                public boolean test(RxNetworkInfo networkInfo) throws Exception {
                    NetworkCapabilities networkCapabilities = networkInfo.getNetworkCapabilities();
                    if (networkCapabilities != null) {
                        int[] nArray = transportTypes;
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            Integer transportType = nArray[i];
                            if (!networkCapabilities.hasTransport(transportType.intValue())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
        }

        public static Predicate<RxNetworkInfo> isSatisfiedByUpBandwidth(final int upBandwidth) {
            return new Predicate<RxNetworkInfo>(){

                public boolean test(RxNetworkInfo networkInfo) throws Exception {
                    NetworkCapabilities networkCapabilities = networkInfo.getNetworkCapabilities();
                    return networkCapabilities != null && networkCapabilities.getLinkUpstreamBandwidthKbps() >= upBandwidth;
                }
            };
        }

        public static Predicate<RxNetworkInfo> isSatisfiedByDownBandwidth(final int downBandwidth) {
            return new Predicate<RxNetworkInfo>(){

                public boolean test(RxNetworkInfo networkInfo) throws Exception {
                    NetworkCapabilities networkCapabilities = networkInfo.getNetworkCapabilities();
                    return networkCapabilities != null && networkCapabilities.getLinkDownstreamBandwidthKbps() >= downBandwidth;
                }
            };
        }
    }

    public static final class Type {
        public static final Predicate<RxNetworkInfo> IS_MOBILE = Type.isOfTypeMobile();
        public static final Predicate<RxNetworkInfo> IS_WIFI = Type.isOfTypeWifi();

        @VisibleForTesting
        Type() {
            throw new AssertionError((Object)"No instances.");
        }

        public static Predicate<RxNetworkInfo> hasType(final int ... networkTypes) {
            return new Predicate<RxNetworkInfo>(){

                public boolean test(RxNetworkInfo networkInfo) throws Exception {
                    for (int type : networkTypes) {
                        if (networkInfo.getType() != type) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private static Predicate<RxNetworkInfo> isOfTypeMobile() {
            return new Predicate<RxNetworkInfo>(){

                public boolean test(RxNetworkInfo networkInfo) throws Exception {
                    return networkInfo.getType() == 0;
                }
            };
        }

        private static Predicate<RxNetworkInfo> isOfTypeWifi() {
            return new Predicate<RxNetworkInfo>(){

                public boolean test(RxNetworkInfo networkInfo) throws Exception {
                    return networkInfo.getType() == 1;
                }
            };
        }
    }

    public static final class State {
        @VisibleForTesting
        State() {
            throw new AssertionError((Object)"No instances.");
        }

        public static Predicate<RxNetworkInfo> hasState(final NetworkInfo.State ... networkStates) {
            return new Predicate<RxNetworkInfo>(){

                public boolean test(RxNetworkInfo networkInfo) throws Exception {
                    return Arrays.asList(networkStates).contains(networkInfo.getState());
                }
            };
        }
    }
}

