/*
 * Decompiled with CFR 0.152.
 */
package greyfox.rxnetwork.internal.strategy.network.providers;

import android.content.Context;
import android.net.NetworkRequest;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import greyfox.rxnetwork.common.base.Preconditions;
import greyfox.rxnetwork.internal.strategy.network.providers.LollipopNetworkObservingStrategyProvider;
import greyfox.rxnetwork.internal.strategy.network.providers.MarshmallowNetworkObservingStrategyProvider;
import greyfox.rxnetwork.internal.strategy.network.providers.NetworkObservingStrategyProvider;
import greyfox.rxnetwork.internal.strategy.network.providers.ObservingStrategyProviders;
import greyfox.rxnetwork.internal.strategy.network.providers.PreLollipopNetworkObservingStrategyProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BuiltInNetworkObservingStrategyProviders
implements ObservingStrategyProviders<NetworkObservingStrategyProvider> {
    private final Context context;
    private NetworkRequest networkRequest;

    @VisibleForTesting
    BuiltInNetworkObservingStrategyProviders() {
        throw new AssertionError((Object)"No instances.");
    }

    public BuiltInNetworkObservingStrategyProviders(@NonNull Context context) {
        this.context = Preconditions.checkNotNull(context, "context == null");
    }

    public BuiltInNetworkObservingStrategyProviders(@NonNull Context context, @NonNull NetworkRequest networkRequest) {
        this(context);
        this.networkRequest = Preconditions.checkNotNull(networkRequest, "networkRequest");
    }

    @Override
    public Collection<NetworkObservingStrategyProvider> get() {
        HashSet<NetworkObservingStrategyProvider> collection = new HashSet<NetworkObservingStrategyProvider>();
        collection.add(new PreLollipopNetworkObservingStrategyProvider(this.context));
        collection.add(this.networkRequest == null ? new LollipopNetworkObservingStrategyProvider(this.context) : new LollipopNetworkObservingStrategyProvider(this.context, this.networkRequest));
        collection.add(this.networkRequest == null ? new MarshmallowNetworkObservingStrategyProvider(this.context) : new MarshmallowNetworkObservingStrategyProvider(this.context, this.networkRequest));
        return Collections.unmodifiableCollection(collection);
    }
}

