/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.api;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.constructor.BaseConstructor;
import org.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u001bB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/snakeyaml/engine/v2/api/Load;", "", "settings", "Lorg/snakeyaml/engine/v2/api/LoadSettings;", "constructor", "Lorg/snakeyaml/engine/v2/constructor/BaseConstructor;", "(Lorg/snakeyaml/engine/v2/api/LoadSettings;Lorg/snakeyaml/engine/v2/constructor/BaseConstructor;)V", "createComposer", "Lorg/snakeyaml/engine/v2/composer/Composer;", "yamlStream", "Ljava/io/InputStream;", "yamlReader", "Ljava/io/Reader;", "yaml", "", "streamReader", "Lorg/snakeyaml/engine/v2/scanner/StreamReader;", "loadAll", "", "composer", "loadAllFromInputStream", "loadAllFromReader", "loadAllFromString", "loadFromInputStream", "loadFromReader", "loadFromString", "loadOne", "YamlIterator", "snakeyaml-engine-kmp"})
public final class Load {
    @NotNull
    private final LoadSettings settings;
    @NotNull
    private final BaseConstructor constructor;

    @JvmOverloads
    public Load(@NotNull LoadSettings settings, @NotNull BaseConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.settings = settings;
        this.constructor = constructor;
    }

    public /* synthetic */ Load(LoadSettings loadSettings, BaseConstructor baseConstructor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            baseConstructor = new StandardConstructor(loadSettings);
        }
        this(loadSettings, baseConstructor);
    }

    private final Composer createComposer(StreamReader streamReader) {
        return new Composer(this.settings, new ParserImpl(this.settings, streamReader));
    }

    private final Composer createComposer(InputStream yamlStream) {
        return this.createComposer(new StreamReader(this.settings, new YamlUnicodeReader(Okio.source((InputStream)yamlStream))));
    }

    private final Composer createComposer(String yaml) {
        return this.createComposer(new StreamReader(this.settings, yaml));
    }

    private final Composer createComposer(Reader yamlReader) {
        return this.createComposer(new StreamReader(this.settings, TextStreamsKt.readText((Reader)yamlReader)));
    }

    private final Object loadOne(Composer composer) {
        Node nodeOptional = composer.getSingleNode();
        return this.constructor.constructSingleDocument(nodeOptional);
    }

    @Nullable
    public final Object loadFromInputStream(@NotNull InputStream yamlStream) {
        Intrinsics.checkNotNullParameter((Object)yamlStream, (String)"yamlStream");
        return this.loadOne(this.createComposer(yamlStream));
    }

    @Nullable
    public final Object loadFromReader(@NotNull Reader yamlReader) {
        Intrinsics.checkNotNullParameter((Object)yamlReader, (String)"yamlReader");
        return this.loadOne(this.createComposer(yamlReader));
    }

    @Nullable
    public final Object loadFromString(@NotNull String yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return this.loadOne(this.createComposer(yaml));
    }

    private final Iterable<Object> loadAll(Composer composer) {
        return new Iterable<Object>(composer, this){
            final /* synthetic */ Composer $composer$inlined;
            final /* synthetic */ Load this$0;
            {
                this.$composer$inlined = composer;
                this.this$0 = load;
            }

            @NotNull
            public Iterator<Object> iterator() {
                boolean bl = false;
                return new YamlIterator(this.$composer$inlined, Load.access$getConstructor$p(this.this$0));
            }
        };
    }

    @NotNull
    public final Iterable<Object> loadAllFromInputStream(@NotNull InputStream yamlStream) {
        Intrinsics.checkNotNullParameter((Object)yamlStream, (String)"yamlStream");
        Composer composer = this.createComposer(new StreamReader(this.settings, new YamlUnicodeReader(Okio.source((InputStream)yamlStream))));
        return this.loadAll(composer);
    }

    @NotNull
    public final Iterable<Object> loadAllFromReader(@NotNull Reader yamlReader) {
        Intrinsics.checkNotNullParameter((Object)yamlReader, (String)"yamlReader");
        Composer composer = this.createComposer(new StreamReader(this.settings, TextStreamsKt.readText((Reader)yamlReader)));
        return this.loadAll(composer);
    }

    @NotNull
    public final Iterable<Object> loadAllFromString(@NotNull String yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        Composer composer = this.createComposer(new StreamReader(this.settings, yaml));
        return this.loadAll(composer);
    }

    @JvmOverloads
    public Load(@NotNull LoadSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(settings, null, 2, null);
    }

    public static final /* synthetic */ BaseConstructor access$getConstructor$p(Load $this) {
        return $this.constructor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\tH\u0096\u0002J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/snakeyaml/engine/v2/api/Load$YamlIterator;", "", "", "composer", "Lorg/snakeyaml/engine/v2/composer/Composer;", "constructor", "Lorg/snakeyaml/engine/v2/constructor/BaseConstructor;", "(Lorg/snakeyaml/engine/v2/composer/Composer;Lorg/snakeyaml/engine/v2/constructor/BaseConstructor;)V", "composerInitiated", "", "hasNext", "next", "remove", "", "snakeyaml-engine-kmp"})
    private static final class YamlIterator
    implements Iterator<Object>,
    KMutableIterator {
        @NotNull
        private final Composer composer;
        @NotNull
        private final BaseConstructor constructor;
        private boolean composerInitiated;

        public YamlIterator(@NotNull Composer composer, @NotNull BaseConstructor constructor) {
            Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            this.composer = composer;
            this.constructor = constructor;
        }

        @Override
        public boolean hasNext() {
            this.composerInitiated = true;
            return this.composer.hasNext();
        }

        @Override
        @Nullable
        public Object next() {
            if (!this.composerInitiated) {
                this.hasNext();
            }
            Node node = this.composer.next();
            return this.constructor.constructSingleDocument(node);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is not supported.");
        }
    }
}

