/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.api.lowlevel;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.api.lowlevel.ComposeString;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\rJ\u0010\u0010\u0005\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/snakeyaml/engine/v2/api/lowlevel/Compose;", "", "settings", "Lorg/snakeyaml/engine/v2/api/LoadSettings;", "(Lorg/snakeyaml/engine/v2/api/LoadSettings;)V", "composeString", "Lorg/snakeyaml/engine/v2/api/lowlevel/ComposeString;", "composeAllFromInputStream", "", "Lorg/snakeyaml/engine/v2/nodes/Node;", "yaml", "Ljava/io/InputStream;", "composeAllFromReader", "Ljava/io/Reader;", "composeAllFromString", "", "composeInputStream", "composeReader", "snakeyaml-engine-kmp"})
public final class Compose {
    @NotNull
    private final LoadSettings settings;
    @NotNull
    private final ComposeString composeString;

    public Compose(@NotNull LoadSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.composeString = new ComposeString(this.settings);
    }

    @Nullable
    public final Node composeReader(@NotNull Reader yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return new Composer(this.settings, new ParserImpl(this.settings, new StreamReader(this.settings, TextStreamsKt.readText((Reader)yaml)))).getSingleNode();
    }

    @Nullable
    public final Node composeInputStream(@NotNull InputStream yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return new Composer(this.settings, new ParserImpl(this.settings, new StreamReader(this.settings, new YamlUnicodeReader(Okio.source((InputStream)yaml))))).getSingleNode();
    }

    @Nullable
    public final Node composeString(@NotNull String yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return this.composeString.composeString(yaml);
    }

    @NotNull
    public final Iterable<Node> composeAllFromReader(@NotNull Reader yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return SequencesKt.asIterable((Sequence)SequencesKt.asSequence((Iterator)new Composer(this.settings, new ParserImpl(this.settings, new StreamReader(this.settings, TextStreamsKt.readText((Reader)yaml))))));
    }

    @NotNull
    public final Iterable<Node> composeAllFromInputStream(@NotNull InputStream yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return SequencesKt.asIterable((Sequence)SequencesKt.asSequence((Iterator)new Composer(this.settings, new ParserImpl(this.settings, new StreamReader(this.settings, new YamlUnicodeReader(Okio.source((InputStream)yaml)))))));
    }

    @NotNull
    public final Iterable<Node> composeAllFromString(@NotNull String yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return this.composeString.composeAllFromString(yaml);
    }
}

