/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.comments;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.comments.CommentLine;
import org.snakeyaml.engine.v2.comments.CommentType;
import org.snakeyaml.engine.v2.comments.EventQueue;
import org.snakeyaml.engine.v2.events.CommentEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.parser.Parser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B)\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0002\u0012\u0006\u0010\b\u001a\u00020\f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0012\u001a\u00020\u0000J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0014\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/snakeyaml/engine/v2/comments/CommentEventsCollector;", "", "parser", "Lorg/snakeyaml/engine/v2/parser/Parser;", "expectedCommentTypes", "", "Lorg/snakeyaml/engine/v2/comments/CommentType;", "(Lorg/snakeyaml/engine/v2/parser/Parser;[Lorg/snakeyaml/engine/v2/comments/CommentType;)V", "eventSource", "Lkotlin/collections/ArrayDeque;", "Lorg/snakeyaml/engine/v2/events/Event;", "(Lkotlin/collections/ArrayDeque;[Lorg/snakeyaml/engine/v2/comments/CommentType;)V", "Lorg/snakeyaml/engine/v2/comments/EventQueue;", "(Lorg/snakeyaml/engine/v2/comments/EventQueue;[Lorg/snakeyaml/engine/v2/comments/CommentType;)V", "commentLineList", "", "Lorg/snakeyaml/engine/v2/comments/CommentLine;", "[Lorg/snakeyaml/engine/v2/comments/CommentType;", "collectEvents", "event", "collectEventsAndPoll", "consume", "", "isEmpty", "", "isEventExpected", "snakeyaml-engine-kmp"})
public final class CommentEventsCollector {
    @NotNull
    private final EventQueue eventSource;
    @NotNull
    private final CommentType[] expectedCommentTypes;
    @NotNull
    private final List<CommentLine> commentLineList;

    private CommentEventsCollector(EventQueue eventSource, CommentType[] expectedCommentTypes) {
        this.eventSource = eventSource;
        this.expectedCommentTypes = expectedCommentTypes;
        this.commentLineList = new ArrayList();
    }

    public CommentEventsCollector(@NotNull Parser parser, CommentType ... expectedCommentTypes) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)expectedCommentTypes, (String)"expectedCommentTypes");
        this(new EventQueue(parser), expectedCommentTypes);
    }

    public CommentEventsCollector(@NotNull ArrayDeque<Event> eventSource, CommentType ... expectedCommentTypes) {
        Intrinsics.checkNotNullParameter(eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter((Object)expectedCommentTypes, (String)"expectedCommentTypes");
        this(new EventQueue(eventSource), expectedCommentTypes);
    }

    private final boolean isEventExpected(Event event) {
        return event != null && event.getEventId() == Event.ID.Comment && event instanceof CommentEvent && ArraysKt.contains((Object[])this.expectedCommentTypes, (Object)((Object)((CommentEvent)event).getCommentType()));
    }

    @NotNull
    public final CommentEventsCollector collectEvents() {
        this.collectEvents(null);
        return this;
    }

    @Nullable
    public final Event collectEvents(@Nullable Event event) {
        if (event != null) {
            if (this.isEventExpected(event)) {
                this.commentLineList.add(new CommentLine((CommentEvent)event));
            } else {
                return event;
            }
        }
        while (this.isEventExpected(this.eventSource.peek())) {
            Event e = this.eventSource.poll();
            Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.CommentEvent");
            this.commentLineList.add(new CommentLine((CommentEvent)e));
        }
        return null;
    }

    @NotNull
    public final Event collectEventsAndPoll(@Nullable Event event) {
        Event nextEvent = this.collectEvents(event);
        Event event2 = nextEvent;
        if (event2 == null) {
            event2 = this.eventSource.poll();
        }
        return event2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<CommentLine> consume() {
        List list;
        try {
            list = CollectionsKt.toList((Iterable)this.commentLineList);
        }
        finally {
            this.commentLineList.clear();
        }
        return list;
    }

    public final boolean isEmpty() {
        return this.commentLineList.isEmpty();
    }
}

