/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.constructor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.exceptions.ConstructorException;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\"\n\u0002\b\u000f\b&\u0018\u00002\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0007H\u0004J \u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0004J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00152\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0007H\u0004J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u001dH\u0004J\u0018\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\u0006\u0010\u0012\u001a\u00020 H\u0004J \u0010!\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010#H\u0004J\u0018\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010%2\u0006\u0010\u0012\u001a\u00020\u0015H\u0004J \u0010&\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00152\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fH\u0014J\u0012\u0010(\u001a\u0004\u0018\u00010\u00012\b\u0010)\u001a\u0004\u0018\u00010\u0007J\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\u0006\u0010\u0012\u001a\u00020 H\u0004J \u0010+\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0004J\u0018\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010%2\u0006\u0010\u0012\u001a\u00020\u0015H\u0004J\b\u0010-\u001a\u00020\u0017H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0014J4\u0010/\u001a\u00020\u00172\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\b\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u00102\u001a\u00020\u00172\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0002R\u001e\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\b\u001a4\u00120\u0012.\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/snakeyaml/engine/v2/constructor/BaseConstructor;", "", "settings", "Lorg/snakeyaml/engine/v2/api/LoadSettings;", "(Lorg/snakeyaml/engine/v2/api/LoadSettings;)V", "constructedObjects", "", "Lorg/snakeyaml/engine/v2/nodes/Node;", "maps2fill", "", "Lorg/snakeyaml/engine/v2/constructor/BaseConstructor$RecursiveTuple;", "recursiveObjects", "", "sets2fill", "tagConstructors", "Lorg/snakeyaml/engine/v2/nodes/Tag;", "Lorg/snakeyaml/engine/v2/api/ConstructNode;", "construct", "node", "constructMapping", "", "Lorg/snakeyaml/engine/v2/nodes/MappingNode;", "constructMapping2ndStep", "", "mapping", "constructObject", "constructObjectNoCheck", "constructScalar", "", "Lorg/snakeyaml/engine/v2/nodes/ScalarNode;", "constructSequence", "", "Lorg/snakeyaml/engine/v2/nodes/SequenceNode;", "constructSequenceStep2", "collection", "", "constructSet", "", "constructSet2ndStep", "set", "constructSingleDocument", "optionalNode", "createEmptyListForNode", "createEmptyMapFor", "createEmptySetForNode", "fillRecursive", "findConstructorFor", "postponeMapFilling", "key", "value", "postponeSetFilling", "RecursiveTuple", "snakeyaml-engine-kmp"})
public abstract class BaseConstructor {
    @JvmField
    @NotNull
    protected final LoadSettings settings;
    @JvmField
    @NotNull
    protected final Map<Tag, ConstructNode> tagConstructors;
    @JvmField
    @NotNull
    protected final Map<Node, Object> constructedObjects;
    @NotNull
    private final Set<Node> recursiveObjects;
    @NotNull
    private final List<RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>> maps2fill;
    @NotNull
    private final List<RecursiveTuple<Set<Object>, Object>> sets2fill;

    public BaseConstructor(@NotNull LoadSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.tagConstructors = new LinkedHashMap();
        this.constructedObjects = new LinkedHashMap();
        this.recursiveObjects = new LinkedHashSet();
        this.maps2fill = new ArrayList();
        this.sets2fill = new ArrayList();
    }

    @Nullable
    public final Object constructSingleDocument(@Nullable Node optionalNode) {
        Object object;
        if (optionalNode != null && !Intrinsics.areEqual((Object)Tag.NULL, (Object)optionalNode.getTag())) {
            object = this.construct(optionalNode);
        } else {
            ConstructNode constructNode = this.tagConstructors.get(Tag.NULL);
            Intrinsics.checkNotNull((Object)constructNode);
            ConstructNode construct = constructNode;
            object = construct.construct(optionalNode);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    protected final Object construct(@NotNull Node node) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        try {
            Object data = this.constructObject(node);
            this.fillRecursive();
        }
        catch (YamlEngineException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new YamlEngineException(e);
        }
        finally {
            this.constructedObjects.clear();
            this.recursiveObjects.clear();
        }
        return var2_2;
    }

    private final void fillRecursive() {
        if (!((Collection)this.maps2fill).isEmpty()) {
            for (RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>> recursiveTuple : this.maps2fill) {
                RecursiveTuple<Object, Object> recursiveTuple2 = recursiveTuple.getValue2();
                Object value1 = recursiveTuple2.component1();
                Object value2 = recursiveTuple2.component2();
                recursiveTuple.getValue1().put(value1, value2);
            }
            this.maps2fill.clear();
        }
        if (!((Collection)this.sets2fill).isEmpty()) {
            for (RecursiveTuple<Object, Object> recursiveTuple : this.sets2fill) {
                ((Set)recursiveTuple.getValue1()).add(recursiveTuple.getValue2());
            }
            this.sets2fill.clear();
        }
    }

    @Nullable
    protected final Object constructObject(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = this.constructedObjects.get(node);
        if (object == null) {
            object = this.constructObjectNoCheck(node);
        }
        return object;
    }

    private final Object constructObjectNoCheck(Node node) {
        if (this.recursiveObjects.contains(node)) {
            throw new ConstructorException(null, null, "found unconstructable recursive node", node.getStartMark(), null, 16, null);
        }
        this.recursiveObjects.add(node);
        ConstructNode constructNode = this.findConstructorFor(node);
        if (constructNode == null) {
            throw new ConstructorException(null, null, "could not determine a constructor for the tag " + node.getTag(), node.getStartMark(), null, 16, null);
        }
        ConstructNode constructor = constructNode;
        Object object = this.constructedObjects.get(node);
        if (object == null) {
            object = constructor.construct(node);
        }
        Object data = object;
        this.constructedObjects.put(node, data);
        this.recursiveObjects.remove(node);
        if (node.isRecursive()) {
            Object object2 = data;
            Intrinsics.checkNotNull((Object)object2);
            constructor.constructRecursive(node, object2);
        }
        return data;
    }

    @Nullable
    protected ConstructNode findConstructorFor(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Tag tag = node.getTag();
        ConstructNode constructNode = this.settings.tagConstructors.get(tag);
        if (constructNode == null) {
            constructNode = this.tagConstructors.get(tag);
        }
        return constructNode;
    }

    @NotNull
    protected final String constructScalar(@NotNull ScalarNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getValue();
    }

    @NotNull
    protected final List<Object> createEmptyListForNode(@NotNull SequenceNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.settings.defaultList.invoke(node.getValue().size());
    }

    @NotNull
    protected final Set<Object> createEmptySetForNode(@NotNull MappingNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.settings.defaultSet.invoke(node.getValue().size());
    }

    @NotNull
    protected final Map<Object, Object> createEmptyMapFor(@NotNull MappingNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.settings.defaultMap.invoke(node.getValue().size());
    }

    @NotNull
    protected final List<Object> constructSequence(@NotNull SequenceNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<Object> result = this.settings.defaultList.invoke(node.getValue().size());
        this.constructSequenceStep2(node, (Collection<Object>)result);
        return result;
    }

    protected final void constructSequenceStep2(@NotNull SequenceNode node, @NotNull Collection<Object> collection) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        for (Node child : node.getValue()) {
            collection.add(this.constructObject(child));
        }
    }

    @NotNull
    protected final Set<Object> constructSet(@NotNull MappingNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Set<Object> set = this.settings.defaultSet.invoke(node.getValue().size());
        this.constructSet2ndStep(node, set);
        return set;
    }

    @NotNull
    protected final Map<Object, Object> constructMapping(@NotNull MappingNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Map<Object, Object> mapping = this.settings.defaultMap.invoke(node.getValue().size());
        this.constructMapping2ndStep(node, mapping);
        return mapping;
    }

    protected void constructMapping2ndStep(@NotNull MappingNode node, @NotNull Map<Object, Object> mapping) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        List<NodeTuple> nodeValue = node.getValue();
        for (NodeTuple tuple : nodeValue) {
            Node keyNode = tuple.getKeyNode();
            Node valueNode = tuple.getValueNode();
            Object key = this.constructObject(keyNode);
            if (key != null) {
                try {
                    key.hashCode();
                }
                catch (Exception e) {
                    throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), e);
                }
            }
            Object value = this.constructObject(valueNode);
            if (keyNode.isRecursive()) {
                if (this.settings.allowRecursiveKeys) {
                    this.postponeMapFilling(mapping, key, value);
                    continue;
                }
                throw new YamlEngineException("Recursive key for mapping is detected but it is not configured to be allowed.");
            }
            mapping.put(key, value);
        }
    }

    private final void postponeMapFilling(Map<Object, Object> mapping, Object key, Object value) {
        this.maps2fill.add(0, new RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>(mapping, new RecursiveTuple<Object, Object>(key, value)));
    }

    protected void constructSet2ndStep(@NotNull MappingNode node, @NotNull Set<Object> set) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        List<NodeTuple> nodeValue = node.getValue();
        for (NodeTuple tuple : nodeValue) {
            Node keyNode = tuple.getKeyNode();
            Object key = this.constructObject(keyNode);
            if (key != null) {
                try {
                    key.hashCode();
                }
                catch (Exception e) {
                    throw new ConstructorException("while constructing a Set", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), e);
                }
            }
            if (keyNode.isRecursive()) {
                if (this.settings.allowRecursiveKeys) {
                    this.postponeSetFilling(set, key);
                    continue;
                }
                throw new YamlEngineException("Recursive key for mapping is detected but it is not configured to be allowed.");
            }
            set.add(key);
        }
    }

    private final void postponeSetFilling(Set<Object> set, Object key) {
        this.sets2fill.add(0, new RecursiveTuple<Set<Object>, Object>(set, key));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ.\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/snakeyaml/engine/v2/constructor/BaseConstructor$RecursiveTuple;", "T", "K", "", "value1", "value2", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getValue1", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue2", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/snakeyaml/engine/v2/constructor/BaseConstructor$RecursiveTuple;", "equals", "", "other", "hashCode", "", "toString", "", "snakeyaml-engine-kmp"})
    private static final class RecursiveTuple<T, K> {
        private final T value1;
        private final K value2;

        public RecursiveTuple(T value1, K value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public final T getValue1() {
            return this.value1;
        }

        public final K getValue2() {
            return this.value2;
        }

        public final T component1() {
            return this.value1;
        }

        public final K component2() {
            return this.value2;
        }

        @NotNull
        public final RecursiveTuple<T, K> copy(T value1, K value2) {
            return new RecursiveTuple<T, K>(value1, value2);
        }

        public static /* synthetic */ RecursiveTuple copy$default(RecursiveTuple recursiveTuple, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = recursiveTuple.value1;
            }
            if ((n & 2) != 0) {
                object2 = recursiveTuple.value2;
            }
            return recursiveTuple.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "RecursiveTuple(value1=" + this.value1 + ", value2=" + this.value2 + ")";
        }

        public int hashCode() {
            int result = this.value1 == null ? 0 : this.value1.hashCode();
            result = result * 31 + (this.value2 == null ? 0 : this.value2.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecursiveTuple)) {
                return false;
            }
            RecursiveTuple recursiveTuple = (RecursiveTuple)other;
            if (!Intrinsics.areEqual(this.value1, recursiveTuple.value1)) {
                return false;
            }
            return Intrinsics.areEqual(this.value2, recursiveTuple.value2);
        }
    }
}

