/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.exceptions;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.snakeyaml.engine.internal.utils.CharSequenceExtensionsKt;
import org.snakeyaml.engine.v2.common.CharConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0005H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/snakeyaml/engine/v2/exceptions/Mark;", "", "name", "", "index", "", "line", "column", "str", "", "pointer", "(Ljava/lang/String;IIILjava/lang/CharSequence;I)V", "buffer", "", "(Ljava/lang/String;III[II)V", "getBuffer", "()[I", "getColumn", "()I", "getIndex", "getLine", "getName", "()Ljava/lang/String;", "getPointer", "createSnippet", "indent", "maxLength", "isLineBreak", "", "c", "toString", "snakeyaml-engine-kmp"})
public final class Mark {
    @NotNull
    private final String name;
    private final int index;
    private final int line;
    private final int column;
    @NotNull
    private final int[] buffer;
    private final int pointer;

    public Mark(@NotNull String name, int index, int line, int column, @NotNull int[] buffer, int pointer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.name = name;
        this.index = index;
        this.line = line;
        this.column = column;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    @NotNull
    public final int[] getBuffer() {
        return this.buffer;
    }

    public final int getPointer() {
        return this.pointer;
    }

    public Mark(@NotNull String name, int index, int line, int column, @NotNull CharSequence str, int pointer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(name, index, line, column, CharSequenceExtensionsKt.toCodePoints(str), pointer);
    }

    private final boolean isLineBreak(int c) {
        return CharConstants.NULL_OR_LINEBR.has(c);
    }

    @JvmOverloads
    @NotNull
    public final String createSnippet(int indent, int maxLength) {
        int i;
        int end;
        int start;
        float half = (float)maxLength / 2.0f - 1.0f;
        String head = "";
        for (start = this.pointer; start > 0 && !this.isLineBreak(this.buffer[start - 1]); --start) {
            if (!((float)(this.pointer - start) > half)) continue;
            head = " ... ";
            start += 5;
            break;
        }
        String tail = "";
        for (end = this.pointer; end < this.buffer.length && !this.isLineBreak(this.buffer[end]); ++end) {
            if (!((float)(end - this.pointer) > half)) continue;
            tail = " ... ";
            end -= 5;
            break;
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            result.append(" ");
        }
        result.append(head);
        int n = end;
        for (i = start; i < n; ++i) {
            result.appendCodePoint(this.buffer[i]);
        }
        result.append(tail);
        result.append("\n");
        n = indent + this.pointer - start + head.length();
        for (i = 0; i < n; ++i) {
            result.append(" ");
        }
        result.append("^");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String createSnippet$default(Mark mark, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 4;
        }
        if ((n3 & 2) != 0) {
            n2 = 75;
        }
        return mark.createSnippet(n, n2);
    }

    @NotNull
    public String toString() {
        String snippet = Mark.createSnippet$default(this, 0, 0, 3, null);
        return StringsKt.trimMargin$default((String)("\n            | in " + this.name + ", line " + (this.line + 1) + ", column " + (this.column + 1) + ":\n            |" + snippet + "\n        "), null, (int)1, null);
    }

    @JvmOverloads
    @NotNull
    public final String createSnippet(int indent) {
        return Mark.createSnippet$default(this, indent, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String createSnippet() {
        return Mark.createSnippet$default(this, 0, 0, 3, null);
    }
}

