/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.scanner;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.internal.utils.CharSequenceExtensionsKt;
import org.snakeyaml.engine.internal.utils.Character;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.CharConstants;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.ReaderException;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u001d\u001a\u00020\u00142\b\b\u0002\u0010\u001e\u001a\u00020\fH\u0002J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\fH\u0007J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0002J\u0006\u0010%\u001a\u00020\fJ\u000e\u0010%\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\fJ\u000e\u0010'\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\fJ\u0006\u0010(\u001a\u00020 J\b\u0010)\u001a\u00020 H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/snakeyaml/engine/v2/scanner/StreamReader;", "", "loadSettings", "Lorg/snakeyaml/engine/v2/api/LoadSettings;", "stream", "", "(Lorg/snakeyaml/engine/v2/api/LoadSettings;Ljava/lang/String;)V", "Lokio/Source;", "(Lorg/snakeyaml/engine/v2/api/LoadSettings;Lokio/Source;)V", "codePointsWindow", "", "<set-?>", "", "column", "getColumn", "()I", "dataLength", "documentIndex", "getDocumentIndex", "eof", "", "index", "getIndex", "line", "getLine", "name", "pointer", "Lokio/BufferedSource;", "useMarks", "ensureEnoughData", "size", "forward", "", "length", "getMark", "Lorg/snakeyaml/engine/v2/exceptions/Mark;", "moveIndices", "peek", "prefix", "prefixForward", "resetDocumentIndex", "update", "Companion", "snakeyaml-engine-kmp"})
public final class StreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource stream;
    @NotNull
    private final String name;
    private final boolean useMarks;
    @NotNull
    private int[] codePointsWindow;
    private int dataLength;
    private int pointer;
    private boolean eof;
    private int index;
    private int documentIndex;
    private int line;
    private int column;

    public StreamReader(@NotNull LoadSettings loadSettings, @NotNull Source stream) {
        Intrinsics.checkNotNullParameter((Object)loadSettings, (String)"loadSettings");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream instanceof BufferedSource ? (BufferedSource)stream : Okio.buffer((Source)stream);
        this.name = loadSettings.label;
        this.useMarks = loadSettings.useMarks;
        this.codePointsWindow = new int[0];
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getDocumentIndex() {
        return this.documentIndex;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public StreamReader(@NotNull LoadSettings loadSettings, @NotNull String stream) {
        Intrinsics.checkNotNullParameter((Object)loadSettings, (String)"loadSettings");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this(loadSettings, (Source)new Buffer().write(ByteString.Companion.encodeUtf8(stream)));
    }

    @Nullable
    public final Mark getMark() {
        if (!this.useMarks) {
            return null;
        }
        return new Mark(this.name, this.index, this.line, this.column, this.codePointsWindow, this.pointer);
    }

    @JvmOverloads
    public final void forward(int length) {
        for (int i = 0; i < length; ++i) {
            int it = i;
            boolean bl = false;
            if (!StreamReader.ensureEnoughData$default(this, 0, 1, null)) continue;
            int n = this.pointer;
            this.pointer = n + 1;
            int c = this.codePointsWindow[n];
            this.moveIndices(1);
            if (CharConstants.LINEBR.has(c) || c == 13 && StreamReader.ensureEnoughData$default(this, 0, 1, null) && this.codePointsWindow[this.pointer] != 10) {
                n = this.line;
                this.line = n + 1;
                this.column = 0;
                continue;
            }
            if (c == 65279) continue;
            n = this.column;
            this.column = n + 1;
        }
    }

    public static /* synthetic */ void forward$default(StreamReader streamReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        streamReader.forward(n);
    }

    public final int peek() {
        return StreamReader.ensureEnoughData$default(this, 0, 1, null) ? this.codePointsWindow[this.pointer] : 0;
    }

    public final int peek(int index) {
        return this.ensureEnoughData(index) ? this.codePointsWindow[this.pointer + index] : 0;
    }

    @NotNull
    public final String prefix(int length) {
        if (length == 0) {
            return "";
        }
        int stringLength = this.ensureEnoughData(length) ? length : RangesKt.coerceAtMost((int)length, (int)(this.dataLength - this.pointer));
        return ArraysKt.joinToString$default((int[])StreamReader.Companion.copyOfRangeSafe(this.codePointsWindow, this.pointer, this.pointer + stringLength), (CharSequence)"", null, null, (int)0, null, (Function1)prefix.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final String prefixForward(int length) {
        String prefix2 = this.prefix(length);
        this.pointer += length;
        this.moveIndices(length);
        this.column += length;
        return prefix2;
    }

    private final boolean ensureEnoughData(int size) {
        if (!this.eof && this.pointer + size >= this.dataLength) {
            this.update();
        }
        return this.pointer + size < this.dataLength;
    }

    static /* synthetic */ boolean ensureEnoughData$default(StreamReader streamReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return streamReader.ensureEnoughData(n);
    }

    private final void update() {
        try {
            String buffer = this.stream.readUtf8();
            int read = buffer.length();
            if (read > 0) {
                int cpIndex = this.dataLength - this.pointer;
                this.codePointsWindow = StreamReader.Companion.copyOfRangeSafe(this.codePointsWindow, this.pointer, this.dataLength + read);
                Integer nonPrintable = null;
                int i = 0;
                while (i < read) {
                    int codePoint;
                    this.codePointsWindow[cpIndex] = codePoint = CharSequenceExtensionsKt.codePointAt(buffer, i);
                    if (Companion.isPrintable(codePoint)) {
                        i += Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint);
                    } else {
                        nonPrintable = codePoint;
                        i = read;
                    }
                    ++cpIndex;
                }
                this.dataLength = cpIndex;
                this.pointer = 0;
                if (nonPrintable != null) {
                    throw new ReaderException(this.name, cpIndex - 1, nonPrintable, "special characters are not allowed");
                }
            } else {
                this.eof = true;
            }
        }
        catch (IOException ioe) {
            throw new YamlEngineException(ioe);
        }
    }

    private final void moveIndices(int length) {
        this.index += length;
        this.documentIndex += length;
    }

    public final void resetDocumentIndex() {
        this.documentIndex = 0;
    }

    @JvmOverloads
    public final void forward() {
        StreamReader.forward$default(this, 0, 1, null);
    }

    @JvmStatic
    public static final boolean isPrintable(@NotNull String data) {
        return Companion.isPrintable(data);
    }

    @JvmStatic
    public static final boolean isPrintable(int c) {
        return Companion.isPrintable(c);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/snakeyaml/engine/v2/scanner/StreamReader$Companion;", "", "()V", "isPrintable", "", "c", "", "data", "", "copyOfRangeSafe", "", "fromIndex", "toIndex", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isPrintable(@NotNull String data) {
            int codePoint;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int length = data.length();
            for (int offset = 0; offset < length; offset += Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint)) {
                codePoint = CharSequenceExtensionsKt.codePointAt(data, offset);
                if (this.isPrintable(codePoint)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isPrintable(int c) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (32 <= c) {
                if (c < 127) {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if (c == 9) return true;
            if (c == 10) return true;
            if (c == 13) return true;
            if (c == 133) return true;
            if (160 <= c) {
                if (c < 55296) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if (57344 <= c) {
                if (c < 65534) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (65536 > c) return false;
            if (c >= 0x110000) return false;
            return true;
        }

        private final int[] copyOfRangeSafe(int[] $this$copyOfRangeSafe, int fromIndex, int toIndex) {
            int n = toIndex - fromIndex;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                Integer n3 = ArraysKt.getOrNull((int[])$this$copyOfRangeSafe, (int)(fromIndex + n2));
                nArray[n2] = n3 != null ? n3 : 0;
            }
            return nArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

