/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.constructor.json;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.constructor.ConstructScalar;
import org.snakeyaml.engine.v2.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/snakeyaml/engine/v2/constructor/json/ConstructYamlJsonFloat;", "Lorg/snakeyaml/engine/v2/constructor/ConstructScalar;", "()V", "construct", "", "node", "Lorg/snakeyaml/engine/v2/nodes/Node;", "(Lorg/snakeyaml/engine/v2/nodes/Node;)Ljava/lang/Double;", "constructFromString", "value", "", "snakeyaml-engine-kmp"})
public class ConstructYamlJsonFloat
extends ConstructScalar {
    @Override
    @NotNull
    public Double construct(@Nullable Node node) {
        double d;
        switch (this.constructScalar(node)) {
            case ".inf": {
                d = Double.POSITIVE_INFINITY;
                break;
            }
            case "-.inf": {
                d = Double.NEGATIVE_INFINITY;
                break;
            }
            case ".nan": {
                d = Double.NaN;
                break;
            }
            default: {
                String value;
                d = this.constructFromString(value);
            }
        }
        return d;
    }

    private final double constructFromString(String value) {
        Pair pair;
        Character c;
        Character c2 = c = StringsKt.firstOrNull((CharSequence)value);
        char c3 = '-';
        if (c2 != null && c2.charValue() == c3) {
            Integer n = -1;
            String string = value.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            pair = TuplesKt.to((Object)n, (Object)string);
        } else {
            Character c4 = c;
            c3 = '+';
            if (c4 != null && c4.charValue() == c3) {
                Integer n = 1;
                String string = value.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pair = TuplesKt.to((Object)n, (Object)string);
            } else {
                pair = TuplesKt.to((Object)1, (Object)value);
            }
        }
        Pair pair2 = pair;
        int sign = ((Number)pair2.component1()).intValue();
        String number = (String)pair2.component2();
        double d = Double.parseDouble(number);
        return d * (double)sign;
    }
}

