/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.emitter;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.internal.utils.CharSequenceExtensionsKt;
import org.snakeyaml.engine.internal.utils.Character;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.comments.CommentEventsCollector;
import org.snakeyaml.engine.v2.comments.CommentLine;
import org.snakeyaml.engine.v2.comments.CommentType;
import org.snakeyaml.engine.v2.common.Anchor;
import org.snakeyaml.engine.v2.common.CharConstants;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.common.SpecVersion;
import org.snakeyaml.engine.v2.emitter.Emitable;
import org.snakeyaml.engine.v2.emitter.EmitterState;
import org.snakeyaml.engine.v2.emitter.ScalarAnalysis;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.CollectionEndEvent;
import org.snakeyaml.engine.v2.events.CollectionStartEvent;
import org.snakeyaml.engine.v2.events.CommentEvent;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.NodeEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamEndEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;
import org.snakeyaml.engine.v2.exceptions.EmitterException;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b*\u0018\u0000 \u0082\u00012\u00020\u0001:&\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001\u0091\u0001\u0092\u0001\u0093\u0001\u0094\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u000eH\u0002J\b\u0010>\u001a\u00020\bH\u0002J\b\u0010?\u001a\u00020\bH\u0002J\b\u0010@\u001a\u00020\bH\u0002J\u0012\u0010A\u001a\u0004\u0018\u0001022\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000eH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010H\u001a\u00020GH\u0002J\b\u0010I\u001a\u00020GH\u0002J\b\u0010J\u001a\u00020GH\u0002J\b\u0010K\u001a\u00020GH\u0002J\b\u0010L\u001a\u00020GH\u0002J&\u0010M\u001a\u00020G2\b\b\u0002\u0010N\u001a\u00020\b2\b\b\u0002\u0010O\u001a\u00020\b2\b\b\u0002\u0010P\u001a\u00020\bH\u0002J\b\u0010Q\u001a\u00020GH\u0002J\b\u0010R\u001a\u00020GH\u0002J\u0010\u0010S\u001a\u00020G2\u0006\u0010T\u001a\u00020UH\u0002J\u001c\u0010V\u001a\u00020G2\b\b\u0002\u0010W\u001a\u00020\b2\b\b\u0002\u0010X\u001a\u00020\bH\u0002J\u001e\u0010Y\u001a\u00020\b2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u001a0[2\u0006\u0010\\\u001a\u00020\fH\u0002J\b\u0010]\u001a\u00020\bH\u0002J\u0010\u0010^\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000eH\u0002J\u0010\u0010`\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020bH\u0002J\u0010\u0010c\u001a\u00020G2\u0006\u0010d\u001a\u00020\u000eH\u0002J\u0010\u0010e\u001a\u00020G2\u0006\u0010B\u001a\u00020CH\u0002J\b\u0010f\u001a\u00020GH\u0002J\b\u0010g\u001a\u00020GH\u0002J\u0016\u0010h\u001a\u00020\b2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020k0jH\u0002J\u0018\u0010l\u001a\u00020G2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010m\u001a\u00020\bH\u0002J\u0018\u0010n\u001a\u00020G2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010m\u001a\u00020\bH\u0002J\b\u0010o\u001a\u00020GH\u0002J.\u0010p\u001a\u00020G2\u0006\u0010d\u001a\u00020\u000e2\b\b\u0002\u0010q\u001a\u00020\b2\b\b\u0002\u0010;\u001a\u00020\b2\b\b\u0002\u0010r\u001a\u00020\bH\u0002J\b\u0010s\u001a\u00020\bH\u0002J\u0014\u0010t\u001a\u00020G2\n\b\u0002\u0010u\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010v\u001a\u00020G2\u0006\u0010E\u001a\u00020\u000eH\u0002J\u0018\u0010w\u001a\u00020G2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010m\u001a\u00020\bH\u0002J\u0018\u0010x\u001a\u00020G2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010m\u001a\u00020\bH\u0002J\b\u0010y\u001a\u00020GH\u0002J\b\u0010z\u001a\u00020GH\u0002J\u0016\u0010{\u001a\u00020G2\u0006\u0010|\u001a\u00020\u000e2\u0006\u0010}\u001a\u00020\u000eJ\u000e\u0010~\u001a\u00020G2\u0006\u0010\u007f\u001a\u00020\u000eJ\u0012\u0010\u0080\u0001\u001a\u00020G2\u0007\u0010\u0081\u0001\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0014\u0010 \u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0018R\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u000e\u0010+\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0018R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002070\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00109\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000e0:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter;", "Lorg/snakeyaml/engine/v2/emitter/Emitable;", "opts", "Lorg/snakeyaml/engine/v2/api/DumpSettings;", "stream", "Lorg/snakeyaml/engine/v2/api/StreamDataWriter;", "(Lorg/snakeyaml/engine/v2/api/DumpSettings;Lorg/snakeyaml/engine/v2/api/StreamDataWriter;)V", "allowUnicode", "", "analysis", "Lorg/snakeyaml/engine/v2/emitter/ScalarAnalysis;", "bestIndent", "", "bestLineBreak", "", "getBestLineBreak", "()Ljava/lang/String;", "bestWidth", "blockCommentsCollector", "Lorg/snakeyaml/engine/v2/comments/CommentEventsCollector;", "canonical", "column", "emitComments", "getEmitComments", "()Z", "event", "Lorg/snakeyaml/engine/v2/events/Event;", "events", "Lkotlin/collections/ArrayDeque;", "flowLevel", "indent", "Ljava/lang/Integer;", "indentWithIndicator", "getIndentWithIndicator", "indention", "indents", "indicatorIndent", "getIndicatorIndent", "()I", "inlineCommentsCollector", "mappingContext", "maxSimpleKeyLength", "getMaxSimpleKeyLength", "multiLineFlow", "openEnded", "preparedAnchor", "Lorg/snakeyaml/engine/v2/common/Anchor;", "preparedTag", "rootContext", "scalarStyle", "Lorg/snakeyaml/engine/v2/common/ScalarStyle;", "simpleKeyContext", "splitLines", "getSplitLines", "state", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "states", "tagPrefixes", "", "whitespace", "analyzeScalar", "scalar", "checkEmptyMapping", "checkEmptySequence", "checkSimpleKey", "chooseScalarStyle", "ev", "Lorg/snakeyaml/engine/v2/events/ScalarEvent;", "determineBlockHints", "text", "emit", "", "expectAlias", "expectBlockMapping", "expectBlockSequence", "expectFlowMapping", "expectFlowSequence", "expectNode", "root", "mapping", "simpleKey", "expectScalar", "flushStream", "handleNodeEvent", "id", "Lorg/snakeyaml/engine/v2/events/Event$ID;", "increaseIndent", "isFlow", "indentless", "needEvents", "iter", "", "count", "needMoreEvents", "prepareTag", "tag", "prepareVersion", "version", "Lorg/snakeyaml/engine/v2/common/SpecVersion;", "processAnchor", "indicator", "processScalar", "processTag", "writeBlockComment", "writeCommentLines", "commentLines", "", "Lorg/snakeyaml/engine/v2/comments/CommentLine;", "writeDoubleQuoted", "split", "writeFolded", "writeIndent", "writeIndicator", "needWhitespace", "indentation", "writeInlineComments", "writeLineBreak", "data", "writeLiteral", "writePlain", "writeSingleQuoted", "writeStreamEnd", "writeStreamStart", "writeTagDirective", "handleText", "prefixText", "writeVersionDirective", "versionText", "writeWhitespace", "length", "Companion", "ExpectBlockMappingKey", "ExpectBlockMappingSimpleValue", "ExpectBlockMappingValue", "ExpectBlockSequenceItem", "ExpectDocumentEnd", "ExpectDocumentRoot", "ExpectDocumentStart", "ExpectFirstBlockMappingKey", "ExpectFirstBlockSequenceItem", "ExpectFirstDocumentStart", "ExpectFirstFlowMappingKey", "ExpectFirstFlowSequenceItem", "ExpectFlowMappingKey", "ExpectFlowMappingSimpleValue", "ExpectFlowMappingValue", "ExpectFlowSequenceItem", "ExpectNothing", "ExpectStreamStart", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Emitter.kt\norg/snakeyaml/engine/v2/emitter/Emitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1581:1\n288#2,2:1582\n*S KotlinDebug\n*F\n+ 1 Emitter.kt\norg/snakeyaml/engine/v2/emitter/Emitter\n*L\n901#1:1582,2\n*E\n"})
public final class Emitter
implements Emitable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DumpSettings opts;
    @NotNull
    private final StreamDataWriter stream;
    @NotNull
    private final ArrayDeque<EmitterState> states;
    @NotNull
    private EmitterState state;
    @NotNull
    private final ArrayDeque<Event> events;
    @Nullable
    private Event event;
    @NotNull
    private final ArrayDeque<Integer> indents;
    @Nullable
    private Integer indent;
    private int flowLevel;
    private boolean rootContext;
    private boolean mappingContext;
    private boolean simpleKeyContext;
    private int column;
    private boolean whitespace;
    private boolean indention;
    private boolean openEnded;
    private final boolean canonical;
    private final boolean multiLineFlow;
    private final boolean allowUnicode;
    private final int bestIndent;
    private final int bestWidth;
    @NotNull
    private Map<String, String> tagPrefixes;
    @Nullable
    private Anchor preparedAnchor;
    @Nullable
    private String preparedTag;
    @Nullable
    private ScalarAnalysis analysis;
    @Nullable
    private ScalarStyle scalarStyle;
    @NotNull
    private final CommentEventsCollector blockCommentsCollector;
    @NotNull
    private final CommentEventsCollector inlineCommentsCollector;
    @NotNull
    private static final Map<java.lang.Character, String> ESCAPE_REPLACEMENTS;
    @NotNull
    private static final Map<String, String> DEFAULT_TAG_PREFIXES;
    @JvmField
    @NotNull
    public static final IntRange VALID_INDENT_RANGE;
    @JvmField
    @NotNull
    public static final IntRange VALID_INDICATOR_INDENT_RANGE;
    private static final int DEFAULT_INDENT = 2;
    private static final int DEFAULT_WIDTH = 80;
    @NotNull
    private static final String SPACE = " ";
    @NotNull
    private static final Regex HANDLE_FORMAT;

    public Emitter(@NotNull DumpSettings opts, @NotNull StreamDataWriter stream) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.opts = opts;
        this.stream = stream;
        this.states = new ArrayDeque(100);
        this.state = new ExpectStreamStart();
        this.events = new ArrayDeque(100);
        this.indents = new ArrayDeque(100);
        this.whitespace = true;
        this.indention = true;
        this.canonical = this.opts.isCanonical();
        this.multiLineFlow = this.opts.isMultiLineFlow();
        this.allowUnicode = this.opts.isUseUnicodeEncoding();
        CommentType[] commentTypeArray = VALID_INDENT_RANGE;
        int n = commentTypeArray.getFirst();
        int n2 = commentTypeArray.getLast();
        int n3 = this.opts.indent;
        this.bestIndent = (n <= n3 ? n3 <= n2 : false) ? this.opts.indent : 2;
        this.bestWidth = this.opts.width > this.bestIndent * 2 ? this.opts.width : 80;
        this.tagPrefixes = new LinkedHashMap();
        commentTypeArray = new CommentType[]{CommentType.BLANK_LINE, CommentType.BLOCK};
        this.blockCommentsCollector = new CommentEventsCollector(this.events, commentTypeArray);
        commentTypeArray = new CommentType[]{CommentType.IN_LINE};
        this.inlineCommentsCollector = new CommentEventsCollector(this.events, commentTypeArray);
    }

    private final int getIndicatorIndent() {
        return this.opts.indicatorIndent;
    }

    private final boolean getIndentWithIndicator() {
        return this.opts.indentWithIndicator;
    }

    private final String getBestLineBreak() {
        return this.opts.bestLineBreak;
    }

    private final boolean getSplitLines() {
        return this.opts.isSplitLines();
    }

    private final int getMaxSimpleKeyLength() {
        return this.opts.maxSimpleKeyLength;
    }

    private final boolean getEmitComments() {
        return this.opts.dumpComments;
    }

    @Override
    public void emit(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.events.add((Object)event);
        while (!this.needMoreEvents()) {
            this.event = (Event)this.events.removeFirst();
            this.state.expect();
            this.event = null;
        }
    }

    private final boolean needMoreEvents() {
        if (this.events.isEmpty()) {
            return true;
        }
        Iterator iter2 = this.events.iterator();
        Event event = (Event)iter2.next();
        while (event instanceof CommentEvent) {
            if (!iter2.hasNext()) {
                return true;
            }
            event = (Event)iter2.next();
        }
        Event event2 = event;
        return event2 instanceof DocumentStartEvent ? this.needEvents(iter2, 1) : (event2 instanceof SequenceStartEvent ? this.needEvents(iter2, 2) : (event2 instanceof MappingStartEvent ? this.needEvents(iter2, 3) : (event2 instanceof StreamStartEvent ? this.needEvents(iter2, 2) : (event2 instanceof StreamEndEvent ? false : (this.getEmitComments() ? this.needEvents(iter2, 1) : false)))));
    }

    private final boolean needEvents(Iterator<? extends Event> iter2, int count) {
        int level = 0;
        int actualCount = 0;
        Iterator<? extends Event> iterator = iter2;
        while (iterator.hasNext()) {
            Event event = iterator.next();
            if (event instanceof CommentEvent) continue;
            ++actualCount;
            Event event2 = event;
            if (event2 instanceof DocumentStartEvent ? true : event2 instanceof CollectionStartEvent) {
                ++level;
            } else if (event2 instanceof DocumentEndEvent ? true : event2 instanceof CollectionEndEvent) {
                --level;
            } else if (event2 instanceof StreamEndEvent) {
                level = -1;
            }
            if (level >= 0) continue;
            return false;
        }
        return actualCount < count;
    }

    private final void increaseIndent(boolean isFlow, boolean indentless) {
        this.indents.addLast((Object)this.indent);
        if (this.indent == null) {
            this.indent = isFlow ? Integer.valueOf(this.bestIndent) : Integer.valueOf(0);
        } else if (!indentless) {
            Integer n = this.indent;
            Intrinsics.checkNotNull((Object)n);
            this.indent = n + this.bestIndent;
        }
    }

    static /* synthetic */ void increaseIndent$default(Emitter emitter, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        emitter.increaseIndent(bl, bl2);
    }

    private final void expectNode(boolean root, boolean mapping, boolean simpleKey) {
        this.rootContext = root;
        this.mappingContext = mapping;
        this.simpleKeyContext = simpleKey;
        Event event = this.event;
        Event.ID iD = event != null ? event.getEventId() : null;
        switch (iD == null ? -1 : WhenMappings.$EnumSwitchMapping$0[iD.ordinal()]) {
            case 1: {
                this.expectAlias();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.processAnchor("&");
                this.processTag();
                Event event2 = this.event;
                Intrinsics.checkNotNull((Object)event2);
                this.handleNodeEvent(event2.getEventId());
                break;
            }
            default: {
                Event event3 = this.event;
                throw new EmitterException("expected NodeEvent, but got " + (event3 != null ? event3.getEventId() : null));
            }
        }
    }

    static /* synthetic */ void expectNode$default(Emitter emitter, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        emitter.expectNode(bl, bl2, bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleNodeEvent(Event.ID id) {
        switch (WhenMappings.$EnumSwitchMapping$0[id.ordinal()]) {
            case 2: {
                this.expectScalar();
                return;
            }
            case 3: {
                if (this.flowLevel == 0 && !this.canonical) {
                    Event event = this.event;
                    Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.SequenceStartEvent");
                    if (!((SequenceStartEvent)event).isFlow() && !this.checkEmptySequence()) {
                        this.expectBlockSequence();
                        return;
                    }
                }
                this.expectFlowSequence();
                return;
            }
            case 4: {
                if (this.flowLevel == 0 && !this.canonical) {
                    Event event = this.event;
                    Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.MappingStartEvent");
                    if (!((MappingStartEvent)event).isFlow() && !this.checkEmptyMapping()) {
                        this.expectBlockMapping();
                        return;
                    }
                }
                this.expectFlowMapping();
                return;
            }
        }
        throw new IllegalStateException();
    }

    private final void expectAlias() {
        if (!(this.event instanceof AliasEvent)) {
            throw new EmitterException("Expecting Alias.");
        }
        this.processAnchor("*");
        this.state = (EmitterState)this.states.removeLast();
    }

    private final void expectScalar() {
        Emitter.increaseIndent$default(this, true, false, 2, null);
        Event event = this.event;
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.ScalarEvent");
        this.processScalar((ScalarEvent)event);
        this.indent = (Integer)this.indents.removeLastOrNull();
        this.state = (EmitterState)this.states.removeLast();
    }

    private final void expectFlowSequence() {
        Emitter.writeIndicator$default(this, "[", true, true, false, 8, null);
        int n = this.flowLevel;
        this.flowLevel = n + 1;
        Emitter.increaseIndent$default(this, true, false, 2, null);
        if (this.multiLineFlow) {
            this.writeIndent();
        }
        this.state = new ExpectFirstFlowSequenceItem();
    }

    private final void expectFlowMapping() {
        Emitter.writeIndicator$default(this, "{", true, true, false, 8, null);
        int n = this.flowLevel;
        this.flowLevel = n + 1;
        Emitter.increaseIndent$default(this, true, false, 2, null);
        if (this.multiLineFlow) {
            this.writeIndent();
        }
        this.state = new ExpectFirstFlowMappingKey();
    }

    private final void expectBlockSequence() {
        boolean indentless = this.mappingContext && !this.indention;
        Emitter.increaseIndent$default(this, false, indentless, 1, null);
        this.state = new ExpectFirstBlockSequenceItem();
    }

    private final void expectBlockMapping() {
        Emitter.increaseIndent$default(this, false, false, 3, null);
        this.state = new ExpectFirstBlockMappingKey();
    }

    private final boolean checkEmptySequence() {
        Event event = this.event;
        return (event != null ? event.getEventId() : null) == Event.ID.SequenceStart && !this.events.isEmpty() && ((Event)this.events.first()).getEventId() == Event.ID.SequenceEnd;
    }

    private final boolean checkEmptyMapping() {
        Event event = this.event;
        return (event != null ? event.getEventId() : null) == Event.ID.MappingStart && !this.events.isEmpty() && ((Event)this.events.first()).getEventId() == Event.ID.MappingEnd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSimpleKey() {
        String tag;
        String string;
        int length = 0;
        if (this.event instanceof NodeEvent) {
            Event event = this.event;
            Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.NodeEvent");
            Anchor anchor = ((NodeEvent)event).getAnchor();
            if (anchor != null) {
                if (this.preparedAnchor == null) {
                    this.preparedAnchor = anchor;
                }
                length += anchor.getValue().length();
            }
        }
        Event event = this.event;
        if ((event != null ? event.getEventId() : null) == Event.ID.Scalar) {
            Event event2 = this.event;
            Intrinsics.checkNotNull((Object)event2, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.ScalarEvent");
            string = ((ScalarEvent)event2).getTag();
        } else if (this.event instanceof CollectionStartEvent) {
            Event event3 = this.event;
            Intrinsics.checkNotNull((Object)event3, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.CollectionStartEvent");
            string = ((CollectionStartEvent)event3).getTag();
        } else {
            string = tag = null;
        }
        if (tag != null) {
            if (this.preparedTag == null) {
                this.preparedTag = this.prepareTag(tag);
            }
            String string2 = this.preparedTag;
            Intrinsics.checkNotNull((Object)string2);
            length += string2.length();
        }
        Event event4 = this.event;
        if ((event4 != null ? event4.getEventId() : null) == Event.ID.Scalar) {
            if (this.analysis == null) {
                Event event5 = this.event;
                Intrinsics.checkNotNull((Object)event5, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.ScalarEvent");
                this.analysis = this.analyzeScalar(((ScalarEvent)event5).getValue());
            }
            ScalarAnalysis scalarAnalysis = this.analysis;
            Intrinsics.checkNotNull((Object)scalarAnalysis);
            length += scalarAnalysis.getScalar().length();
        }
        if (length >= this.getMaxSimpleKeyLength()) return false;
        Event event6 = this.event;
        if ((event6 != null ? event6.getEventId() : null) == Event.ID.Alias) return true;
        Event event7 = this.event;
        if ((event7 != null ? event7.getEventId() : null) == Event.ID.Scalar) {
            ScalarAnalysis scalarAnalysis = this.analysis;
            Intrinsics.checkNotNull((Object)scalarAnalysis);
            if (!scalarAnalysis.getEmpty()) {
                ScalarAnalysis scalarAnalysis2 = this.analysis;
                Intrinsics.checkNotNull((Object)scalarAnalysis2);
                if (!scalarAnalysis2.getMultiline()) return true;
            }
        }
        if (this.checkEmptySequence()) return true;
        if (!this.checkEmptyMapping()) return false;
        return true;
    }

    private final void processAnchor(String indicator) {
        Event event = this.event;
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.NodeEvent");
        NodeEvent ev = (NodeEvent)event;
        Anchor anchor = ev.getAnchor();
        if (anchor != null) {
            if (this.preparedAnchor == null) {
                this.preparedAnchor = anchor;
            }
            Emitter.writeIndicator$default(this, indicator + anchor, true, false, false, 12, null);
        }
        this.preparedAnchor = null;
    }

    private final void processTag() {
        NodeEvent ev;
        String tag = null;
        Event event = this.event;
        if ((event != null ? event.getEventId() : null) == Event.ID.Scalar) {
            Event event2 = this.event;
            Intrinsics.checkNotNull((Object)event2, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.ScalarEvent");
            ev = (ScalarEvent)event2;
            tag = ((ScalarEvent)ev).getTag();
            if (this.scalarStyle == null) {
                this.scalarStyle = this.chooseScalarStyle((ScalarEvent)ev);
            }
            if ((!this.canonical || tag == null) && (this.scalarStyle == null && ((ScalarEvent)ev).getImplicit().canOmitTagInPlainScalar() || this.scalarStyle != null && ((ScalarEvent)ev).getImplicit().canOmitTagInNonPlainScalar())) {
                this.preparedTag = null;
                return;
            }
            if (((ScalarEvent)ev).getImplicit().canOmitTagInPlainScalar() && tag == null) {
                tag = "!";
                this.preparedTag = null;
            }
        } else {
            Event event3 = this.event;
            Intrinsics.checkNotNull((Object)event3, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.CollectionStartEvent");
            ev = (CollectionStartEvent)event3;
            tag = ((CollectionStartEvent)ev).getTag();
            if ((!this.canonical || tag == null) && ((CollectionStartEvent)ev).isImplicit()) {
                this.preparedTag = null;
                return;
            }
        }
        if (tag == null) {
            throw new EmitterException("tag is not specified");
        }
        String string = this.preparedTag;
        if (string == null) {
            string = this.prepareTag(tag);
        }
        String indicator = string;
        Emitter.writeIndicator$default(this, indicator, true, false, false, 12, null);
    }

    private final ScalarStyle chooseScalarStyle(ScalarEvent ev) {
        block14: {
            block15: {
                block10: {
                    block13: {
                        block12: {
                            block11: {
                                if (this.analysis == null) {
                                    this.analysis = this.analyzeScalar(ev.getValue());
                                }
                                if (!ev.getPlain() && ev.getScalarStyle() == ScalarStyle.DOUBLE_QUOTED || this.canonical) {
                                    return ScalarStyle.DOUBLE_QUOTED;
                                }
                                if (!ev.getPlain() || !ev.getImplicit().canOmitTagInPlainScalar()) break block10;
                                if (!this.simpleKeyContext) break block11;
                                ScalarAnalysis scalarAnalysis = this.analysis;
                                Intrinsics.checkNotNull((Object)scalarAnalysis);
                                if (scalarAnalysis.getEmpty()) break block10;
                                ScalarAnalysis scalarAnalysis2 = this.analysis;
                                Intrinsics.checkNotNull((Object)scalarAnalysis2);
                                if (scalarAnalysis2.getMultiline()) break block10;
                            }
                            if (this.flowLevel == 0) break block12;
                            ScalarAnalysis scalarAnalysis = this.analysis;
                            Intrinsics.checkNotNull((Object)scalarAnalysis);
                            if (scalarAnalysis.getAllowFlowPlain()) break block13;
                        }
                        if (this.flowLevel != 0) break block10;
                        ScalarAnalysis scalarAnalysis = this.analysis;
                        Intrinsics.checkNotNull((Object)scalarAnalysis);
                        if (!scalarAnalysis.getAllowBlockPlain()) break block10;
                    }
                    return null;
                }
                if (!(ev.getPlain() || ev.getScalarStyle() != ScalarStyle.LITERAL && ev.getScalarStyle() != ScalarStyle.FOLDED || this.flowLevel != 0 || this.simpleKeyContext)) {
                    ScalarAnalysis scalarAnalysis = this.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    if (scalarAnalysis.getAllowBlock()) {
                        return ev.getScalarStyle();
                    }
                }
                if (!ev.getPlain() && ev.getScalarStyle() != ScalarStyle.SINGLE_QUOTED) break block14;
                ScalarAnalysis scalarAnalysis = this.analysis;
                Intrinsics.checkNotNull((Object)scalarAnalysis);
                if (!scalarAnalysis.getAllowSingleQuoted()) break block14;
                if (!this.simpleKeyContext) break block15;
                ScalarAnalysis scalarAnalysis3 = this.analysis;
                Intrinsics.checkNotNull((Object)scalarAnalysis3);
                if (scalarAnalysis3.getMultiline()) break block14;
            }
            return ScalarStyle.SINGLE_QUOTED;
        }
        return ScalarStyle.DOUBLE_QUOTED;
    }

    private final void processScalar(ScalarEvent ev) {
        boolean split;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(ev.getValue());
        }
        if (this.scalarStyle == null) {
            this.scalarStyle = this.chooseScalarStyle(ev);
        }
        boolean bl = split = !this.simpleKeyContext && this.getSplitLines();
        if (this.scalarStyle == null) {
            ScalarAnalysis scalarAnalysis = this.analysis;
            Intrinsics.checkNotNull((Object)scalarAnalysis);
            this.writePlain(scalarAnalysis.getScalar(), split);
        } else {
            ScalarStyle scalarStyle = this.scalarStyle;
            switch (scalarStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$1[scalarStyle.ordinal()]) {
                case 1: {
                    ScalarAnalysis scalarAnalysis = this.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    this.writeDoubleQuoted(scalarAnalysis.getScalar(), split);
                    break;
                }
                case 2: {
                    ScalarAnalysis scalarAnalysis = this.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    this.writeSingleQuoted(scalarAnalysis.getScalar(), split);
                    break;
                }
                case 3: {
                    ScalarAnalysis scalarAnalysis = this.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    this.writeFolded(scalarAnalysis.getScalar(), split);
                    break;
                }
                case 4: {
                    ScalarAnalysis scalarAnalysis = this.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    this.writeLiteral(scalarAnalysis.getScalar());
                    break;
                }
                default: {
                    throw new YamlEngineException("Unexpected scalarStyle: " + this.scalarStyle);
                }
            }
        }
        this.analysis = null;
        this.scalarStyle = null;
    }

    private final String prepareVersion(SpecVersion version) {
        if (version.getMajor() != 1) {
            throw new EmitterException("unsupported YAML version: " + version);
        }
        return version.getRepresentation();
    }

    private final String prepareTag(String tag) {
        Object v1;
        block5: {
            if (((CharSequence)tag).length() == 0) {
                throw new EmitterException("tag must not be empty");
            }
            if (Intrinsics.areEqual((Object)"!", (Object)tag)) {
                return tag;
            }
            Iterable $this$firstOrNull$iv = this.tagPrefixes.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String prefix2 = (String)element$iv;
                boolean bl = false;
                boolean bl2 = prefix2 != null && StringsKt.startsWith$default((String)tag, (String)prefix2, (boolean)false, (int)2, null) && (Intrinsics.areEqual((Object)"!", (Object)prefix2) || prefix2.length() < tag.length());
                if (!bl2) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        String matchedPrefix = v1;
        String handle = null;
        String suffix = null;
        if (matchedPrefix != null) {
            handle = this.tagPrefixes.get(matchedPrefix);
            String string = tag.substring(matchedPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            suffix = string;
        } else {
            handle = null;
            suffix = tag;
        }
        String suffixText = StringsKt.take((String)suffix, (int)suffix.length());
        String string = handle;
        return string != null ? string + suffixText : "!<" + suffixText + ">";
    }

    /*
     * Unable to fully structure code
     */
    private final ScalarAnalysis analyzeScalar(String scalar) {
        if (((CharSequence)scalar).length() == 0) {
            return new ScalarAnalysis(scalar, true, false, false, true, true, false);
        }
        blockIndicators = false;
        flowIndicators = false;
        lineBreaks = false;
        specialCharacters = false;
        leadingSpace = false;
        leadingBreak = false;
        trailingSpace = false;
        trailingBreak = false;
        breakSpace = false;
        spaceBreak = false;
        if (StringsKt.startsWith$default((String)scalar, (String)"---", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)scalar, (String)"...", (boolean)false, (int)2, null)) {
            blockIndicators = true;
            flowIndicators = true;
        }
        precededByWhitespace = true;
        followedByWhitespace = scalar.length() == 1 || CharConstants.NULL_BL_T_LINEBR.has(CharSequenceExtensionsKt.codePointAt(scalar, 1)) != false;
        previousSpace = false;
        previousBreak = false;
        index = 0;
        while (index < scalar.length()) {
            block35: {
                c = CharSequenceExtensionsKt.codePointAt(scalar, index);
                if (index == 0) {
                    if (StringsKt.contains$default((CharSequence)"#,[]{}&*!|>'\"%@`", (char)((char)c), (boolean)false, (int)2, null)) {
                        flowIndicators = true;
                        blockIndicators = true;
                    }
                    switch (c) {
                        case 58: 
                        case 63: {
                            flowIndicators = true;
                            if (!followedByWhitespace) break;
                            blockIndicators = true;
                        }
                    }
                    if (c == 45 && followedByWhitespace) {
                        flowIndicators = true;
                        blockIndicators = true;
                    }
                } else {
                    if (StringsKt.contains$default((CharSequence)",?[]{}", (char)((char)c), (boolean)false, (int)2, null)) {
                        flowIndicators = true;
                    }
                    if (c == 58) {
                        flowIndicators = true;
                        if (followedByWhitespace) {
                            blockIndicators = true;
                        }
                    }
                    if (c == 35 && precededByWhitespace) {
                        flowIndicators = true;
                        blockIndicators = true;
                    }
                }
                if (isLineBreak = CharConstants.LINEBR.has(c)) {
                    lineBreaks = true;
                }
                if (c == 10) break block35;
                if (32 <= c ? c < 127 : false) break block35;
                if (c == 133) ** GOTO lbl-1000
                if (160 <= c ? c < 55296 : false) ** GOTO lbl-1000
                if (57344 <= c ? c < 65534 : false) ** GOTO lbl-1000
                v0 = 65536 <= c ? c < 0x110000 : false;
                if (v0) lbl-1000:
                // 4 sources

                {
                    if (!this.allowUnicode) {
                        specialCharacters = true;
                    }
                } else {
                    specialCharacters = true;
                }
            }
            if (c == 32) {
                if (index == 0) {
                    leadingSpace = true;
                }
                if (index == scalar.length() - 1) {
                    trailingSpace = true;
                }
                if (previousBreak) {
                    breakSpace = true;
                }
                previousSpace = true;
                previousBreak = false;
            } else if (isLineBreak) {
                if (index == 0) {
                    leadingBreak = true;
                }
                if (index == scalar.length() - 1) {
                    trailingBreak = true;
                }
                if (previousSpace) {
                    spaceBreak = true;
                }
                previousSpace = false;
                previousBreak = true;
            } else {
                previousSpace = false;
                previousBreak = false;
            }
            precededByWhitespace = CharConstants.NULL_BL_T.has(c) != false || isLineBreak != false;
            followedByWhitespace = true;
            if ((index += Character.INSTANCE.charCount$snakeyaml_engine_kmp(c)) + 1 >= scalar.length() || (nextIndex = index + Character.INSTANCE.charCount$snakeyaml_engine_kmp(CharSequenceExtensionsKt.codePointAt(scalar, index))) >= scalar.length()) continue;
            followedByWhitespace = CharConstants.NULL_BL_T.has(CharSequenceExtensionsKt.codePointAt(scalar, nextIndex)) != false || isLineBreak != false;
        }
        allowFlowPlain = true;
        allowBlockPlain = true;
        allowSingleQuoted = true;
        allowBlock = true;
        if (leadingSpace || leadingBreak || trailingSpace || trailingBreak) {
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (trailingSpace) {
            allowBlock = false;
        }
        if (breakSpace) {
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (spaceBreak || specialCharacters) {
            allowBlock = false;
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (lineBreaks) {
            allowFlowPlain = false;
        }
        if (flowIndicators) {
            allowFlowPlain = false;
        }
        if (blockIndicators) {
            allowBlockPlain = false;
        }
        return new ScalarAnalysis(scalar, false, lineBreaks, allowFlowPlain, allowBlockPlain, allowSingleQuoted, allowBlock);
    }

    private final void flushStream() {
        this.stream.flush();
    }

    private final void writeStreamStart() {
    }

    private final void writeStreamEnd() {
        this.flushStream();
    }

    private final void writeIndicator(String indicator, boolean needWhitespace, boolean whitespace, boolean indentation) {
        if (!this.whitespace && needWhitespace) {
            int n = this.column;
            this.column = n + 1;
            this.stream.write(SPACE);
        }
        this.whitespace = whitespace;
        this.indention = this.indention && indentation;
        this.column += indicator.length();
        this.openEnded = false;
        this.stream.write(indicator);
    }

    static /* synthetic */ void writeIndicator$default(Emitter emitter, String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        emitter.writeIndicator(string, bl, bl2, bl3);
    }

    private final void writeIndent() {
        int indentToWrite;
        Integer n = this.indent;
        int n2 = indentToWrite = n != null ? n : 0;
        if (!this.indention || this.column > indentToWrite || this.column == indentToWrite && !this.whitespace) {
            Emitter.writeLineBreak$default(this, null, 1, null);
        }
        this.writeWhitespace(indentToWrite - this.column);
    }

    private final void writeWhitespace(int length) {
        if (length <= 0) {
            return;
        }
        this.whitespace = true;
        this.stream.write(StringsKt.repeat((CharSequence)SPACE, (int)length));
        this.column += length;
    }

    private final void writeLineBreak(String data) {
        this.whitespace = true;
        this.indention = true;
        this.column = 0;
        String string = data;
        if (string == null) {
            string = this.getBestLineBreak();
        }
        this.stream.write(string);
    }

    static /* synthetic */ void writeLineBreak$default(Emitter emitter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        emitter.writeLineBreak(string);
    }

    public final void writeVersionDirective(@NotNull String versionText) {
        Intrinsics.checkNotNullParameter((Object)versionText, (String)"versionText");
        this.stream.write("%YAML " + versionText);
        Emitter.writeLineBreak$default(this, null, 1, null);
    }

    public final void writeTagDirective(@NotNull String handleText, @NotNull String prefixText) {
        Intrinsics.checkNotNullParameter((Object)handleText, (String)"handleText");
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        this.stream.write("%TAG " + handleText + SPACE + prefixText);
        Emitter.writeLineBreak$default(this, null, 1, null);
    }

    private final void writeSingleQuoted(String text, boolean split) {
        Emitter.writeIndicator$default(this, "'", true, false, false, 12, null);
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        char ch = '\u0000';
        for (int end = 0; end <= text.length(); ++end) {
            int len;
            ch = '\u0000';
            if (end < text.length()) {
                ch = text.charAt(end);
            }
            if (spaces) {
                if (ch != ' ') {
                    if (start + 1 == end && this.column > this.bestWidth && split && start != 0 && end != text.length()) {
                        this.writeIndent();
                    } else {
                        len = end - start;
                        this.column += len;
                        this.stream.write(text, start, len);
                    }
                    start = end;
                }
            } else if (breaks) {
                if (ch == '\u0000' || CharConstants.LINEBR.hasNo(ch)) {
                    char[] cArray;
                    String data;
                    if (text.charAt(start) == '\n') {
                        Emitter.writeLineBreak$default(this, null, 1, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)text.substring(start, end), (String)"substring(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)data.toCharArray(), (String)"toCharArray(...)");
                    for (char br : cArray) {
                        if (br == '\n') {
                            Emitter.writeLineBreak$default(this, null, 1, null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(br));
                    }
                    this.writeIndent();
                    start = end;
                }
            } else if (CharConstants.LINEBR.has(ch, "\u0000 '") && start < end) {
                len = end - start;
                this.column += len;
                this.stream.write(text, start, len);
                start = end;
            }
            if (ch == '\'') {
                this.column += 2;
                this.stream.write("''");
                start = end + 1;
            }
            if (ch == '\u0000') continue;
            spaces = ch == ' ';
            breaks = CharConstants.LINEBR.has(ch);
        }
        Emitter.writeIndicator$default(this, "'", false, false, false, 14, null);
    }

    private final void writeDoubleQuoted(String text, boolean split) {
        Emitter.writeIndicator$default(this, "\"", true, false, false, 12, null);
        int start = 0;
        for (int end = 0; end <= text.length(); ++end) {
            Object object;
            java.lang.Character ch = null;
            if (end < text.length()) {
                ch = java.lang.Character.valueOf(text.charAt(end));
            }
            if (ch == null || StringsKt.contains$default((CharSequence)"\"\\\u0085\u2028\u2029\ufeff", (char)ch.charValue(), (boolean)false, (int)2, null) || Intrinsics.compare((int)32, (int)ch.charValue()) > 0 || Intrinsics.compare((int)ch.charValue(), (int)126) > 0) {
                if (start < end) {
                    int len = end - start;
                    this.column += len;
                    this.stream.write(text, start, len);
                    start = end;
                }
                if (ch != null) {
                    Object data = null;
                    if (ESCAPE_REPLACEMENTS.containsKey(ch)) {
                        data = "\\" + ESCAPE_REPLACEMENTS.get(ch);
                    } else {
                        int codePoint;
                        int n;
                        if (java.lang.Character.isHighSurrogate(ch.charValue()) && end + 1 < text.length()) {
                            char ch2 = text.charAt(end + 1);
                            n = Character.INSTANCE.toCodePoint$snakeyaml_engine_kmp(ch.charValue(), ch2);
                        } else {
                            n = codePoint = ch.charValue();
                        }
                        if (this.allowUnicode && StreamReader.Companion.isPrintable(codePoint)) {
                            data = StringsKt.concatToString((char[])Character.INSTANCE.toChars$snakeyaml_engine_kmp(codePoint));
                            if (Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint) == 2) {
                                ++end;
                            }
                        } else {
                            String string;
                            String s;
                            if (Intrinsics.compare((int)ch.charValue(), (int)255) <= 0) {
                                String string2 = Integer.toString(ch.charValue(), CharsKt.checkRadix((int)16));
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                                s = "0" + string2;
                                String string3 = s.substring(s.length() - 2);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                string = "\\x" + string3;
                            } else if (Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint) == 2) {
                                ++end;
                                String string4 = Integer.toString(codePoint, CharsKt.checkRadix((int)16));
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                                s = "000" + string4;
                                String string5 = s.substring(s.length() - 8);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                                string = "\\U" + string5;
                            } else {
                                String string6 = Integer.toString(ch.charValue(), CharsKt.checkRadix((int)16));
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                                s = "000" + string6;
                                String string7 = s.substring(s.length() - 4);
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                                string = "\\u" + string7;
                            }
                            data = string;
                        }
                    }
                    this.column += ((String)data).length();
                    this.stream.write((String)data);
                    start = end + 1;
                }
            }
            if (0 >= end || end >= text.length() - 1) continue;
            java.lang.Character c = ch;
            char data = ' ';
            if ((c == null || c.charValue() != data) && start < end || this.column + (end - start) <= this.bestWidth || !split) continue;
            String data2 = null;
            if (start >= end) {
                object = "\\";
            } else {
                String string = text.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = data2 = string + "\\";
            }
            if (start < end) {
                start = end;
            }
            this.column += data2.length();
            this.stream.write(data2);
            this.writeIndent();
            this.whitespace = false;
            this.indention = false;
            if (text.charAt(start) != ' ') continue;
            data2 = "\\";
            this.column += data2.length();
            this.stream.write(data2);
        }
        Emitter.writeIndicator$default(this, "\"", false, false, false, 14, null);
    }

    private final boolean writeCommentLines(List<CommentLine> commentLines) {
        boolean wroteComment = false;
        if (this.getEmitComments()) {
            int indentColumns = 0;
            boolean firstComment = true;
            for (CommentLine commentLine : commentLines) {
                if (commentLine.commentType != CommentType.BLANK_LINE) {
                    if (firstComment) {
                        firstComment = false;
                        Emitter.writeIndicator$default(this, "#", commentLine.commentType == CommentType.IN_LINE, false, false, 12, null);
                        indentColumns = this.column > 0 ? this.column - 1 : 0;
                    } else {
                        this.writeWhitespace(indentColumns);
                        Emitter.writeIndicator$default(this, "#", false, false, false, 14, null);
                    }
                    this.stream.write(commentLine.value);
                    Emitter.writeLineBreak$default(this, null, 1, null);
                } else {
                    Emitter.writeLineBreak$default(this, null, 1, null);
                    this.writeIndent();
                }
                wroteComment = true;
            }
        }
        return wroteComment;
    }

    private final void writeBlockComment() {
        if (!this.blockCommentsCollector.isEmpty()) {
            this.writeIndent();
            this.writeCommentLines(this.blockCommentsCollector.consume());
        }
    }

    private final boolean writeInlineComments() {
        return this.writeCommentLines(this.inlineCommentsCollector.consume());
    }

    private final String determineBlockHints(String text) {
        char ch1;
        StringBuilder hints = new StringBuilder();
        if (CharConstants.LINEBR.has(StringsKt.first((CharSequence)text), SPACE)) {
            hints.append(this.bestIndent);
        }
        if (CharConstants.LINEBR.hasNo(ch1 = StringsKt.last((CharSequence)text))) {
            hints.append("-");
        } else if (text.length() == 1 || CharConstants.LINEBR.has(text.charAt(text.length() - 2))) {
            hints.append("+");
        }
        String string = hints.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void writeFolded(String text, boolean split) {
        String hints = this.determineBlockHints(text);
        Emitter.writeIndicator$default(this, ">" + hints, true, false, false, 12, null);
        if (StringsKt.endsWith$default((CharSequence)hints, (char)'+', (boolean)false, (int)2, null)) {
            this.openEnded = true;
        }
        if (!this.writeInlineComments()) {
            Emitter.writeLineBreak$default(this, null, 1, null);
        }
        boolean leadingSpace = true;
        boolean spaces = false;
        boolean breaks = true;
        int start = 0;
        for (int end = 0; end <= text.length(); ++end) {
            char ch = '\u0000';
            if (end < text.length()) {
                ch = text.charAt(end);
            }
            if (breaks) {
                if (ch == '\u0000' || CharConstants.LINEBR.hasNo(ch)) {
                    char[] cArray;
                    String data;
                    if (!leadingSpace && ch != '\u0000' && ch != ' ' && text.charAt(start) == '\n') {
                        Emitter.writeLineBreak$default(this, null, 1, null);
                    }
                    leadingSpace = ch == ' ';
                    Intrinsics.checkNotNullExpressionValue((Object)text.substring(start, end), (String)"substring(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)data.toCharArray(), (String)"toCharArray(...)");
                    for (char br : cArray) {
                        this.writeLineBreak(br == '\n' ? null : String.valueOf(br));
                    }
                    if (ch != '\u0000') {
                        this.writeIndent();
                    }
                    start = end;
                }
            } else if (spaces) {
                if (ch != ' ') {
                    if (start + 1 == end && this.column > this.bestWidth && split) {
                        this.writeIndent();
                    } else {
                        int len = end - start;
                        this.column += len;
                        this.stream.write(text, start, len);
                    }
                    start = end;
                }
            } else if (CharConstants.LINEBR.has(ch, "\u0000 ")) {
                int len = end - start;
                this.column += len;
                this.stream.write(text, start, len);
                if (ch == '\u0000') {
                    Emitter.writeLineBreak$default(this, null, 1, null);
                }
                start = end;
            }
            if (ch == '\u0000') continue;
            breaks = CharConstants.LINEBR.has(ch);
            spaces = ch == ' ';
        }
    }

    private final void writeLiteral(String text) {
        String hints = this.determineBlockHints(text);
        Emitter.writeIndicator$default(this, "|" + hints, true, false, false, 12, null);
        if (StringsKt.endsWith$default((CharSequence)hints, (char)'+', (boolean)false, (int)2, null)) {
            this.openEnded = true;
        }
        if (!this.writeInlineComments()) {
            Emitter.writeLineBreak$default(this, null, 1, null);
        }
        boolean breaks = true;
        int start = 0;
        for (int end = 0; end <= text.length(); ++end) {
            char ch = '\u0000';
            if (end < text.length()) {
                ch = text.charAt(end);
            }
            if (breaks) {
                if (ch == '\u0000' || CharConstants.LINEBR.hasNo(ch)) {
                    char[] cArray;
                    String data;
                    Intrinsics.checkNotNullExpressionValue((Object)text.substring(start, end), (String)"substring(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)data.toCharArray(), (String)"toCharArray(...)");
                    for (char br : cArray) {
                        if (br == '\n') {
                            Emitter.writeLineBreak$default(this, null, 1, null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(br));
                    }
                    if (ch != '\u0000') {
                        this.writeIndent();
                    }
                    start = end;
                }
            } else if (ch == '\u0000' || CharConstants.LINEBR.has(ch)) {
                this.stream.write(text, start, end - start);
                if (ch == '\u0000') {
                    Emitter.writeLineBreak$default(this, null, 1, null);
                }
                start = end;
            }
            if (ch == '\u0000') continue;
            breaks = CharConstants.LINEBR.has(ch);
        }
    }

    private final void writePlain(String text, boolean split) {
        if (this.rootContext) {
            this.openEnded = true;
        }
        if (((CharSequence)text).length() == 0) {
            return;
        }
        if (!this.whitespace) {
            int n = this.column;
            this.column = n + 1;
            this.stream.write(SPACE);
        }
        this.whitespace = false;
        this.indention = false;
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        for (int end = 0; end <= text.length(); ++end) {
            int len;
            char ch = '\u0000';
            if (end < text.length()) {
                ch = text.charAt(end);
            }
            if (spaces) {
                if (ch != ' ') {
                    if (start + 1 == end && this.column > this.bestWidth && split) {
                        this.writeIndent();
                        this.whitespace = false;
                        this.indention = false;
                    } else {
                        len = end - start;
                        this.column += len;
                        this.stream.write(text, start, len);
                    }
                    start = end;
                }
            } else if (breaks) {
                if (CharConstants.LINEBR.hasNo(ch)) {
                    char[] cArray;
                    String data;
                    if (text.charAt(start) == '\n') {
                        Emitter.writeLineBreak$default(this, null, 1, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)text.substring(start, end), (String)"substring(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)data.toCharArray(), (String)"toCharArray(...)");
                    for (char br : cArray) {
                        this.writeLineBreak(br == '\n' ? null : String.valueOf(br));
                    }
                    this.writeIndent();
                    this.whitespace = false;
                    this.indention = false;
                    start = end;
                }
            } else if (CharConstants.LINEBR.has(ch, "\u0000 ")) {
                len = end - start;
                this.column += len;
                this.stream.write(text, start, len);
                start = end;
            }
            if (ch == '\u0000') continue;
            spaces = ch == ' ';
            breaks = CharConstants.LINEBR.has(ch);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)java.lang.Character.valueOf('\u0000'), (Object)"0"), TuplesKt.to((Object)java.lang.Character.valueOf('\u0007'), (Object)"a"), TuplesKt.to((Object)java.lang.Character.valueOf('\b'), (Object)"b"), TuplesKt.to((Object)java.lang.Character.valueOf('\t'), (Object)"t"), TuplesKt.to((Object)java.lang.Character.valueOf('\n'), (Object)"n"), TuplesKt.to((Object)java.lang.Character.valueOf('\u000b'), (Object)"v"), TuplesKt.to((Object)java.lang.Character.valueOf('\f'), (Object)"f"), TuplesKt.to((Object)java.lang.Character.valueOf('\r'), (Object)"r"), TuplesKt.to((Object)java.lang.Character.valueOf('\u001b'), (Object)"e"), TuplesKt.to((Object)java.lang.Character.valueOf('\"'), (Object)"\""), TuplesKt.to((Object)java.lang.Character.valueOf('\\'), (Object)"\\"), TuplesKt.to((Object)java.lang.Character.valueOf('\u0085'), (Object)"N"), TuplesKt.to((Object)java.lang.Character.valueOf('\u00a0'), (Object)"_")};
        ESCAPE_REPLACEMENTS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"!", (Object)"!"), TuplesKt.to((Object)"tag:yaml.org,2002:", (Object)"!!")};
        DEFAULT_TAG_PREFIXES = MapsKt.mapOf((Pair[])pairArray);
        VALID_INDENT_RANGE = new IntRange(1, 10);
        VALID_INDICATOR_INDENT_RANGE = RangesKt.until((int)(VALID_INDENT_RANGE.getFirst() - 1), (int)VALID_INDENT_RANGE.getLast());
        HANDLE_FORMAT = new Regex("^![-_\\w]*!$");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$Companion;", "", "()V", "DEFAULT_INDENT", "", "DEFAULT_TAG_PREFIXES", "", "", "DEFAULT_WIDTH", "ESCAPE_REPLACEMENTS", "", "HANDLE_FORMAT", "Lkotlin/text/Regex;", "SPACE", "VALID_INDENT_RANGE", "Lkotlin/ranges/IntRange;", "VALID_INDICATOR_INDENT_RANGE", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectBlockMappingKey;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "first", "", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;Z)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectBlockMappingKey
    implements EmitterState {
        private final boolean first;

        public ExpectBlockMappingKey(boolean first) {
            this.first = first;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (!this.first) {
                Event event = Emitter.this.event;
                if ((event != null ? event.getEventId() : null) == Event.ID.MappingEnd) {
                    Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
                    Emitter.this.state = (EmitterState)Emitter.this.states.removeLast();
                    return;
                }
            }
            Emitter.this.writeIndent();
            if (Emitter.this.checkSimpleKey()) {
                Emitter.this.states.addLast((Object)new ExpectBlockMappingSimpleValue());
                Emitter.expectNode$default(Emitter.this, false, true, true, 1, null);
                return;
            }
            Emitter.writeIndicator$default(Emitter.this, "?", true, false, true, 4, null);
            Emitter.this.states.addLast((Object)new ExpectBlockMappingValue());
            Emitter.expectNode$default(Emitter.this, false, true, false, 5, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectBlockMappingSimpleValue;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "isFoldedOrLiteral", "", "event", "Lorg/snakeyaml/engine/v2/events/Event;", "snakeyaml-engine-kmp"})
    private final class ExpectBlockMappingSimpleValue
    implements EmitterState {
        @Override
        public void expect() {
            Emitter.writeIndicator$default(Emitter.this, ":", false, false, false, 14, null);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Event event = Emitter.this.event;
            Intrinsics.checkNotNull((Object)event);
            if (!this.isFoldedOrLiteral(event) && Emitter.this.writeInlineComments()) {
                Emitter.increaseIndent$default(Emitter.this, true, false, 2, null);
                Emitter.this.writeIndent();
                Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
            }
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.increaseIndent$default(Emitter.this, true, false, 2, null);
                Emitter.this.writeBlockComment();
                Emitter.this.writeIndent();
                Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
            }
            Emitter.this.states.addLast((Object)new ExpectBlockMappingKey(false));
            Emitter.expectNode$default(Emitter.this, false, true, false, 5, null);
            Emitter.this.inlineCommentsCollector.collectEvents();
            Emitter.this.writeInlineComments();
        }

        private final boolean isFoldedOrLiteral(Event event) {
            return event instanceof ScalarEvent && (((ScalarEvent)event).getScalarStyle() == ScalarStyle.FOLDED || ((ScalarEvent)event).getScalarStyle() == ScalarStyle.LITERAL);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectBlockMappingValue;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectBlockMappingValue
    implements EmitterState {
        @Override
        public void expect() {
            Emitter.this.writeIndent();
            Emitter.writeIndicator$default(Emitter.this, ":", true, false, true, 4, null);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            Emitter.this.states.addLast((Object)new ExpectBlockMappingKey(false));
            Emitter.expectNode$default(Emitter.this, false, true, false, 5, null);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectBlockSequenceItem;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "first", "", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;Z)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectBlockSequenceItem
    implements EmitterState {
        private final boolean first;

        public ExpectBlockSequenceItem(boolean first) {
            this.first = first;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void expect() {
            if (!this.first) {
                Event event = Emitter.this.event;
                if ((event != null ? event.getEventId() : null) == Event.ID.SequenceEnd) {
                    Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
                    Emitter.this.state = (EmitterState)Emitter.this.states.removeLast();
                    return;
                }
            }
            if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                return;
            }
            Emitter.this.writeIndent();
            if (!Emitter.this.getIndentWithIndicator() || this.first) {
                Emitter.this.writeWhitespace(Emitter.this.getIndicatorIndent());
            }
            Emitter.writeIndicator$default(Emitter.this, "-", true, false, true, 4, null);
            if (Emitter.this.getIndentWithIndicator() && this.first) {
                Integer n = Emitter.this.indent;
                Intrinsics.checkNotNull((Object)n);
                Emitter.this.indent = n + Emitter.this.getIndicatorIndent();
            }
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.increaseIndent$default(Emitter.this, false, false, 3, null);
                Emitter.this.writeBlockComment();
                if (Emitter.this.event instanceof ScalarEvent) {
                    Event event = Emitter.this.event;
                    Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.ScalarEvent");
                    Emitter.this.analysis = Emitter.this.analyzeScalar(((ScalarEvent)event).getValue());
                    ScalarAnalysis scalarAnalysis = Emitter.this.analysis;
                    Intrinsics.checkNotNull((Object)scalarAnalysis);
                    if (!scalarAnalysis.getEmpty()) {
                        Emitter.this.writeIndent();
                    }
                }
                Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
            }
            Emitter.this.states.addLast((Object)new ExpectBlockSequenceItem(false));
            Emitter.expectNode$default(Emitter.this, false, false, false, 7, null);
            Emitter.this.inlineCommentsCollector.collectEvents();
            Emitter.this.writeInlineComments();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectDocumentEnd;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectDocumentEnd
    implements EmitterState {
        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.DocumentEnd) {
                Emitter.this.writeIndent();
                Event event2 = Emitter.this.event;
                Intrinsics.checkNotNull((Object)event2, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.DocumentEndEvent");
                if (((DocumentEndEvent)event2).isExplicit()) {
                    Emitter.writeIndicator$default(Emitter.this, "...", true, false, false, 12, null);
                    Emitter.this.writeIndent();
                }
            } else {
                throw new EmitterException("expected DocumentEndEvent, but got " + Emitter.this.event);
            }
            Emitter.this.flushStream();
            Emitter.this.state = new ExpectDocumentStart(false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectDocumentRoot;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectDocumentRoot
    implements EmitterState {
        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.this.writeBlockComment();
                if (Emitter.this.event instanceof DocumentEndEvent) {
                    new ExpectDocumentEnd().expect();
                    return;
                }
            }
            Emitter.this.states.addLast((Object)new ExpectDocumentEnd());
            Emitter.expectNode$default(Emitter.this, true, false, false, 6, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectDocumentStart;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "first", "", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;Z)V", "checkEmptyDocument", "checkTagHandle", "", "handle", "", "checkTagPrefix", "prefix", "expect", "handleDocumentStartEvent", "ev", "Lorg/snakeyaml/engine/v2/events/DocumentStartEvent;", "handleTagDirectives", "tags", "", "snakeyaml-engine-kmp"})
    private final class ExpectDocumentStart
    implements EmitterState {
        private final boolean first;

        public ExpectDocumentStart(boolean first) {
            this.first = first;
        }

        @Override
        public void expect() {
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.DocumentStart) {
                Event event2 = Emitter.this.event;
                Intrinsics.checkNotNull((Object)event2, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.DocumentStartEvent");
                DocumentStartEvent ev = (DocumentStartEvent)event2;
                this.handleDocumentStartEvent(ev);
                Emitter.this.state = new ExpectDocumentRoot();
            } else {
                Event event3 = Emitter.this.event;
                if ((event3 != null ? event3.getEventId() : null) == Event.ID.StreamEnd) {
                    Emitter.this.writeStreamEnd();
                    Emitter.this.state = new ExpectNothing();
                } else if (Emitter.this.event instanceof CommentEvent) {
                    Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                    Emitter.this.writeBlockComment();
                } else {
                    throw new EmitterException("expected DocumentStartEvent, but got " + Emitter.this.event);
                }
            }
        }

        private final void handleDocumentStartEvent(DocumentStartEvent ev) {
            boolean implicit;
            if ((ev.getSpecVersion() != null || !ev.getTags().isEmpty()) && Emitter.this.openEnded) {
                Emitter.writeIndicator$default(Emitter.this, "...", true, false, false, 12, null);
                Emitter.this.writeIndent();
            }
            if (ev.getSpecVersion() != null) {
                Emitter.this.writeVersionDirective(Emitter.this.prepareVersion(ev.getSpecVersion()));
            }
            Emitter.this.tagPrefixes = MapsKt.toMutableMap((Map)DEFAULT_TAG_PREFIXES);
            if (!ev.getTags().isEmpty()) {
                this.handleTagDirectives(ev.getTags());
            }
            boolean bl = implicit = this.first && !ev.getExplicit() && !Emitter.this.canonical && ev.getSpecVersion() == null && ev.getTags().isEmpty() && !this.checkEmptyDocument();
            if (!implicit) {
                Emitter.this.writeIndent();
                Emitter.writeIndicator$default(Emitter.this, "---", true, false, false, 12, null);
                if (Emitter.this.canonical) {
                    Emitter.this.writeIndent();
                }
            }
        }

        private final void handleTagDirectives(Map<String, String> tags) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                String handle = entry.getKey();
                String prefix2 = entry.getValue();
                Emitter.this.tagPrefixes.put(prefix2, handle);
                this.checkTagHandle(handle);
                this.checkTagPrefix(prefix2);
                Emitter.this.writeTagDirective(handle, prefix2);
            }
        }

        private final void checkTagHandle(String handle) {
            if (((CharSequence)handle).length() == 0) {
                throw new EmitterException("tag handle must not be empty");
            }
            if (!StringsKt.startsWith$default((CharSequence)handle, (char)'!', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)handle, (char)'!', (boolean)false, (int)2, null)) {
                throw new EmitterException("tag handle must start and end with '!': " + handle);
            }
            if (!Intrinsics.areEqual((Object)handle, (Object)"!") && !HANDLE_FORMAT.matches((CharSequence)handle)) {
                throw new EmitterException("invalid character in the tag handle: " + handle);
            }
        }

        private final void checkTagPrefix(String prefix2) {
            if (((CharSequence)prefix2).length() == 0) {
                throw new EmitterException("tag prefix must not be empty");
            }
        }

        private final boolean checkEmptyDocument() {
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) != Event.ID.DocumentStart || Emitter.this.events.isEmpty()) {
                return false;
            }
            Event nextEvent = (Event)Emitter.this.events.first();
            if (nextEvent.getEventId() == Event.ID.Scalar) {
                Intrinsics.checkNotNull((Object)nextEvent, (String)"null cannot be cast to non-null type org.snakeyaml.engine.v2.events.ScalarEvent");
                ScalarEvent e = (ScalarEvent)nextEvent;
                return e.getAnchor() == null && e.getTag() == null && ((CharSequence)e.getValue()).length() == 0;
            }
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFirstBlockMappingKey;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFirstBlockMappingKey
    implements EmitterState {
        @Override
        public void expect() {
            new ExpectBlockMappingKey(true).expect();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFirstBlockSequenceItem;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFirstBlockSequenceItem
    implements EmitterState {
        @Override
        public void expect() {
            new ExpectBlockSequenceItem(true).expect();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFirstDocumentStart;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFirstDocumentStart
    implements EmitterState {
        @Override
        public void expect() {
            new ExpectDocumentStart(true).expect();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFirstFlowMappingKey;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFirstFlowMappingKey
    implements EmitterState {
        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
                Emitter emitter = Emitter.this;
                int n = emitter.flowLevel;
                emitter.flowLevel = n + -1;
                Emitter.writeIndicator$default(Emitter.this, "}", false, false, false, 14, null);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.removeLast();
            } else {
                if (Emitter.this.canonical || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.getSplitLines() || Emitter.this.multiLineFlow) {
                    Emitter.this.writeIndent();
                }
                if (!Emitter.this.canonical && Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.addLast((Object)new ExpectFlowMappingSimpleValue());
                    Emitter.expectNode$default(Emitter.this, false, true, true, 1, null);
                } else {
                    Emitter.writeIndicator$default(Emitter.this, "?", true, false, false, 12, null);
                    Emitter.this.states.addLast((Object)new ExpectFlowMappingValue());
                    Emitter.expectNode$default(Emitter.this, false, true, false, 5, null);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFirstFlowSequenceItem;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFirstFlowSequenceItem
    implements EmitterState {
        @Override
        public void expect() {
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
                Emitter emitter = Emitter.this;
                int n = emitter.flowLevel;
                emitter.flowLevel = n + -1;
                Emitter.writeIndicator$default(Emitter.this, "]", false, false, false, 14, null);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.removeLast();
            } else if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeBlockComment();
            } else {
                if (Emitter.this.canonical || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.getSplitLines() || Emitter.this.multiLineFlow) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.states.addLast((Object)new ExpectFlowSequenceItem());
                Emitter.expectNode$default(Emitter.this, false, false, false, 7, null);
                Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeInlineComments();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFlowMappingKey;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFlowMappingKey
    implements EmitterState {
        @Override
        public void expect() {
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
                Emitter emitter = Emitter.this;
                int n = emitter.flowLevel;
                emitter.flowLevel = n + -1;
                if (Emitter.this.canonical) {
                    Emitter.writeIndicator$default(Emitter.this, ",", false, false, false, 14, null);
                    Emitter.this.writeIndent();
                }
                if (Emitter.this.multiLineFlow) {
                    Emitter.this.writeIndent();
                }
                Emitter.writeIndicator$default(Emitter.this, "}", false, false, false, 14, null);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.removeLast();
            } else {
                Emitter.writeIndicator$default(Emitter.this, ",", false, false, false, 14, null);
                Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
                Emitter.this.writeBlockComment();
                if (Emitter.this.canonical || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.getSplitLines() || Emitter.this.multiLineFlow) {
                    Emitter.this.writeIndent();
                }
                if (!Emitter.this.canonical && Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.addLast((Object)new ExpectFlowMappingSimpleValue());
                    Emitter.expectNode$default(Emitter.this, false, true, true, 1, null);
                } else {
                    Emitter.writeIndicator$default(Emitter.this, "?", true, false, false, 12, null);
                    Emitter.this.states.addLast((Object)new ExpectFlowMappingValue());
                    Emitter.expectNode$default(Emitter.this, false, true, false, 5, null);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFlowMappingSimpleValue;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFlowMappingSimpleValue
    implements EmitterState {
        @Override
        public void expect() {
            Emitter.writeIndicator$default(Emitter.this, ":", false, false, false, 14, null);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.states.addLast((Object)new ExpectFlowMappingKey());
            Emitter.expectNode$default(Emitter.this, false, true, false, 5, null);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFlowMappingValue;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFlowMappingValue
    implements EmitterState {
        @Override
        public void expect() {
            if (Emitter.this.canonical || Emitter.this.column > Emitter.this.bestWidth || Emitter.this.multiLineFlow) {
                Emitter.this.writeIndent();
            }
            Emitter.writeIndicator$default(Emitter.this, ":", true, false, false, 12, null);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.states.addLast((Object)new ExpectFlowMappingKey());
            Emitter.expectNode$default(Emitter.this, false, true, false, 5, null);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectFlowSequenceItem;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectFlowSequenceItem
    implements EmitterState {
        @Override
        public void expect() {
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.removeLastOrNull();
                Emitter emitter = Emitter.this;
                int n = emitter.flowLevel;
                emitter.flowLevel = n + -1;
                if (Emitter.this.canonical) {
                    Emitter.writeIndicator$default(Emitter.this, ",", false, false, false, 14, null);
                    Emitter.this.writeIndent();
                } else if (Emitter.this.multiLineFlow) {
                    Emitter.this.writeIndent();
                }
                Emitter.writeIndicator$default(Emitter.this, "]", false, false, false, 14, null);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                if (Emitter.this.multiLineFlow) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.state = (EmitterState)Emitter.this.states.removeLast();
            } else if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.event = Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
            } else {
                Emitter.writeIndicator$default(Emitter.this, ",", false, false, false, 14, null);
                Emitter.this.writeBlockComment();
                if (Emitter.this.canonical || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.getSplitLines() || Emitter.this.multiLineFlow) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.states.addLast((Object)new ExpectFlowSequenceItem());
                Emitter.expectNode$default(Emitter.this, false, false, false, 7, null);
                Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeInlineComments();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectNothing;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectNothing
    implements EmitterState {
        @Override
        public void expect() {
            throw new EmitterException("expecting nothing, but got " + Emitter.this.event);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/snakeyaml/engine/v2/emitter/Emitter$ExpectStreamStart;", "Lorg/snakeyaml/engine/v2/emitter/EmitterState;", "(Lorg/snakeyaml/engine/v2/emitter/Emitter;)V", "expect", "", "snakeyaml-engine-kmp"})
    private final class ExpectStreamStart
    implements EmitterState {
        @Override
        public void expect() {
            Event event = Emitter.this.event;
            if ((event != null ? event.getEventId() : null) != Event.ID.StreamStart) {
                throw new EmitterException("expected StreamStartEvent, but got " + Emitter.this.event);
            }
            Emitter.this.writeStreamStart();
            Emitter.this.state = new ExpectFirstDocumentStart();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Event.ID.values().length];
            try {
                nArray[Event.ID.Alias.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Event.ID.Scalar.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Event.ID.SequenceStart.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Event.ID.MappingStart.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScalarStyle.values().length];
            try {
                nArray[ScalarStyle.DOUBLE_QUOTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScalarStyle.SINGLE_QUOTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScalarStyle.FOLDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScalarStyle.LITERAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

