/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.serializer;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.comments.CommentLine;
import org.snakeyaml.engine.v2.common.Anchor;
import org.snakeyaml.engine.v2.emitter.Emitable;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.CommentEvent;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.ImplicitTuple;
import org.snakeyaml.engine.v2.events.MappingEndEvent;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceEndEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamEndEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;
import org.snakeyaml.engine.v2.nodes.AnchorNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/snakeyaml/engine/v2/serializer/Serializer;", "", "settings", "Lorg/snakeyaml/engine/v2/api/DumpSettings;", "emitable", "Lorg/snakeyaml/engine/v2/emitter/Emitable;", "(Lorg/snakeyaml/engine/v2/api/DumpSettings;Lorg/snakeyaml/engine/v2/emitter/Emitable;)V", "anchors", "", "Lorg/snakeyaml/engine/v2/nodes/Node;", "Lorg/snakeyaml/engine/v2/common/Anchor;", "serializedNodes", "", "anchorNode", "", "node", "emitStreamEnd", "emitStreamStart", "serializeComments", "comments", "", "Lorg/snakeyaml/engine/v2/comments/CommentLine;", "serializeDocument", "serializeNode", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Serializer.kt\norg/snakeyaml/engine/v2/serializer/Serializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,203:1\n372#2,7:204\n*S KotlinDebug\n*F\n+ 1 Serializer.kt\norg/snakeyaml/engine/v2/serializer/Serializer\n*L\n76#1:204,7\n*E\n"})
public final class Serializer {
    @NotNull
    private final DumpSettings settings;
    @NotNull
    private final Emitable emitable;
    @NotNull
    private final Set<Node> serializedNodes;
    @NotNull
    private final Map<Node, Anchor> anchors;

    public Serializer(@NotNull DumpSettings settings, @NotNull Emitable emitable) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)emitable, (String)"emitable");
        this.settings = settings;
        this.emitable = emitable;
        this.serializedNodes = new LinkedHashSet();
        this.anchors = new LinkedHashMap();
    }

    public final void serializeDocument(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.emitable.emit(new DocumentStartEvent(this.settings.isExplicitStart(), this.settings.yamlDirective, this.settings.tagDirective, null, null, 24, null));
        this.anchorNode(node);
        if (this.settings.explicitRootTag != null) {
            node.setTag(this.settings.explicitRootTag);
        }
        this.serializeNode(node);
        this.emitable.emit(new DocumentEndEvent(this.settings.isExplicitEnd(), null, null, 6, null));
        this.serializedNodes.clear();
        this.anchors.clear();
    }

    public final void emitStreamStart() {
        this.emitable.emit(new StreamStartEvent());
    }

    public final void emitStreamEnd() {
        this.emitable.emit(new StreamEndEvent());
    }

    private final void anchorNode(Node node) {
        Node realNode;
        Node node2 = realNode = node instanceof AnchorNode ? ((AnchorNode)node).getRealNode() : node;
        if (this.anchors.containsKey(realNode)) {
            Map<Node, Anchor> $this$getOrPut$iv = this.anchors;
            boolean $i$f$getOrPut = false;
            Anchor value$iv = $this$getOrPut$iv.get(realNode);
            if (value$iv == null) {
                boolean bl = false;
                Anchor answer$iv = this.settings.anchorGenerator.nextAnchor(realNode);
                $this$getOrPut$iv.put(realNode, answer$iv);
            }
        } else {
            this.anchors.put(realNode, realNode.getAnchor() != null ? this.settings.anchorGenerator.nextAnchor(realNode) : null);
            switch (WhenMappings.$EnumSwitchMapping$0[realNode.getNodeType().ordinal()]) {
                case 1: {
                    if (!(realNode instanceof SequenceNode)) {
                        String bl = "Failed requirement.";
                        throw new IllegalArgumentException(bl.toString());
                    }
                    for (Node item : ((SequenceNode)realNode).getValue()) {
                        this.anchorNode(item);
                    }
                    break;
                }
                case 2: {
                    if (!(realNode instanceof MappingNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    for (NodeTuple nodeTuple : ((MappingNode)realNode).getValue()) {
                        Node key = nodeTuple.component1();
                        Node value = nodeTuple.component2();
                        this.anchorNode(key);
                        this.anchorNode(value);
                    }
                    break;
                }
            }
        }
    }

    private final void serializeNode(Node node) {
        Node realNode = node instanceof AnchorNode ? ((AnchorNode)node).getRealNode() : node;
        Anchor tAlias = this.anchors.get(realNode);
        if (this.serializedNodes.contains(realNode)) {
            this.emitable.emit(new AliasEvent(tAlias, null, null, 6, null));
        } else {
            this.serializedNodes.add(realNode);
            switch (WhenMappings.$EnumSwitchMapping$0[realNode.getNodeType().ordinal()]) {
                case 3: {
                    if (!(realNode instanceof ScalarNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.serializeComments(realNode.getBlockComments());
                    Tag detectedTag = this.settings.schema.getScalarResolver().resolve(((ScalarNode)realNode).getValue(), true);
                    Tag defaultTag = this.settings.schema.getScalarResolver().resolve(((ScalarNode)realNode).getValue(), false);
                    ImplicitTuple tuple = new ImplicitTuple(Intrinsics.areEqual((Object)realNode.getTag(), (Object)detectedTag), Intrinsics.areEqual((Object)realNode.getTag(), (Object)defaultTag));
                    ScalarEvent event = new ScalarEvent(tAlias, realNode.getTag().getValue(), tuple, ((ScalarNode)realNode).getValue(), ((ScalarNode)realNode).getScalarStyle(), null, null, 96, null);
                    this.emitable.emit(event);
                    this.serializeComments(realNode.getInLineComments());
                    this.serializeComments(realNode.getEndComments());
                    break;
                }
                case 1: {
                    if (!(realNode instanceof SequenceNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.serializeComments(realNode.getBlockComments());
                    boolean implicitS = Intrinsics.areEqual((Object)realNode.getTag(), (Object)Tag.SEQ);
                    this.emitable.emit(new SequenceStartEvent(tAlias, realNode.getTag().getValue(), implicitS, ((SequenceNode)realNode).getFlowStyle(), null, null, 48, null));
                    for (Node item : ((SequenceNode)realNode).getValue()) {
                        this.serializeNode(item);
                    }
                    this.emitable.emit(new SequenceEndEvent());
                    this.serializeComments(realNode.getInLineComments());
                    this.serializeComments(realNode.getEndComments());
                    break;
                }
                case 2: {
                    if (!(realNode instanceof MappingNode)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.serializeComments(realNode.getBlockComments());
                    if (Intrinsics.areEqual((Object)realNode.getTag(), (Object)Tag.COMMENT)) break;
                    this.emitable.emit(new MappingStartEvent(tAlias, realNode.getTag().getValue(), Intrinsics.areEqual((Object)realNode.getTag(), (Object)Tag.MAP), ((MappingNode)realNode).getFlowStyle(), null, null));
                    for (NodeTuple nodeTuple : ((MappingNode)realNode).getValue()) {
                        Node key = nodeTuple.component1();
                        Node value = nodeTuple.component2();
                        this.serializeNode(key);
                        this.serializeNode(value);
                    }
                    this.emitable.emit(new MappingEndEvent());
                    this.serializeComments(realNode.getInLineComments());
                    this.serializeComments(realNode.getEndComments());
                }
            }
        }
    }

    private final void serializeComments(List<CommentLine> comments) {
        if (comments == null) {
            return;
        }
        for (CommentLine line : comments) {
            CommentEvent commentEvent = new CommentEvent(line.commentType, line.value, line.startMark, line.endMark);
            this.emitable.emit(commentEvent);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NodeType.values().length];
            try {
                nArray[NodeType.SEQUENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.MAPPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.SCALAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.ANCHOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

